/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessBorderFactory {
    public static Border getControlBorderWithMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), new BasicBorders.MarginBorder())));
    }

    public static Border getNonSpacingControlBorderWithMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), new BasicBorders.MarginBorder()));
    }

    public static Border getControlBorderWithoutMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)));
    }

    public static Border getProgressBarBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new ControlBorder());
    }

    public static Border getNonSpacingControlBorderWithoutMargin() {
        return new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1));
    }

    public static Border getButtonRolloverBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ButtonRolloverBorder(), new RolloverMarginBorder()));
    }

    public static Border getButtonNonRolloverBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ParentBackgroundBorder(), new BorderUIResource.CompoundBorderUIResource(new ControlBorder(), new RolloverMarginBorder()));
    }

    public static Border getTableHeaderCellBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new TableHeaderCellBorder(), new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2));
    }

    public static Border getMenuItemBorder() {
        return new MenuItemBorder();
    }

    public static Border getInternalFrameBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new InternalFrameBorder(), new BorderUIResource.LineBorderUIResource(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor(), 1));
    }

    private static class MenuItemBorder
    extends ControlBorder {
        private MenuItemBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            JMenuItem menuItem = (JMenuItem)component;
            ButtonModel model = menuItem.getModel();
            if (model.isArmed() || menuItem instanceof JMenu && menuItem.isSelected()) {
                super.paintBorder(component, graphics, x, y, width, height);
            }
        }
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets margin = null;
            if (component instanceof AbstractButton) {
                margin = ((AbstractButton)component).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    private static class ButtonRolloverBorder
    extends ControlBorder {
        private ButtonRolloverBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            AbstractButton button = (AbstractButton)component;
            ButtonModel model = button.getModel();
            boolean isRollover = (Boolean)button.getClientProperty("SquarenessRollover");
            if (button.isEnabled() && (isRollover || model.isArmed() && model.isPressed() || button.hasFocus() || button.isSelected())) {
                super.paintBorder(component, graphics, x, y, width, height);
            }
        }
    }

    private static class TableHeaderCellBorder
    extends AbstractBorder
    implements UIResource {
        private TableHeaderCellBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            Color oldColor = graphics.getColor();
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor().darker());
            graphics.drawLine(x + width - 2, y + 3, x + width - 2, y + height - 4);
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor().brighter());
            graphics.drawLine(x + width - 1, y + 3, x + width - 1, y + height - 4);
            graphics.setColor(oldColor);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private InternalFrameBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            Color oldColor = graphics.getColor();
            if (component instanceof JInternalFrame) {
                JInternalFrame internalFrame = (JInternalFrame)component;
                if (internalFrame.isSelected()) {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
                } else {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
                }
            } else if (component instanceof JFrame) {
                JFrame frame = (JFrame)component;
                if (frame.isActive()) {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
                } else {
                    graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getInactiveWindowBorderColor());
                }
            }
            graphics.translate(x, y);
            graphics.drawLine(0, 0, width - 1, 0);
            graphics.drawLine(0, 0, 0, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.drawLine(width - 1, y, width - 1, height - 1);
            if (this.getBorderInsets((Component)component).top == 2) {
                graphics.drawLine(1, 1, width - 2, 1);
                graphics.drawLine(1, 1, 1, height - 2);
                graphics.drawLine(1, height - 2, width - 2, height - 2);
                graphics.drawLine(width - 2, y, width - 2, height - 2);
            }
            graphics.translate(-x, -y);
            graphics.setColor(oldColor);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = component instanceof JInternalFrame && ((JInternalFrame)component).getClientProperty("JInternalFrame.isPalette") != null ? 1 : 2;
            insets.bottom = insets.top;
            insets.right = insets.top;
            insets.left = insets.top;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class ParentBackgroundBorder
    extends AbstractBorder
    implements UIResource {
        private ParentBackgroundBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            Color oldColor = graphics.getColor();
            graphics.setColor(component.getParent() != null ? component.getParent().getBackground() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
            graphics.drawLine(x, y, x + width - 1, y);
            graphics.drawLine(x, y, x, y + height - 1);
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            graphics.setColor(oldColor);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class ControlBorder
    extends AbstractBorder
    implements UIResource {
        private ControlBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            Color oldColor = graphics.getColor();
            if (!component.isEnabled()) {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getDisabledBorderColor());
            } else if (component instanceof JButton && ((JButton)component).isDefaultButton()) {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getDefaultButtonBorderColor());
            } else {
                graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
            }
            graphics.drawLine(x, y, x + width - 1, y);
            graphics.drawLine(x, y, x, y + height - 1);
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            graphics.setColor(oldColor);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

