/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.awt.Container;
import java.util.EventObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.internal.swing.BrowserLocationChangedEvent;
import org.eclipse.swt.internal.swing.BrowserLocationChangingEvent;
import org.eclipse.swt.internal.swing.CBrowser;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;

public class Browser
extends Composite {
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static final String ABOUT_BLANK = "about:blank";
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";

    public Browser(Composite composite, int n2) {
        super(composite, n2 & 0xFFFFF7FF);
    }

    public static void clearSessions() {
        Utils.notImplemented();
    }

    public void addCloseWindowListener(CloseWindowListener closeWindowListener) {
        this.checkWidget();
        if (closeWindowListener == null) {
            SWT.error(4);
        }
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = closeWindowListenerArray;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = closeWindowListener;
    }

    public void addLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error(4);
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, this.locationListeners.length);
        this.locationListeners = locationListenerArray;
        this.locationListeners[this.locationListeners.length - 1] = locationListener;
    }

    public void addOpenWindowListener(OpenWindowListener openWindowListener) {
        this.checkWidget();
        if (openWindowListener == null) {
            SWT.error(4);
        }
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, this.openWindowListeners.length);
        this.openWindowListeners = openWindowListenerArray;
        this.openWindowListeners[this.openWindowListeners.length - 1] = openWindowListener;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error(4);
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, this.progressListeners.length);
        this.progressListeners = progressListenerArray;
        this.progressListeners[this.progressListeners.length - 1] = progressListener;
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error(4);
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, this.statusTextListeners.length);
        this.statusTextListeners = statusTextListenerArray;
        this.statusTextListeners[this.statusTextListeners.length - 1] = statusTextListener;
    }

    public void addTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error(4);
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, this.titleListeners.length);
        this.titleListeners = titleListenerArray;
        this.titleListeners[this.titleListeners.length - 1] = titleListener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        this.checkWidget();
        if (visibilityWindowListener == null) {
            SWT.error(4);
        }
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = visibilityWindowListener;
    }

    public boolean back() {
        this.checkWidget();
        return ((CBrowser)((Object)this.handle)).back();
    }

    protected void checkSubclass() {
        int n2;
        String string = this.getClass().getName();
        if (!string.substring(0, (n2 = string.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    protected Container createHandle() {
        return (Container)((Object)CBrowser.Factory.newInstance(this, this.getStyle()));
    }

    public boolean execute(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return false;
    }

    public boolean forward() {
        this.checkWidget();
        return ((CBrowser)((Object)this.handle)).forward();
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return ((CBrowser)((Object)this.handle)).isBackEnabled();
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return ((CBrowser)((Object)this.handle)).isForwardEnabled();
    }

    public String getUrl() {
        this.checkWidget();
        return ((CBrowser)((Object)this.handle)).getURL();
    }

    public void refresh() {
        this.checkWidget();
        ((CBrowser)((Object)this.handle)).refresh();
    }

    public void removeCloseWindowListener(CloseWindowListener closeWindowListener) {
        this.checkWidget();
        if (closeWindowListener == null) {
            SWT.error(4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.closeWindowListeners.length; ++i2) {
            if (closeWindowListener != this.closeWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] closeWindowListenerArray = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, closeWindowListenerArray, 0, n2);
        System.arraycopy(this.closeWindowListeners, n2 + 1, closeWindowListenerArray, n2, this.closeWindowListeners.length - n2 - 1);
        this.closeWindowListeners = closeWindowListenerArray;
    }

    public void removeLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.locationListeners.length; ++i2) {
            if (locationListener != this.locationListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, n2);
        System.arraycopy(this.locationListeners, n2 + 1, locationListenerArray, n2, this.locationListeners.length - n2 - 1);
        this.locationListeners = locationListenerArray;
    }

    public void removeOpenWindowListener(OpenWindowListener openWindowListener) {
        this.checkWidget();
        if (openWindowListener == null) {
            SWT.error(4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.openWindowListeners.length; ++i2) {
            if (openWindowListener != this.openWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] openWindowListenerArray = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, openWindowListenerArray, 0, n2);
        System.arraycopy(this.openWindowListeners, n2 + 1, openWindowListenerArray, n2, this.openWindowListeners.length - n2 - 1);
        this.openWindowListeners = openWindowListenerArray;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.progressListeners.length; ++i2) {
            if (progressListener != this.progressListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, n2);
        System.arraycopy(this.progressListeners, n2 + 1, progressListenerArray, n2, this.progressListeners.length - n2 - 1);
        this.progressListeners = progressListenerArray;
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.statusTextListeners.length; ++i2) {
            if (statusTextListener != this.statusTextListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, n2);
        System.arraycopy(this.statusTextListeners, n2 + 1, statusTextListenerArray, n2, this.statusTextListeners.length - n2 - 1);
        this.statusTextListeners = statusTextListenerArray;
    }

    public void removeTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error(4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.titleListeners.length; ++i2) {
            if (titleListener != this.titleListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, n2);
        System.arraycopy(this.titleListeners, n2 + 1, titleListenerArray, n2, this.titleListeners.length - n2 - 1);
        this.titleListeners = titleListenerArray;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        this.checkWidget();
        if (visibilityWindowListener == null) {
            SWT.error(4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.visibilityWindowListeners.length; ++i2) {
            if (visibilityWindowListener != this.visibilityWindowListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] visibilityWindowListenerArray = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, visibilityWindowListenerArray, 0, n2);
        System.arraycopy(this.visibilityWindowListeners, n2 + 1, visibilityWindowListenerArray, n2, this.visibilityWindowListeners.length - n2 - 1);
        this.visibilityWindowListeners = visibilityWindowListenerArray;
    }

    public boolean setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return ((CBrowser)((Object)this.handle)).setText(string);
    }

    public boolean setUrl(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return ((CBrowser)((Object)this.handle)).setURL(string);
    }

    public void stop() {
        this.checkWidget();
        ((CBrowser)((Object)this.handle)).stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (!(eventObject instanceof BrowserLocationChangingEvent) && !(eventObject instanceof BrowserLocationChangedEvent)) {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof BrowserLocationChangingEvent) {
                BrowserLocationChangingEvent browserLocationChangingEvent = (BrowserLocationChangingEvent)eventObject;
                LocationEvent locationEvent = new LocationEvent(this);
                locationEvent.display = this.getDisplay();
                locationEvent.widget = this;
                locationEvent.location = browserLocationChangingEvent.getURL();
                locationEvent.doit = true;
                for (int i2 = 0; i2 < this.locationListeners.length; ++i2) {
                    this.locationListeners[i2].changing(locationEvent);
                }
                if (!locationEvent.doit) {
                    browserLocationChangingEvent.consume();
                }
            } else if (eventObject instanceof BrowserLocationChangedEvent) {
                BrowserLocationChangedEvent browserLocationChangedEvent = (BrowserLocationChangedEvent)eventObject;
                LocationEvent locationEvent = new LocationEvent(this);
                locationEvent.display = this.getDisplay();
                locationEvent.widget = this;
                locationEvent.location = browserLocationChangedEvent.getURL();
                for (int i3 = 0; i3 < this.locationListeners.length; ++i3) {
                    this.locationListeners[i3].changed(locationEvent);
                }
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

