/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CSlider;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;

class CSliderImplementation
extends JScrollBar
implements CSlider {
    protected Slider handle;
    protected CControl.UserAttributeHandler userAttributeHandler;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CSliderImplementation(Slider slider, int n2) {
        super((n2 & 0x100) != 0 ? 0 : 1);
        this.handle = slider;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.init(n2);
    }

    protected void init(int n2) {
        this.setMaximum(100);
        this.setValue(0);
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e2) {
                CSliderImplementation.this.handle.processEvent(e2);
            }
        });
    }

    public Container getClientArea() {
        return this;
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return this.getOrientation() == 0 ? new Dimension(170, super.getPreferredSize().height) : new Dimension(super.getPreferredSize().width, 170);
        }
        return super.getPreferredSize();
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
            }
        }
    }
}

