/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.text.View;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;

public class JMultiLineLabel
extends JPanel
implements SwingConstants {
    protected String text = "";
    protected int mnemonicIndex = -1;
    protected boolean isWrapping;
    protected int alignment = 2;

    public JMultiLineLabel() {
        this.setLayout(new BoxLayout(this, 1));
        LookAndFeelUtils.applyLabelStyle(this);
        this.setOpaque(false);
        this.createContent();
    }

    public int getPreferredWidth() {
        int n2 = 0;
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            InnerLabel innerLabel = (InnerLabel)this.getComponent(i2);
            String string = innerLabel.getText();
            String string2 = innerLabel.getNonHtmlText();
            innerLabel.setText(string2);
            n2 = Math.max(n2, innerLabel.getPreferredSize().width);
            innerLabel.setText(string);
        }
        return n2;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setText(String string, int n2) {
        if (string == null) {
            string = "";
        }
        if (this.text.equals(string) && this.mnemonicIndex == n2) {
            return;
        }
        this.text = string;
        this.mnemonicIndex = n2;
        this.createContent();
    }

    protected void createContent() {
        this.removeAll();
        String[] stringArray = this.text.split("\n");
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            String string2 = string = stringArray[i2];
            boolean bl = this.isWrapping();
            if (bl) {
                string2 = "<html>" + Utils.escapeSwingXML(string2) + "</html>";
            }
            InnerLabel innerLabel = new InnerLabel(string2, this.alignment, string);
            innerLabel.setHorizontalAlignment(this.alignment);
            if (!bl) {
                innerLabel.putClientProperty("html", null);
            }
            innerLabel.setText(string2);
            int n3 = n2 + string2.length() + 1;
            if (n2 < this.mnemonicIndex && n3 > this.mnemonicIndex) {
                innerLabel.setDisplayedMnemonicIndex(this.mnemonicIndex - n2);
            }
            n2 = n3;
            this.add(innerLabel);
        }
        this.adjustStyles();
        this.revalidate();
        this.repaint();
    }

    public void setWrapping(boolean bl) {
        if (this.isWrapping == bl) {
            return;
        }
        this.isWrapping = bl;
        this.createContent();
    }

    public boolean isWrapping() {
        return this.isWrapping;
    }

    public void setHorizontalAlignment(int n2) {
        this.alignment = n2;
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            ((InnerLabel)this.getComponent(i2)).setHorizontalAlignment(n2);
        }
    }

    public void setIcon(Icon icon) {
        if (this.getComponentCount() > 0) {
            ((InnerLabel)this.getComponent(0)).setIcon(icon);
        }
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            this.getComponent(i2).invalidate();
        }
        this.validate();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            Dimension dimension2 = this.getComponent(i2).getPreferredSize();
            dimension.height += dimension2.height;
            dimension.width = Math.max(dimension.width, dimension2.width);
        }
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.adjustStyles();
    }

    public void adjustStyles() {
        if (!this.isWrapping()) {
            return;
        }
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            InnerLabel innerLabel = (InnerLabel)this.getComponent(i2);
            innerLabel.updateUI();
            innerLabel.reshape(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected static class InnerLabel
    extends JLabel {
        protected String nonHtmlText;

        public InnerLabel(String text, int alignment, String nonHtmlText) {
            super(text, alignment);
            this.nonHtmlText = nonHtmlText;
        }

        public String getNonHtmlText() {
            return this.nonHtmlText;
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (this.getIcon() == null && this.getText().length() == 0) {
                preferredSize.height += this.getFontMetrics(this.getFont()).getHeight();
            }
            return preferredSize;
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, super.getMaximumSize().height);
        }

        public void reshape(int x, int y, int w2, int h2) {
            super.reshape(x, y, w2, h2);
            View globalView = (View)this.getClientProperty("html");
            if (globalView != null) {
                Border border = this.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets(this);
                    w2 -= insets.left + insets.right;
                    h2 -= insets.top + insets.bottom;
                }
                globalView.setSize(w2, h2);
            }
        }

        public Font getFont() {
            Container parent = this.getParent();
            return parent == null ? super.getFont() : parent.getFont();
        }

        public Color getBackground() {
            Container parent = this.getParent();
            return parent == null ? super.getBackground() : parent.getBackground();
        }

        public Color getForeground() {
            Container parent = this.getParent();
            return parent == null ? super.getForeground() : parent.getForeground();
        }

        public boolean isEnabled() {
            Container parent = this.getParent();
            return parent == null ? super.isEnabled() : parent.isEnabled();
        }
    }
}

