/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            RECT rECT = new RECT();
            if ((this.style & 0x200) != 0) {
                int n3 = OS.GetThemeSysSize((int)n2, (int)2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n3;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n3;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                int n4 = rectangle.height - 2 * n3;
                int n5 = Math.max(n3 / 2, n4 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n6 = rectangle.y + n3 + Math.max(0, n4 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n3;
                rECT.bottom = n6;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n5;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)9, (int)nArray[1], (RECT)rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n3;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            } else {
                int n7 = OS.GetThemeSysSize((int)n2, (int)2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n7;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n7;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                int n8 = rectangle.width - 2 * n7;
                int n9 = Math.max(n7 / 2, n8 * this.thumb / (this.maximum - this.minimum));
                int n10 = rectangle.x + n7 + Math.max(0, n8 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n7;
                rECT.right = n10;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                rECT.left = rECT.right;
                rECT.right = rECT.left + n9;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)8, (int)nArray[1], (RECT)rECT, null);
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n7;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            }
            OS.CloseThemeData((int)n2);
        }
    }

    char[] getClassId() {
        return SCROLLBAR;
    }

    int[] getPartId(int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.state[n2];
        switch (n2) {
            case 1: {
                n3 = 1;
                if ((this.style & 0x200) != 0) {
                    n4 = 1;
                    if ((n5 & 0x40) != 0) {
                        n4 = 2;
                    }
                    if ((n5 & 8) != 0) {
                        n4 = 3;
                    }
                    if ((n5 & 0x20) == 0) break;
                    n4 = 4;
                    break;
                }
                n4 = 9;
                if ((n5 & 0x40) != 0) {
                    n4 = 10;
                }
                if ((n5 & 8) != 0) {
                    n4 = 11;
                }
                if ((n5 & 0x20) == 0) break;
                n4 = 12;
                break;
            }
            case 2: {
                n3 = 1;
                if ((this.style & 0x200) != 0) {
                    n4 = 5;
                    if ((n5 & 0x40) != 0) {
                        n4 = 6;
                    }
                    if ((n5 & 8) != 0) {
                        n4 = 7;
                    }
                    if ((n5 & 0x20) == 0) break;
                    n4 = 8;
                    break;
                }
                n4 = 13;
                if ((n5 & 0x40) != 0) {
                    n4 = 14;
                }
                if ((n5 & 8) != 0) {
                    n4 = 15;
                }
                if ((n5 & 0x20) == 0) break;
                n4 = 16;
                break;
            }
            case 0: 
            case 5: {
                if ((this.style & 0x200) != 0) {
                    n3 = 3;
                    break;
                }
                n3 = 2;
                break;
            }
            case 3: {
                if ((this.style & 0x200) != 0) {
                    n3 = 7;
                    break;
                }
                n3 = 5;
                break;
            }
            case 4: {
                n3 = (this.style & 0x200) != 0 ? 6 : 4;
            }
        }
        if (n2 != 2 && n2 != 1) {
            n4 = 1;
            if ((n5 & 0x40) != 0) {
                n4 = 2;
            }
            if ((n5 & 8) != 0) {
                n4 = 3;
            }
            if ((n5 & 0x20) != 0) {
                n4 = 4;
            }
        }
        return new int[]{n3, n4};
    }

    Rectangle getBounds(int n2, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n3 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n4 = OS.GetThemeSysSize((int)n3, (int)2);
                int n5 = rectangle.height - 2 * n4;
                int n6 = Math.max(n4 / 2, n5 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n7 = rectangle.y + n4 + Math.max(0, n5 * this.selection / Math.max(1, this.maximum - this.minimum));
                switch (n2) {
                    case 2: {
                        return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n4, rectangle.width, n4);
                    }
                    case 1: {
                        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n4);
                    }
                    case 3: {
                        return new Rectangle(rectangle.x, rectangle.y + n4, rectangle.width, n7 - rectangle.y - n4);
                    }
                    case 5: {
                        return new Rectangle(rectangle.x, n7, rectangle.width, n6);
                    }
                    case 4: {
                        return new Rectangle(rectangle.x, n7 + n6, rectangle.width, rectangle.y + rectangle.height - n4 - n7 - n6);
                    }
                }
            }
            OS.CloseThemeData((int)n3);
        }
        return super.getBounds(n2, rectangle);
    }

    int getSelection(Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n3 = OS.GetThemeSysSize((int)n2, (int)2);
                int n4 = rectangle.height - 2 * n3;
                int n5 = rectangle.y + n3 + Math.max(0, n4 * this.selection / Math.max(1, this.maximum - this.minimum));
                int n6 = ((n5 += point.y) - rectangle.y - n3) * (this.maximum - this.minimum) / n4;
                return Math.max(0, Math.min(n6, this.maximum - this.thumb));
            }
            OS.CloseThemeData((int)n2);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        int n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
        int n3 = 0;
        RECT rECT = new RECT();
        POINT pOINT = new POINT();
        pOINT.x = point.x;
        pOINT.y = point.y;
        short[] sArray = new short[1];
        try {
            if ((this.style & 0x200) != 0) {
                int n4 = OS.GetThemeSysSize((int)n2, (int)2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n4;
                int[] nArray = this.getPartId(1);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n5 = 1;
                    return n5;
                }
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n4;
                nArray = this.getPartId(2);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n6 = 2;
                    return n6;
                }
                int n7 = rectangle.height - 2 * n4;
                int n8 = Math.max(n4 / 2, n7 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n9 = rectangle.y + n4 + Math.max(0, n7 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n4;
                rECT.bottom = n9;
                nArray = this.getPartId(5);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n10 = 3;
                    return n10;
                }
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n8;
                nArray = this.getPartId(3);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n11 = 5;
                    return n11;
                }
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n4;
                nArray = this.getPartId(4);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n12 = 4;
                    return n12;
                }
            } else {
                int n13 = OS.GetThemeSysSize((int)n2, (int)2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n13;
                int[] nArray = this.getPartId(1);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n14 = 1;
                    return n14;
                }
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n13;
                nArray = this.getPartId(2);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n15 = 2;
                    return n15;
                }
                int n16 = rectangle.width - 2 * n13;
                int n17 = Math.max(n13 / 2, n16 * this.thumb / (this.maximum - this.minimum));
                int n18 = rectangle.x + n13 + Math.max(0, n16 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n13;
                rECT.right = n18;
                nArray = this.getPartId(3);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n19 = 3;
                    return n19;
                }
                rECT.left = rECT.right;
                rECT.right = rECT.left + n17;
                nArray = this.getPartId(5);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n20 = 5;
                    return n20;
                }
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n13;
                nArray = this.getPartId(4);
                OS.HitTestThemeBackground((int)n2, (int)n3, (int)nArray[0], (int)nArray[1], (int)0, (RECT)rECT, (int)0, (POINT)pOINT, (short[])sArray);
                if (sArray[0] != 0) {
                    int n21 = 4;
                    return n21;
                }
            }
        }
        finally {
            OS.CloseThemeData((int)n2);
        }
        return -1;
    }
}

