/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CButton;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    Image image;
    ImageList imageList;
    boolean ignoreMouse;
    String text;
    boolean isAdjustingSelection;

    public Button(Composite composite, int n2) {
        super(composite, Button.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        if (((n2 = Button.checkBits(n2, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n2, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n2 & 0x30) != 0) {
            return Button.checkBits(n2, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n2 & 4) != 0) {
            return Button.checkBits(n2 |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n2;
    }

    void click() {
        ((CButton)((Object)this.handle)).doClick();
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        Point point = super.computeSize(n2, n3, bl);
        if ((this.style & 4) != 0) {
            if (n2 == -1) {
                point.x = point.y;
            } else if (n3 == -1) {
                point.y = point.x;
            } else {
                point.x = point.y;
            }
        }
        return point;
    }

    Container createHandle() {
        return (Container)((Object)CButton.Factory.newInstance(this, this.style));
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return ((CButton)((Object)this.handle)).isSelected();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text == null ? "" : this.text;
    }

    boolean isTabItem() {
        return super.isTabItem();
    }

    boolean isTabGroup() {
        return (this.style & 0x10) == 0;
    }

    boolean mnemonicHit(char c2) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c2) {
        char c3 = this.findMnemonic(this.getText());
        if (c3 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n2 & 0x24480;
            if ((n2 & 0x80) != 0) {
                ((CButton)((Object)this.handle)).setAlignment(1);
            } else if ((n2 & 0x400) != 0) {
                ((CButton)((Object)this.handle)).setAlignment(5);
            } else if ((n2 & 0x4000) != 0) {
                ((CButton)((Object)this.handle)).setAlignment(7);
            } else if ((n2 & 0x20000) != 0) {
                ((CButton)((Object)this.handle)).setAlignment(3);
            }
            return;
        }
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        if ((n2 & 0x4000) != 0) {
            ((CButton)((Object)this.handle)).setAlignment(2);
        } else if ((n2 & 0x20000) != 0) {
            ((CButton)((Object)this.handle)).setAlignment(4);
        } else if ((n2 & 0x1000000) != 0) {
            ((CButton)((Object)this.handle)).setAlignment(0);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.image = image;
        ImageIcon imageIcon = null;
        if (image != null && image.handle != null) {
            imageIcon = new ImageIcon(image.handle);
        }
        ((CButton)((Object)this.handle)).setIcon(imageIcon);
    }

    boolean setRadioFocus() {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return this.setFocus();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        this.isAdjustingSelection = true;
        ((CButton)((Object)this.handle)).setSelected(bl);
        this.isAdjustingSelection = false;
    }

    public void setText(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        int n2 = this.findMnemonicIndex(string);
        if (n2 > 0) {
            object = string.substring(0, n2 - 1).replaceAll("&&", "&");
            string = (String)object + string.substring(n2).replaceAll("&&", "&");
            n2 -= n2 - 1 - ((String)object).length();
            --n2;
        } else {
            string = string.replaceAll("&&", "&");
        }
        object = (CButton)((Object)this.handle);
        object.setText(string);
        if (n2 >= 0) {
            object.setMnemonic(string.charAt(n2));
        }
        object.setDisplayedMnemonicIndex(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        block2 : switch (n2) {
            case 1001: {
                if ((this.style & 0x10) != 0 || !this.isAdjustingSelection && this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 701: {
                if (!this.isAdjustingSelection && this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 401: {
                if ((this.style & 0x10) == 0) break;
                switch (((KeyEvent)aWTEvent).getKeyCode()) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break block2;
                    }
                }
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            block10 : switch (n2) {
                case 1001: {
                    if ((this.style & 0x10) != 0) {
                        if (!this.getSelection()) {
                            ((CButton)((Object)this.handle)).setSelected(true);
                        }
                        if ((this.parent.getStyle() & 0x400000) == 0) {
                            Component[] componentArray = this.handle.getParent().getComponents();
                            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                                JRadioButton jRadioButton;
                                Component component = componentArray[i2];
                                if (!(component instanceof JRadioButton) || component == this.handle || !(jRadioButton = (JRadioButton)component).isSelected()) continue;
                                jRadioButton.setSelected(false);
                                if (this.isAdjustingSelection || !this.hooks(13)) continue;
                                ((CControl)((Object)jRadioButton)).getSWTHandle().sendEvent(13);
                            }
                        }
                    }
                    if (this.isAdjustingSelection || !this.hooks(13)) break;
                    this.sendEvent(13);
                    break;
                }
                case 701: {
                    if (!this.hooks(13)) break;
                    this.sendEvent(13);
                    break;
                }
                case 401: {
                    if ((this.style & 0x10) == 0) break;
                    boolean bl = false;
                    switch (((KeyEvent)aWTEvent).getKeyCode()) {
                        case 37: 
                        case 38: {
                            bl = true;
                        }
                        case 39: 
                        case 40: {
                            Component component;
                            Component[] componentArray = this.handle.getParent().getComponents();
                            int n3 = 0;
                            for (n3 = 0; n3 < componentArray.length && (component = componentArray[n3]) != this.handle; ++n3) {
                            }
                            for (int i3 = 0; i3 < componentArray.length; ++i3) {
                                Component component2 = bl ? componentArray[(componentArray.length - i3 + n3 - 1) % componentArray.length] : componentArray[(i3 + n3 + 1) % componentArray.length];
                                if (!(component2 instanceof JRadioButton)) continue;
                                if (component2 == this.handle) break block10;
                                ((JRadioButton)component2).requestFocus();
                                break block10;
                            }
                        }
                    }
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

