/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CToolBar;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    ArrayList itemList = new ArrayList();

    public ToolBar(Composite composite, int n2) {
        super(composite, ToolBar.checkStyle(n2));
    }

    ScrollBar createScrollBar(int n2) {
        return null;
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x200) != 0) {
            n2 &= 0xFFFFFFBF;
        }
        return n2;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n2, n3, bl);
        if ((this.style & 0x40) != 0 && n2 != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolBar.this.isAdjustingSize = true;
                }
            });
            Dimension dimension = this.handle.getSize();
            this.handle.setSize(n2, Integer.MAX_VALUE);
            this.handle.validate();
            Component[] componentArray = this.handle.getComponents();
            int n4 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                Rectangle rectangle = componentArray[i2].getBounds();
                n4 = Math.max(rectangle.y + rectangle.height, n4);
            }
            this.handle.setSize(dimension);
            this.handle.validate();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolBar.this.isAdjustingSize = false;
                }
            });
            return new Point(point.x, n3 != -1 ? n3 : n4);
        }
        Dimension dimension = this.handle.getPreferredSize();
        if (n2 == -1) {
            return new Point(dimension.width, dimension.height);
        }
        return new Point(point.x, dimension.height);
    }

    Control[] _getChildren() {
        Component[] componentArray = ((CControl)((Object)this.handle)).getClientArea().getComponents();
        if (componentArray.length == 0) {
            return new Control[0];
        }
        ArrayList<Control> arrayList = new ArrayList<Control>(componentArray.length);
        if (this.itemList != null) {
            for (int i2 = 0; i2 < this.itemList.size(); ++i2) {
                Control control = ((ToolItem)this.itemList.get(i2)).getControl();
                if (control == null) continue;
                arrayList.add(control);
            }
        }
        return arrayList.toArray(new Control[0]);
    }

    boolean autoAddChildren() {
        return false;
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFFFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CToolBar.Factory.newInstance(this, this.style));
    }

    void createItem(ToolItem toolItem, int n2) {
        int n3 = this.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.itemList.add(n2, toolItem);
        this.handle.add((Component)toolItem.handle, n2);
        ((JComponent)this.handle).revalidate();
        this.handle.repaint();
    }

    void createWidget() {
        super.createWidget();
        this.itemList = new ArrayList();
    }

    void destroyItem(ToolItem toolItem) {
        this.itemList.remove(toolItem);
        this.handle.remove(toolItem.handle);
        ((JComponent)this.handle).revalidate();
        this.handle.repaint();
        if (this.itemList.isEmpty()) {
            this.itemList = new ArrayList();
        }
    }

    public ToolItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return (ToolItem)this.itemList.get(n2);
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i2 = 0; i2 < toolItemArray.length; ++i2) {
            org.eclipse.swt.graphics.Rectangle rectangle = toolItemArray[i2].getBounds();
            if (!rectangle.contains(point)) continue;
            return toolItemArray[i2];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList.size();
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this.itemList.toArray(new ToolItem[0]);
    }

    public int getRowCount() {
        this.checkWidget();
        Utils.notImplemented();
        return 1;
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        return this.itemList.indexOf(toolItem);
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    void releaseChildren(boolean bl) {
        if (this.itemList != null) {
            int n2 = this.itemList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ToolItem toolItem = (ToolItem)this.itemList.get(i2);
                if (toolItem == null || toolItem.isDisposed()) continue;
                toolItem.release(false);
            }
            this.itemList = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n2 = this.itemList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ToolItem toolItem = (ToolItem)this.itemList.get(i2);
            if (toolItem == null || toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    boolean setTabItemFocus() {
        ToolItem toolItem;
        int n2;
        int n3 = this.itemList.size();
        for (n2 = 0; !(n2 >= n3 || (toolItem = (ToolItem)this.itemList.get(n2)) != null && (toolItem.style & 2) == 0 && toolItem.getEnabled()); ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        return super.setTabItemFocus();
    }
}

