/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import javax.swing.SwingUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget widget, int n2) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n2;
        this.display = widget.display;
    }

    public void addListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3 | n4 | n5 | n6 | n7 | n8;
        if ((n2 & n9) == 0) {
            n2 |= n3;
        }
        if ((n2 & n3) != 0) {
            n2 = n2 & ~n9 | n3;
        }
        if ((n2 & n4) != 0) {
            n2 = n2 & ~n9 | n4;
        }
        if ((n2 & n5) != 0) {
            n2 = n2 & ~n9 | n5;
        }
        if ((n2 & n6) != 0) {
            n2 = n2 & ~n9 | n6;
        }
        if ((n2 & n7) != 0) {
            n2 = n2 & ~n9 | n7;
        }
        if ((n2 & n8) != 0) {
            n2 = n2 & ~n9 | n8;
        }
        return n2;
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpened();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        String string;
        Thread thread;
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != (thread = Thread.currentThread()) && !SwingUtilities.isEventDispatchThread() && (string = thread.getName()) == null) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filters(int n2) {
        return this.display.filters(n2);
    }

    int findMnemonicIndex(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return -1;
            }
            if (string.charAt(n2) != '&') {
                return n2;
            }
            if (++n2 >= n3) break;
        }
        return -1;
    }

    String fixMnemonic(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '&') {
                if (n2 + 1 < cArray.length && cArray[n2 + 1] == '&') {
                    cArray[n3++] = 32;
                    ++n2;
                }
                ++n2;
                continue;
            }
            cArray[n3++] = cArray[n2++];
        }
        while (n3 < cArray.length) {
            cArray[n3++] = '\u0000';
        }
        return new String(cArray, 0, n3);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
                if (!string.equals(objectArray[i2])) continue;
                return objectArray[i2 + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int n2) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n2);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n2) {
        this.checkWidget();
        return this.hooks(n2);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(int n2, Event event) {
    }

    GC new_GC(GCData gCData) {
        return null;
    }

    public void notifyListeners(int n2, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n2, event);
    }

    void postEvent(int n2) {
        this.sendEvent(n2, null, false);
    }

    void postEvent(int n2, Event event) {
        this.sendEvent(n2, event, false);
    }

    void release(boolean bl) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    protected void removeListener(int n2, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n2) {
        this.sendEvent(n2, null, true);
    }

    void sendEvent(int n2, Event event) {
        this.sendEvent(n2, event, true);
    }

    void sendEvent(int n2, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n2)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n2;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = Utils.getCurrentTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n2 = 1; n2 < objectArray.length && !string.equals(objectArray[n2]); n2 += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n2 == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n2] = string;
            objectArray[n2 + 1] = object;
        } else if ((this.state & 4) != 0 && n2 != objectArray.length) {
            int n3 = objectArray.length - 2;
            if (n3 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n3];
                System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                System.arraycopy(objectArray, n2 + 2, objectArray3, n2, n3 - n2);
                this.data = objectArray3;
            }
        }
    }

    boolean sendFocusEvent(int n2) {
        this.sendEvent(n2);
        return true;
    }

    boolean setInputState(Event event, int n2) {
        event.stateMask |= Display.getInputState();
        switch (n2) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean showMenu(int n2, int n3) {
        Event event = new Event();
        event.x = n2;
        event.y = n3;
        this.sendEvent(35, event);
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n2 != event.x || n3 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }
}

