/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Properties template;

    private void createTemplate() {
        this.template = new Properties();
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < models.length) {
            this.addToTemplate(models[i]);
            ++i;
        }
    }

    private void addToTemplate(IPluginModelBase model) {
        Properties modelOptions = this.getOptions(model);
        if (modelOptions == null) {
            return;
        }
        Enumeration<Object> keys = modelOptions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = modelOptions.getProperty(key);
            if (key == null || value == null) continue;
            this.template.setProperty(key, value);
        }
    }

    public Hashtable getTemplateTable(String pluginId) {
        if (this.template == null) {
            this.createTemplate();
        }
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        Enumeration<Object> keys = this.template.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!this.belongsTo(key, pluginId)) continue;
            defaults.put(key, this.template.get(key));
        }
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        Path path = new Path(option);
        String firstSegment = path.segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public Properties getTracingOptions(Map storedOptions) {
        Properties defaults = this.getTracingTemplateCopy();
        if (storedOptions != null) {
            Iterator iter = storedOptions.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (!defaults.containsKey(key)) continue;
                defaults.setProperty(key, (String)storedOptions.get(key));
            }
        }
        return defaults;
    }

    public Properties getTracingTemplateCopy() {
        if (this.template == null) {
            this.createTemplate();
        }
        return (Properties)this.template.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTraceable(IPluginModelBase model) {
        ZipFile jarFile;
        InputStream stream;
        block18: {
            boolean bl;
            block17: {
                String location = model.getInstallLocation();
                if (location == null) {
                    return false;
                }
                File pluginLocation = new File(location);
                stream = null;
                jarFile = null;
                try {
                    try {
                        if (pluginLocation.isDirectory()) {
                            bl = new File(pluginLocation, ".options").exists();
                            Object var6_6 = null;
                            break block17;
                        }
                        jarFile = new ZipFile(pluginLocation, 1);
                        ZipEntry manifestEntry = jarFile.getEntry(".options");
                        if (manifestEntry != null) {
                            stream = jarFile.getInputStream(manifestEntry);
                        }
                        break block18;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (jarFile == null) throw throwable;
                        jarFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (stream != null) {
                stream.close();
            }
            if (jarFile == null) return bl;
            jarFile.close();
            return bl;
        }
        Object var6_8 = null;
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            stream.close();
        }
        if (jarFile != null) {
            jarFile.close();
        }
        if (stream == null) return false;
        return true;
    }

    public void reset() {
        this.template = null;
    }

    private void save(String fileName, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "Master Tracing Options");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void save(String filename, Map map, HashSet selected) {
        Properties properties = this.getTracingOptions(map);
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Path path = new Path(key);
            if (path.segmentCount() >= 1 && selected.contains(path.segment(0).toString())) continue;
            properties.remove(key);
        }
        this.save(filename, properties);
    }

    public void save(String filename, Map map) {
        this.save(filename, this.getTracingOptions(map));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getOptions(IPluginModelBase model) {
        String location = model.getInstallLocation();
        if (location == null) {
            return null;
        }
        File pluginLocation = new File(location);
        InputStream stream = null;
        ZipFile jarFile = null;
        try {
            block18: {
                if (pluginLocation.isDirectory()) {
                    File file = new File(pluginLocation, ".options");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                } else {
                    jarFile = new ZipFile(pluginLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(".options");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                }
                if (stream == null) break block18;
                Properties modelOptions = new Properties();
                modelOptions.load(stream);
                Properties properties = modelOptions;
                Object var7_8 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (jarFile == null) return properties;
                    jarFile.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
                catch (FileNotFoundException fileNotFoundException) {
                    break block18;
                }
                catch (IOException iOException) {}
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (IOException iOException) {}
            if (stream != null) {
                stream.close();
            }
            if (jarFile == null) throw throwable;
            jarFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (stream != null) {
            stream.close();
        }
        if (jarFile == null) return null;
        jarFile.close();
        return null;
    }
}

