/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class ResourceEditionNode
implements IStructureComparator,
ITypedElement,
IEncodedStreamContentAccessor {
    private ICVSRemoteResource resource;
    private ResourceEditionNode[] children;

    public ResourceEditionNode(ICVSRemoteResource resourceEdition) {
        this.resource = resourceEdition;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public Object[] getChildren() {
        block5: {
            if (this.children == null) {
                this.children = new ResourceEditionNode[0];
                if (this.resource != null) {
                    try {
                        CVSUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    ICVSRemoteResource[] members = ResourceEditionNode.this.resource.members(monitor);
                                    ResourceEditionNode.this.children = new ResourceEditionNode[members.length];
                                    int i = 0;
                                    while (i < members.length) {
                                        ((ResourceEditionNode)ResourceEditionNode.this).children[i] = new ResourceEditionNode(members[i]);
                                        ++i;
                                    }
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (!(t instanceof TeamException)) break block5;
                        CVSUIPlugin.log((CoreException)((Object)((TeamException)t)));
                    }
                }
            }
        }
        return this.children;
    }

    public InputStream getContents() throws CoreException {
        IStorage storage = this.getStorage();
        if (storage != null) {
            return storage.getContents();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getName() {
        return this.resource == null ? "" : this.resource.getName();
    }

    public ICVSRemoteResource getRemoteResource() {
        return this.resource;
    }

    public String getType() {
        if (this.resource == null) {
            return "???";
        }
        if (this.resource.isContainer()) {
            return "FOLDER";
        }
        String name = this.resource.getName();
        return (name = name.substring(name.lastIndexOf(46) + 1)).length() == 0 ? "???" : name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getCharset() throws CoreException {
        String charset;
        IResource local = this.resource.getIResource();
        if (local != null && local.getType() == 1) {
            return ((IFile)local).getCharset();
        }
        IStorage storage = this.getStorage();
        if (storage instanceof IEncodedStorage && (charset = ((IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return null;
    }

    private IStorage getStorage() throws TeamException {
        if (this.resource == null) {
            return null;
        }
        final IStorage[] holder = new IStorage[1];
        try {
            CVSUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        holder[0] = ((IResourceVariant)ResourceEditionNode.this.resource).getStorage(monitor);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException interruptedException) {}
        return holder[0];
    }
}

