/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.CollisionChecker;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GridCollisionChecker
implements CollisionChecker {
    private Set<Actor> objects;
    private boolean wrap;
    private GridWorld world;
    private int cellSize;
    private Statistics currentStats = new Statistics();
    private List<Statistics> allStats = new ArrayList<Statistics>();
    private static boolean PRINT_STATS = false;

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.wrap = wrap;
        this.cellSize = cellSize;
        this.objects = null;
        if (PRINT_STATS) {
            System.out.println(Statistics.headerString());
            this.objects = new TreeSet<Actor>(new Comparator<Actor>(){

                @Override
                public int compare(Actor arg0, Actor arg1) {
                    return arg0.hashCode() - arg1.hashCode();
                }
            });
        } else {
            this.objects = new HashSet<Actor>();
        }
        this.world = wrap ? new WrappingGridWorld(width, height) : new GridWorld(width, height);
    }

    @Override
    public synchronized void addObject(Actor thing) throws ArrayIndexOutOfBoundsException {
        this.testBounds(thing);
        if (!this.objects.contains(thing)) {
            int ypos;
            int xpos = ActorVisitor.getX(thing);
            Cell cell = this.world.get(xpos, ypos = ActorVisitor.getY(thing));
            if (cell == null) {
                cell = new Cell();
                this.world.set(xpos, ypos, cell);
            }
            cell.add(thing);
            this.objects.add(thing);
        }
    }

    private void testBounds(Actor thing) {
        int ax = ActorVisitor.getX(thing);
        int ay = ActorVisitor.getY(thing);
        if (ax >= this.getWidth()) {
            throw new ArrayIndexOutOfBoundsException(ax);
        }
        if (ay >= this.getHeight()) {
            throw new ArrayIndexOutOfBoundsException(ay);
        }
        if (ax < 0) {
            throw new ArrayIndexOutOfBoundsException(ax);
        }
        if (ay < 0) {
            throw new ArrayIndexOutOfBoundsException(ay);
        }
    }

    @Override
    public <T extends Actor> List<T> getObjectsAt(int x, int y, Class<T> cls) {
        if (this.wrap) {
            x = this.wrap(x, this.world.getWidth());
            y = this.wrap(y, this.world.getWidth());
        }
        ArrayList<Actor> objectsThere = new ArrayList<Actor>();
        Iterator<Actor> iter = this.objects.iterator();
        while (iter.hasNext()) {
            this.currentStats.incGetObjectsAt();
            Actor actor = iter.next();
            int ax = x * this.cellSize + this.cellSize / 2;
            int ay = y * this.cellSize + this.cellSize / 2;
            if (cls != null && !cls.isInstance(actor) || !ActorVisitor.containsPoint(actor, ax, y - ay)) continue;
            objectsThere.add(actor);
        }
        return objectsThere;
    }

    @Override
    public <T extends Actor> List<T> getObjectsInRange(int x, int y, int r, Class<T> cls) {
        Iterator<Actor> iter = this.objects.iterator();
        ArrayList<Actor> neighbours = new ArrayList<Actor>();
        while (iter.hasNext()) {
            Actor g;
            Actor o = iter.next();
            this.currentStats.incGetObjectsInRange();
            if (cls != null && !cls.isInstance(o) || !(this.distance(x, y, g = o) <= (double)r)) continue;
            neighbours.add(g);
        }
        return neighbours;
    }

    private double distance(int x, int y, Actor actor) {
        double gx = ActorVisitor.getX(actor);
        double gy = ActorVisitor.getY(actor);
        double dx = Math.abs(gx - (double)x);
        double dy = Math.abs(gy - (double)y);
        if (this.wrap) {
            double dxWrap = (double)this.getWidth() - dx;
            double dyWrap = (double)this.getWidth() - dy;
            if (dx >= dxWrap) {
                dx = dxWrap;
            }
            if (dy >= dyWrap) {
                dy = dyWrap;
            }
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public synchronized void removeObject(Actor object) {
        int ay;
        int ax = ActorVisitor.getX(object);
        Cell cell = this.world.get(ax, ay = ActorVisitor.getY(object));
        if (cell != null) {
            cell.remove(object);
            if (cell.isEmpty()) {
                this.world.set(ax, ay, null);
            }
        }
        this.objects.remove(object);
    }

    public int getWidth() {
        return this.world.getWidth();
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    @Override
    public void updateObjectLocation(Actor object, int oldX, int oldY) {
        int ay;
        int ax;
        Cell cell = this.world.get(oldX, oldY);
        if (cell != null) {
            cell.remove(object);
            if (cell.isEmpty()) {
                this.world.set(oldX, oldY, null);
            }
        }
        if ((cell = this.world.get(ax = ActorVisitor.getX(object), ay = ActorVisitor.getY(object))) == null) {
            cell = new Cell();
            this.world.set(ax, ay, cell);
        }
        cell.add(object);
    }

    @Override
    public void updateObjectSize(Actor object) {
    }

    @Override
    public <T extends Actor> List<T> getIntersectingObjects(Actor actor, Class<T> cls) {
        ArrayList<Actor> intersecting = new ArrayList<Actor>();
        for (Actor element : this.objects) {
            this.currentStats.incGetIntersectingObjects();
            if (element == actor || !ActorVisitor.intersects(actor, element) || cls != null && !cls.isInstance(element)) continue;
            intersecting.add(element);
        }
        return intersecting;
    }

    @Override
    public <T extends Actor> List<T> getNeighbours(Actor actor, int distance, boolean diag, Class<T> cls) {
        ArrayList<T> c;
        block22: {
            int y;
            int x;
            block23: {
                x = ActorVisitor.getX(actor);
                y = ActorVisitor.getY(actor);
                c = new ArrayList<T>();
                if (!diag) break block23;
                int dx = x - distance;
                while (dx <= x + distance) {
                    if (!this.wrap) {
                        if (dx >= 0) {
                            if (dx >= this.world.getWidth()) break block22;
                        }
                    } else {
                        int dy = y - distance;
                        while (dy <= y + distance) {
                            if (!this.wrap) {
                                if (dy >= 0) {
                                    if (dy >= this.world.getHeight()) break;
                                }
                            } else if (dx != x || dy != y) {
                                List<T> found;
                                Cell cell = this.world.get(dx, dy);
                                this.currentStats.incGetNeighbours();
                                if (cell != null && (found = cell.get(cls)) != null) {
                                    c.addAll(found);
                                }
                            }
                            ++dy;
                        }
                    }
                    ++dx;
                }
                break block22;
            }
            int d = distance;
            int xStart = x;
            int yStart = y;
            int dyEnd = d;
            int dx = 0;
            while (dx <= d) {
                int dy = dx - d;
                while (dy <= dyEnd) {
                    block25: {
                        int yPos;
                        int xNeg;
                        int xPos;
                        block24: {
                            xPos = xStart + dx;
                            xNeg = xStart - dx;
                            yPos = yStart + dy;
                            if (this.wrap) break block24;
                            if (yPos >= this.world.getHeight()) break;
                            if (yPos < 0) break block25;
                        }
                        if (dx != 0 || dy != 0) {
                            List<T> found;
                            Cell cell;
                            this.currentStats.incGetNeighbours();
                            if (this.withinBounds(xPos, this.getWidth()) && (cell = this.world.get(xPos, yPos)) != null && (found = cell.get(cls)) != null) {
                                c.addAll(found);
                            }
                            if (dx != 0 && this.withinBounds(xNeg, this.getWidth()) && (cell = this.world.get(xNeg, yPos)) != null && (found = cell.get(cls)) != null) {
                                c.addAll(found);
                            }
                        }
                    }
                    ++dy;
                }
                --dyEnd;
                ++dx;
            }
        }
        return c;
    }

    @Override
    public <T extends Actor> List<T> getObjectsInDirection(int x, int y, int angle, int length, Class<T> cls) {
        int stepx;
        int stepy;
        ArrayList<T> result = new ArrayList<T>();
        double dy = 2.0 * Math.sin(Math.toRadians(angle));
        double dx = 2.0 * Math.cos(Math.toRadians(angle));
        int lxMax = (int)Math.abs(Math.round((double)length * Math.cos(Math.toRadians(angle))));
        int lyMax = (int)Math.abs(Math.round((double)length * Math.sin(Math.toRadians(angle))));
        if (dy < 0.0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0.0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        result.addAll(this.getObjectsAt(x, y, cls));
        if (dx > dy) {
            double fraction = dy - dx / 2.0;
            int l = 0;
            while (l < lxMax) {
                this.currentStats.incGetObjectsInDirection();
                if (fraction >= 0.0) {
                    y += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                result.addAll(this.getObjectsAt(x += stepx, y, cls));
                ++l;
            }
        } else {
            double fraction = dx - dy / 2.0;
            int l = 0;
            while (l < lyMax) {
                this.currentStats.incGetObjectsInDirection();
                if (fraction >= 0.0) {
                    x += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                result.addAll(this.getObjectsAt(x, y += stepy, cls));
                ++l;
            }
        }
        return result;
    }

    private boolean withinBounds(int x, int width) {
        return this.wrap || !this.wrap && x >= 0 && x < width;
    }

    private int wrap(int x, int width) {
        int remainder = x % width;
        if (remainder < 0) {
            return width + remainder;
        }
        return remainder;
    }

    @Override
    public void startSequence() {
        if (PRINT_STATS) {
            System.out.println(this.currentStats);
        }
        this.allStats.add(this.currentStats);
        this.currentStats = new Statistics();
    }

    @Override
    public <T extends Actor> List<T> getObjects(Class<T> cls) {
        ArrayList<Actor> objectsThere = new ArrayList<Actor>();
        Iterator<Actor> iter = this.objects.iterator();
        while (iter.hasNext()) {
            this.currentStats.incGetObjectsAt();
            Actor actor = iter.next();
            if (cls != null && !cls.isInstance(actor)) continue;
            objectsThere.add(actor);
        }
        return objectsThere;
    }

    @Override
    public List<Actor> getObjectsList() {
        ArrayList<Actor> l = new ArrayList<Actor>(this.objects);
        return l;
    }

    @Override
    public <T extends Actor> T getOneObjectAt(Actor actor, int dx, int dy, Class<T> cls) {
        List<T> neighbours = this.getObjectsAt(dx, dy, cls);
        neighbours.remove(actor);
        if (!neighbours.isEmpty()) {
            return (T)((Actor)neighbours.get(0));
        }
        return null;
    }

    @Override
    public <T extends Actor> T getOneIntersectingObject(Actor object, Class<T> cls) {
        List<T> intersecting = this.getIntersectingObjects(object, cls);
        if (!intersecting.isEmpty()) {
            return (T)((Actor)intersecting.get(0));
        }
        return null;
    }

    @Override
    public void paintDebug(Graphics g) {
    }

    class Cell {
        private HashMap<Class<?>, List<Actor>> classMap = new HashMap();
        private List<Actor> objects = new ArrayList<Actor>();

        Cell() {
        }

        public void add(Actor thing) {
            Class<?> clazz = thing.getClass();
            List<Actor> list = this.classMap.get(clazz);
            if (list == null) {
                list = new ArrayList<Actor>();
                this.classMap.put(clazz, list);
            }
            if (!list.contains(thing)) {
                list.add(thing);
            }
            if (!this.objects.contains(thing)) {
                this.objects.add(thing);
            }
        }

        public <T> List<T> get(Class<T> cls) {
            return this.classMap.get(cls);
        }

        public void remove(Actor object) {
            this.objects.remove(object);
            List<Actor> classes = this.classMap.get(object.getClass());
            if (classes != null) {
                classes.remove(object);
            }
        }

        public boolean isEmpty() {
            return this.objects.isEmpty();
        }

        public List<Actor> getAll() {
            return this.objects;
        }
    }

    private class GridWorld {
        protected Cell[][] world;

        public GridWorld(int width, int height) {
            this.world = new Cell[width][height];
        }

        public Cell get(int x, int y) {
            return this.world[x][y];
        }

        public void set(int x, int y, Cell cell) {
            this.world[x][y] = cell;
        }

        public int getWidth() {
            return this.world.length;
        }

        public int getHeight() {
            return this.world[0].length;
        }
    }

    public static class Statistics {
        private static final String format = "%15s%15s%15s%15s%15s%15s";
        private long objectsAt;
        private long intersectionObjects;
        private long objectsInRange;
        private long neighbours;
        private long objectsInDirection;
        private long startTime = -1L;

        public void incGetObjectsAt() {
            this.initStartTime();
            ++this.objectsAt;
        }

        public void incGetIntersectingObjects() {
            this.initStartTime();
            ++this.intersectionObjects;
        }

        public void incGetObjectsInRange() {
            this.initStartTime();
            ++this.objectsInRange;
        }

        public void incGetNeighbours() {
            this.initStartTime();
            ++this.neighbours;
        }

        public void incGetObjectsInDirection() {
            this.initStartTime();
            ++this.objectsInDirection;
        }

        private void initStartTime() {
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            }
        }

        public String toString() {
            return String.format(format, this.startTime, this.objectsAt, this.intersectionObjects, this.objectsInRange, this.neighbours, this.objectsInDirection);
        }

        public static String headerString() {
            return String.format(format, "startTime", "objectsAt", "intersection", "oinRange", "neighbours", "inDirection");
        }
    }

    private class WrappingGridWorld
    extends GridWorld {
        public WrappingGridWorld(int width, int height) {
            super(width, height);
        }

        @Override
        public Cell get(int x, int y) {
            x = GridCollisionChecker.this.wrap(x, this.getWidth());
            y = GridCollisionChecker.this.wrap(y, this.getHeight());
            return this.world[x][y];
        }

        @Override
        public void set(int x, int y, Cell cell) {
            x = GridCollisionChecker.this.wrap(x, this.getWidth());
            y = GridCollisionChecker.this.wrap(y, this.getHeight());
            this.world[x][y] = cell;
        }
    }
}

