/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.WorldHandler;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class IntersectionTest
extends TestCase {
    private World world;

    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
    }

    public void testIntersectingSingleCell() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject o1 = new TestObject(10, 10);
        this.world.addObject(o1, 2, 2);
        TestObject o2 = new TestObject(10, 10);
        this.world.addObject(o2, 2, 2);
        IntersectionTest.assertTrue((boolean)o1.intersectsP(o2));
        IntersectionTest.assertTrue((boolean)o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue((boolean)c.contains(o2));
        IntersectionTest.assertEquals((int)1, (int)c.size());
        o2.setLocation(3, 2);
        IntersectionTest.assertFalse((boolean)o1.intersectsP(o2));
        IntersectionTest.assertFalse((boolean)o2.intersectsP(o1));
    }

    public void testIntersectingPixelLevelOdd() {
        this.world = WorldCreator.createWorld(70, 70, 1);
        WorldHandler.initialise();
        WorldHandler.getInstance().setWorld(this.world);
        TestObject o1 = new TestObject(7, 7);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(7, 7);
        this.world.addObject(o2, 6, 6);
        IntersectionTest.assertTrue((boolean)o1.intersectsP(o2));
        IntersectionTest.assertTrue((boolean)o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue((boolean)c.contains(o2));
        IntersectionTest.assertEquals((int)1, (int)c.size());
        o2.setLocation(7, 7);
        IntersectionTest.assertFalse((boolean)o1.intersectsP(o2));
        IntersectionTest.assertFalse((boolean)o2.intersectsP(o1));
    }

    public void testIntersectingPixelLevelEven() {
        this.world = WorldCreator.createWorld(80, 80, 1);
        TestObject o1 = new TestObject(8, 8);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(8, 8);
        this.world.addObject(o2, 7, 7);
        IntersectionTest.assertTrue((boolean)o1.intersectsP(o2));
        IntersectionTest.assertTrue((boolean)o2.intersectsP(o1));
        List c = o1.getIntersectingObjectsP(TestObject.class);
        IntersectionTest.assertTrue((boolean)c.contains(o2));
        IntersectionTest.assertEquals((int)1, (int)c.size());
        o2.setLocation(8, 8);
        IntersectionTest.assertFalse((boolean)o1.intersectsP(o2));
        IntersectionTest.assertFalse((boolean)o2.intersectsP(o1));
        o2.setLocation(9, 9);
        IntersectionTest.assertFalse((boolean)o1.intersectsP(o2));
        IntersectionTest.assertFalse((boolean)o2.intersectsP(o1));
    }

    public void testRotationIntersection45() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(50, 50);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(50, 50);
        this.world.addObject(o2, 55, 0);
        IntersectionTest.assertNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
        o2.setRotation(45);
        IntersectionTest.assertEquals((Object)o1, (Object)o2.getOneIntersectingObjectP(TestObject.class));
        o2.setLocation(55, 55);
        IntersectionTest.assertNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(45);
        IntersectionTest.assertNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
    }

    public void testRotationIntersection90() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(100, 10);
        this.world.addObject(o1, 0, 0);
        TestObject o2 = new TestObject(10, 10);
        this.world.addObject(o2, 0, 40);
        IntersectionTest.assertNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(90);
        IntersectionTest.assertEquals((Object)o1, (Object)o2.getOneIntersectingObjectP(TestObject.class));
    }

    public void testIntersectionSmallObject() {
        this.world = WorldCreator.createWorld(200, 200, 1);
        TestObject o1 = new TestObject(100, 100);
        this.world.addObject(o1, 55, 55);
        TestObject o2 = new TestObject(1, 1);
        o2.setRotation(45);
        this.world.addObject(o2, 56, 56);
        IntersectionTest.assertNotNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
        o1.setRotation(45);
        o2.setLocation(100, 100);
        IntersectionTest.assertNull((Object)o2.getOneIntersectingObjectP(TestObject.class));
    }
}

