/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.util.GraphicsUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class TextLabel {
    private final int xpos;
    private final int ypos;
    private final String text;
    private final String[] lines;
    private GraphicsUtilities.MultiLineStringDimensions dimensions;

    public TextLabel(String s, int xpos, int ypos) {
        this.text = s;
        this.lines = GraphicsUtilities.splitLines(this.text);
        this.xpos = xpos;
        this.ypos = ypos;
    }

    public void draw(Graphics2D g, int cellsize) {
        if (this.dimensions == null) {
            this.dimensions = GraphicsUtilities.getMultiLineStringDimensions(this.lines, 1, 25.0);
        }
        int ydraw = this.ypos * cellsize - this.dimensions.getHeight() / 2 + cellsize / 2;
        int xdraw = this.xpos * cellsize - this.dimensions.getWidth() / 2 + cellsize / 2;
        g.translate(xdraw, ydraw);
        GraphicsUtilities.drawOutlinedText(g, this.dimensions, Color.WHITE, Color.BLACK);
        g.translate(-xdraw, -ydraw);
    }

    public int getX() {
        return this.xpos;
    }

    public int getY() {
        return this.ypos;
    }

    public String getText() {
        return this.text;
    }
}

