/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.World;
import greenfoot.core.ProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.export.GreenfootScenarioMain;
import greenfoot.gui.AskPanel;
import greenfoot.gui.ControlPanel;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.platforms.standalone.ActorDelegateStandAlone;
import greenfoot.platforms.standalone.GreenfootUtilDelegateStandAlone;
import greenfoot.platforms.standalone.SimulationDelegateStandAlone;
import greenfoot.platforms.standalone.WorldHandlerDelegateStandAlone;
import greenfoot.sound.SoundFactory;
import greenfoot.util.AskHandler;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.RootPaneContainer;

public class GreenfootScenarioViewer
extends JApplet {
    private static final int EMPTY_BORDER_SIZE = 5;
    private static String scenarioName;
    private boolean isApplet;
    private ProjectProperties properties;
    private Simulation sim;
    private WorldCanvas canvas;
    private AskPanel askPanel;
    private ControlPanel controls;
    private RootPaneContainer rootPaneContainer;
    private Constructor<?> worldConstructor;
    private AskHandler askHandler;

    public GreenfootScenarioViewer() {
        this.isApplet = true;
    }

    public GreenfootScenarioViewer(RootPaneContainer rootPane) {
        this.rootPaneContainer = rootPane;
        this.isApplet = false;
    }

    public static Dimension getControlsBorderSize() {
        return new Dimension(10, 10);
    }

    public static Dimension getWorldBorderSize() {
        return new Dimension(12, 7);
    }

    private void buildGUI() {
        if (this.rootPaneContainer == null) {
            this.rootPaneContainer = this;
        }
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new OverlayLayout(centerPanel));
        this.canvas.setAlignmentX(0.5f);
        this.canvas.setAlignmentY(1.0f);
        this.askPanel = new AskPanel();
        this.askPanel.getComponent().setAlignmentX(0.5f);
        this.askPanel.getComponent().setAlignmentY(1.0f);
        centerPanel.add(this.askPanel.getComponent());
        centerPanel.add(this.canvas);
        centerPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.askHandler = new AskHandler(this.askPanel, this.canvas);
        JScrollPane outer = new JScrollPane(centerPanel);
        outer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.controls.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this.rootPaneContainer.getContentPane().add((Component)outer, "Center");
        this.rootPaneContainer.getContentPane().add((Component)this.controls, "South");
    }

    @Override
    public String getParameter(String name) {
        if (this.isApplet) {
            return super.getParameter(name);
        }
        return null;
    }

    @Override
    public void init() {
        GreenfootScenarioMain.initProperties();
        boolean storageStandalone = this.getParameter("storage.standalone") != null;
        String storageHost = this.getParameter("storage.server");
        String storagePort = this.getParameter("storage.serverPort");
        String storagePasscode = this.getParameter("storage.passcode");
        String storageScenarioId = this.getParameter("storage.scenarioId");
        String storageUserId = this.getParameter("storage.userId");
        String storageUserName = this.getParameter("storage.userName");
        JRootPane rootPane = this.getRootPane();
        rootPane.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        final String worldClassName = Config.getPropString((String)"main.class");
        final boolean lockScenario = Config.getPropBoolean((String)"scenario.lock");
        try {
            GreenfootUtil.initialise(new GreenfootUtilDelegateStandAlone(storageStandalone, storageHost, storagePort, storagePasscode, storageScenarioId, storageUserId, storageUserName));
            this.properties = new ProjectProperties();
            ActorDelegateStandAlone.setupAsActorDelegate();
            ActorDelegateStandAlone.initProperties(this.properties);
            Simulation.initialize(new SimulationDelegateStandAlone());
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreenfootScenarioViewer.this.guiSetup(lockScenario, worldClassName);
                }
            });
            WorldHandler worldHandler = WorldHandler.getInstance();
            Class<?> worldClass = Class.forName(worldClassName);
            this.worldConstructor = worldClass.getConstructor(new Class[0]);
            World world = this.instantiateNewWorld();
            if (!worldHandler.checkWorldSet()) {
                worldHandler.setWorld(world);
            }
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreenfootScenarioViewer.this.buildGUI();
                }
            });
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void guiSetup(boolean lockScenario, String worldClassName) {
        this.canvas = new WorldCanvas(null);
        this.canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GreenfootScenarioViewer.this.canvas.requestFocusInWindow();
                GreenfootScenarioViewer.this.canvas.requestFocus();
            }
        });
        WorldHandler.initialise(this.canvas, new WorldHandlerDelegateStandAlone(this, lockScenario));
        WorldHandler worldHandler = WorldHandler.getInstance();
        this.sim = Simulation.getInstance();
        this.sim.attachWorldHandler(worldHandler);
        LocationTracker.initialize();
        this.controls = new ControlPanel(this.sim, !lockScenario);
        this.sim.addSimulationListener(SoundFactory.getInstance().getSoundCollection());
        this.sim.addSimulationListener(new SimulationListener(){

            @Override
            public void simulationChanged(SimulationEvent e) {
                if (e.getType() == 0) {
                    GreenfootScenarioViewer.this.canvas.requestFocusInWindow();
                    GreenfootScenarioViewer.this.canvas.requestFocus();
                }
            }
        });
        try {
            int initialSpeed = this.properties.getInt("simulation.speed");
            this.sim.setSpeed(initialSpeed);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.sim.setPaused(true);
    }

    @Override
    public void destroy() {
        this.sim.abort();
    }

    @Override
    public String getAppletInfo() {
        return String.valueOf(Config.getString((String)"scenario.viewer.appletInfo")) + " " + scenarioName;
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] paramInfo = new String[][]{};
        return paramInfo;
    }

    public World instantiateNewWorld() {
        try {
            World world = (World)this.worldConstructor.newInstance(new Object[0]);
            return world;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        return null;
    }

    public World getWorld() {
        return WorldHandler.getInstance().getWorld();
    }

    public ReentrantReadWriteLock getWorldLock(World world) {
        return WorldHandler.getInstance().getWorldLock();
    }

    public String ask(final String prompt) {
        final AtomicReference c = new AtomicReference();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    c.set(GreenfootScenarioViewer.this.askHandler.ask(prompt, ((GreenfootScenarioViewer)GreenfootScenarioViewer.this).canvas.getPreferredSize().width));
                }
            });
        }
        catch (InvocationTargetException e) {
            Debug.reportError((Throwable)e);
        }
        catch (InterruptedException e) {
            Debug.reportError((Throwable)e);
        }
        try {
            return (String)((Callable)c.get()).call();
        }
        catch (Exception e) {
            Debug.reportError((Throwable)e);
            return null;
        }
    }
}

