/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import bluej.utility.SwingWorker;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.export.mygame.ScenarioInfo;
import java.io.IOException;
import java.net.UnknownHostException;

public abstract class ExistingScenarioChecker {
    private SwingWorker worker;
    private boolean checking = false;
    private boolean abort = false;
    private boolean finished = false;
    private volatile String hostName;
    private volatile String userName;
    private volatile String scenarioName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScenarioExistenceCheck(String hostName, String userName, String scenarioName) {
        ExistingScenarioChecker existingScenarioChecker = this;
        synchronized (existingScenarioChecker) {
            boolean sameScenario;
            boolean bl = sameScenario = hostName.equals(this.hostName) && userName.equals(this.userName) && scenarioName.equals(this.scenarioName);
            if (sameScenario) {
                return;
            }
            if (this.checking) {
                this.abort();
            }
            this.hostName = hostName;
            this.userName = userName;
            this.scenarioName = scenarioName;
            this.checking = true;
            this.abort = false;
            this.finished = false;
            this.worker = new ScenarioWorker();
            this.worker.start();
        }
    }

    public synchronized boolean abort() {
        if (this.finished) {
            return false;
        }
        if (!this.checking) {
            throw new IllegalStateException("Check not started yet. Nothing to abort.");
        }
        this.abort = true;
        this.worker.interrupt();
        return true;
    }

    public abstract void scenarioExistenceChecked(ScenarioInfo var1);

    public abstract void scenarioExistenceCheckFailed(Exception var1);

    private Object checkExistence(String hostName, String userName, String scenarioName) {
        MyGameClient client = new MyGameClient(null);
        ScenarioInfo info = new ScenarioInfo();
        IOException exception = null;
        try {
            if (client.checkExistingScenario(hostName, userName, scenarioName, info)) {
                return info;
            }
            return null;
        }
        catch (UnknownHostException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        return exception;
    }

    private synchronized void workerFinished(Object value) {
        this.finished = true;
        this.checking = false;
        if (!this.abort) {
            if (value instanceof Exception) {
                this.scenarioExistenceCheckFailed((Exception)value);
            } else {
                this.scenarioExistenceChecked((ScenarioInfo)value);
            }
        }
    }

    class ScenarioWorker
    extends SwingWorker {
        ScenarioWorker() {
        }

        public Object construct() {
            return ExistingScenarioChecker.this.checkExistence(ExistingScenarioChecker.this.hostName, ExistingScenarioChecker.this.userName, ExistingScenarioChecker.this.scenarioName);
        }

        public void finished() {
            ExistingScenarioChecker.this.workerFinished(this.getValue());
        }
    }
}

