/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import greenfoot.gui.classbrowser.ClassView;
import greenfoot.util.GreenfootUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassForest {
    private SortedSet<TreeEntry> roots = new TreeSet<TreeEntry>();
    private Map<String, TreeEntry> treeEntryMap = new LinkedHashMap<String, TreeEntry>();

    public Set<TreeEntry> getRoots() {
        return this.roots;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Iterator iter = this.roots.iterator();
        while (iter.hasNext()) {
            str.append(iter.next());
        }
        return str.toString();
    }

    public synchronized void add(ClassView cls) {
        String name = cls.getClassName();
        TreeEntry entry = new TreeEntry(cls, name);
        this.treeEntryMap.put(name, entry);
    }

    public void add(TreeEntry entry) {
        this.treeEntryMap.put(entry.getKey(), entry);
        List<TreeEntry> children = entry.getChildren();
        for (TreeEntry treeEntry : children) {
            this.add(treeEntry);
        }
    }

    public synchronized TreeEntry remove(ClassView cls) {
        String name = cls.getClassName();
        TreeEntry removedEntry = this.treeEntryMap.remove(name);
        if (removedEntry != null) {
            String oldName = removedEntry.getKey();
            if (!name.equals(oldName)) {
                removedEntry.rename(name);
            }
            List<TreeEntry> children = removedEntry.getChildren();
            for (TreeEntry child : children) {
                this.remove(child.getData());
            }
        }
        return removedEntry;
    }

    public synchronized void rename(ClassView cls, String oldName) {
        TreeEntry entry = this.treeEntryMap.remove(oldName);
        if (entry != null) {
            String newName = cls.getClassName();
            entry.rename(newName);
            this.treeEntryMap.put(newName, entry);
        }
    }

    public synchronized void rebuild() {
        this.roots = new TreeSet<TreeEntry>();
        Collection<TreeEntry> values = this.treeEntryMap.values();
        for (TreeEntry entry : values) {
            entry.removeChildren();
        }
        for (TreeEntry entry : values) {
            this.addEntryToTree(entry.getData());
        }
    }

    private void addEntryToTree(ClassView clsView) {
        String superName = clsView.getSuperclass();
        TreeEntry child = this.treeEntryMap.get(clsView.getClassName());
        if (superName == null || superName.equals("")) {
            this.roots.add(child);
        } else {
            TreeEntry parent = this.treeEntryMap.get(superName = GreenfootUtil.extractClassName(superName));
            if (parent != null) {
                parent.addChild(child);
            } else {
                this.roots.add(child);
            }
        }
    }

    public static class TreeEntry
    implements Comparable<TreeEntry> {
        private List<TreeEntry> children = new ArrayList<TreeEntry>();
        private ClassView data;
        private String key;

        public TreeEntry(ClassView data, String key) {
            this.data = data;
            this.key = key;
        }

        public void addChild(TreeEntry child) {
            if (this.equals(child)) {
                throw new IllegalArgumentException(" Cannot add TreeEntry as a child of itself: " + this);
            }
            List<TreeEntry> childsChildren = child.getChildren();
            for (TreeEntry treeEntry : childsChildren) {
                if (!this.equals(treeEntry)) continue;
                System.err.println("ClassForest found Cycle between: " + this.key + " and " + child);
                return;
            }
            this.children.add(child);
        }

        public void removeChildren() {
            this.children.clear();
        }

        public List<TreeEntry> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            for (TreeEntry element : this.children) {
                str.append(" " + element.toString());
            }
            return String.valueOf(this.key) + "(" + str + " )";
        }

        private String getKey() {
            return this.key;
        }

        public ClassView getData() {
            return this.data;
        }

        @Override
        public int compareTo(TreeEntry o) {
            String name1 = this.getKey();
            String name2 = o.getKey();
            return name1.compareTo(name2);
        }

        public boolean equals(Object o) {
            if (o instanceof TreeEntry) {
                TreeEntry other = (TreeEntry)o;
                return this.getKey().equals(other.getKey());
            }
            return false;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public void rename(String newKey) {
            this.key = newKey;
        }
    }
}

