/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DBox;
import bluej.utility.DialogManager;
import bluej.utility.MiksGridLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProxyAuthDialog
extends JDialog {
    private JTextField usernameField;
    private JTextField passwordField;
    private int result;
    public static final int OK = 0;
    public static final int CANCEL = 1;

    public ProxyAuthDialog(Window parentWindow) {
        super(parentWindow, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(Config.getString((String)"export.publish.proxyAuth"));
        this.buildUI();
        DialogManager.centreDialog((JDialog)this);
    }

    public int getResult() {
        return this.result;
    }

    public String getUsername() {
        return this.usernameField.getText();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    private void buildUI() {
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setBorder(BlueJTheme.generalBorder);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JLabel msgLabel = new JLabel(Config.getString((String)"export.publish.needProxyAuth"));
        msgLabel.setAlignmentX(0.0f);
        contentPane.add(msgLabel);
        contentPane.add(Box.createVerticalStrut(11));
        MiksGridLayout lm = new MiksGridLayout(2, 2, 5, 5);
        JPanel authPanel = new JPanel((LayoutManager)lm);
        authPanel.add(new JLabel(Config.getString((String)"export.publish.username")));
        this.usernameField = new JTextField(20);
        authPanel.add(this.usernameField);
        authPanel.add(new JLabel(Config.getString((String)"export.publish.password")));
        this.passwordField = new JTextField(20);
        authPanel.add(this.passwordField);
        JButton okButton = new JButton(Config.getString((String)"okay"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyAuthDialog.this.result = 0;
                ProxyAuthDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton(Config.getString((String)"cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyAuthDialog.this.result = 1;
                ProxyAuthDialog.this.dispose();
            }
        });
        DBox buttonBox = new DBox(DBox.X_AXIS, 5, 5, 0.5f);
        buttonBox.add(Box.createHorizontalGlue());
        DialogManager.addOKCancelButtons((JPanel)buttonBox, (JButton)okButton, (JButton)cancelButton);
        contentPane.add(authPanel);
        contentPane.add((Component)buttonBox);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }
}

