/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.MouseInfoVisitor;
import greenfoot.World;

class MouseEventData {
    private MouseInfo mouseInfo;
    private MouseInfo mouseDragEndedInfo;
    private MouseInfo mouseClickedInfo;
    private MouseInfo mousePressedInfo;
    private MouseInfo mouseDraggedInfo;
    private MouseInfo mouseMovedInfo;

    MouseEventData() {
    }

    public void init() {
        this.mousePressedInfo = null;
        this.mouseClickedInfo = null;
        this.mouseDraggedInfo = null;
        this.mouseDragEndedInfo = null;
        this.mouseMovedInfo = null;
        if (this.mouseInfo != null) {
            MouseInfo blankedMouseInfo = MouseInfoVisitor.newMouseInfo();
            MouseInfoVisitor.setLoc(blankedMouseInfo, this.mouseInfo.getX(), this.mouseInfo.getY());
            this.mouseInfo = blankedMouseInfo;
        }
    }

    public MouseInfo getMouseInfo() {
        return this.mouseInfo;
    }

    public boolean isMousePressed(Object obj) {
        return this.checkObject(obj, this.mousePressedInfo);
    }

    public void mousePressed(int x, int y, int button, Actor actor) {
        this.init();
        this.mouseInfo = this.mousePressedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
    }

    public boolean isMouseClicked(Object obj) {
        if (obj != null && this.isMousePressed(null) && !this.isMousePressed(obj)) {
            return false;
        }
        return this.checkObject(obj, this.mouseClickedInfo);
    }

    public void mouseClicked(int x, int y, int button, int clickCount, Actor actor) {
        MouseInfo tempPressedInfo = this.mousePressedInfo;
        this.init();
        this.mousePressedInfo = tempPressedInfo;
        this.mouseInfo = this.mouseClickedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
        MouseInfoVisitor.setClickCount(this.mouseInfo, clickCount);
    }

    public boolean isMouseDragged(Object obj) {
        return this.checkObject(obj, this.mouseDraggedInfo);
    }

    public void mouseDragged(int x, int y, int button, Actor actor) {
        this.init();
        this.mouseInfo = this.mouseDraggedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
    }

    public boolean isMouseDragEnded(Object obj) {
        return this.checkObject(obj, this.mouseDragEndedInfo);
    }

    public void mouseDragEnded(int x, int y, int button, Actor actor) {
        MouseInfo tempPressedInfo = this.mousePressedInfo;
        MouseInfo tempClickedInfo = this.mouseClickedInfo;
        this.init();
        this.mousePressedInfo = tempPressedInfo;
        this.mouseClickedInfo = tempClickedInfo;
        this.mouseInfo = this.mouseDragEndedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
    }

    public void mouseExited() {
        this.mouseInfo = this.mouseDraggedInfo;
        this.mouseMovedInfo = null;
    }

    public boolean isMouseMoved(Object obj) {
        return this.checkObject(obj, this.mouseMovedInfo);
    }

    public void mouseMoved(int x, int y, int button, Actor actor) {
        this.init();
        this.mouseInfo = this.mouseMovedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
    }

    public Actor getActor() {
        if (this.mouseInfo == null) {
            return null;
        }
        return this.mouseInfo.getActor();
    }

    public int getButton() {
        if (this.mouseInfo == null) {
            return 0;
        }
        return this.mouseInfo.getButton();
    }

    private boolean checkObject(Object obj, MouseInfo info) {
        if (info == null) {
            return false;
        }
        Actor actor = info.getActor();
        return obj == null || obj instanceof World && actor == null || actor == obj;
    }

    public String toString() {
        String s = "MouseEventData ";
        if (this.mouseInfo != null) {
            s = String.valueOf(s) + this.mouseInfo.toString();
        }
        if (this.mousePressedInfo != null) {
            s = String.valueOf(s) + " pressed";
        }
        if (this.mouseClickedInfo != null) {
            s = String.valueOf(s) + " clicked";
        }
        if (this.mouseDraggedInfo != null) {
            s = String.valueOf(s) + " dragged";
        }
        if (this.mouseDragEndedInfo != null) {
            s = String.valueOf(s) + " dragEnded";
        }
        if (this.mouseMovedInfo != null) {
            s = String.valueOf(s) + " moved";
        }
        return s;
    }
}

