/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.importer.scratch;

import greenfoot.importer.scratch.ScratchImage;
import greenfoot.importer.scratch.ScratchMedia;
import greenfoot.importer.scratch.ScratchObject;
import greenfoot.importer.scratch.ScratchPoint;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;

public class ImageMedia
extends ScratchMedia {
    private File imageFile;

    public ImageMedia(int version, List<ScratchObject> scratchObjects) {
        super(162, version, scratchObjects);
    }

    @Override
    public int fields() {
        return super.fields() + 5;
    }

    private ScratchImage getImage() {
        if (this.scratchObjects.get(super.fields() + 4) != null) {
            return (ScratchImage)this.scratchObjects.get(super.fields() + 4);
        }
        return (ScratchImage)this.scratchObjects.get(super.fields() + 0);
    }

    private byte[] getJpegBytes() {
        ScratchObject obj = (ScratchObject)this.scratchObjects.get(super.fields() + 3);
        if (obj == null) {
            return null;
        }
        return (byte[])obj.getValue();
    }

    public ScratchPoint getRotationCentre() {
        return (ScratchPoint)this.scratchObjects.get(super.fields() + 1);
    }

    public int getWidth() {
        byte[] jpegBytes = this.getJpegBytes();
        if (jpegBytes != null) {
            try {
                return ImageIO.read(new ByteArrayInputStream(jpegBytes)).getWidth();
            }
            catch (IOException e) {
                return -1;
            }
        }
        return this.getImage().getWidth();
    }

    public int getHeight() {
        byte[] jpegBytes = this.getJpegBytes();
        if (jpegBytes != null) {
            try {
                return ImageIO.read(new ByteArrayInputStream(jpegBytes)).getHeight();
            }
            catch (IOException e) {
                return -1;
            }
        }
        return this.getImage().getHeight();
    }

    @Override
    public File saveInto(File destDir, Properties props, String prefix) throws IOException {
        if (this.imageFile == null) {
            byte[] jpegBytes = this.getJpegBytes();
            String extension = jpegBytes == null ? "png" : "jpg";
            File imageDir = new File(destDir, "images");
            imageDir.mkdirs();
            int i = -1;
            while (true) {
                this.imageFile = new File(imageDir, String.valueOf(prefix) + ImageMedia.mungeChars(this.getMediaName()) + (i < 0 ? "" : "_" + i) + "." + extension);
                if (!this.imageFile.exists()) break;
                ++i;
            }
            if (jpegBytes != null) {
                FileOutputStream fos = new FileOutputStream(this.imageFile);
                fos.write(jpegBytes);
                fos.close();
            } else {
                ImageIO.write((RenderedImage)this.getImage().getBufferedImage(), "png", this.imageFile);
            }
        }
        return this.imageFile;
    }

    private static String mungeChars(String name) {
        return name.replaceAll("[:/\\\\]", "_");
    }
}

