/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.ClipCache;
import greenfoot.sound.ClipCloserThread;
import greenfoot.sound.ClipData;
import greenfoot.sound.ClipProcessThread;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundPlaybackListener;
import greenfoot.sound.SoundUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundClip
implements Sound,
LineListener {
    private static ClipCache clipCache = new ClipCache();
    private static ClipProcessThread processThread = new ClipProcessThread();
    private static ClipCloserThread closerThread = new ClipCloserThread();
    private final URL url;
    private ClipData clipData;
    private Clip soundClip;
    private ClipState clipState = ClipState.CLOSED;
    private ClipState currentState = ClipState.STOPPED;
    private int masterVolume = 100;
    private SoundPlaybackListener playbackListener;
    private boolean resumedLoop;
    private boolean resetToStart;

    public SoundClip(String name, URL url, SoundPlaybackListener listener) {
        this.url = url;
        this.playbackListener = listener;
    }

    private boolean open() {
        try {
            this.load();
            this.soundClip.addLineListener(this);
            return true;
        }
        catch (SecurityException e) {
            SoundExceptionHandler.handleSecurityException(e, this.url.toString());
        }
        catch (IllegalArgumentException e) {
            SoundExceptionHandler.handleIllegalArgumentException(e, this.url.toString());
        }
        catch (FileNotFoundException e) {
            SoundExceptionHandler.handleFileNotFoundException(e, this.url.toString());
        }
        catch (IOException e) {
            SoundExceptionHandler.handleIOException(e, this.url.toString());
        }
        catch (UnsupportedAudioFileException e) {
            SoundExceptionHandler.handleUnsupportedAudioFileException(e, this.url.toString());
        }
        catch (LineUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
        }
        return false;
    }

    private void load() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.clipData = clipCache.getCachedClip(this.url);
        ByteArrayInputStream is = new ByteArrayInputStream(this.clipData.getBuffer());
        AudioFormat format = this.clipData.getFormat();
        AudioInputStream stream = new AudioInputStream(is, format, this.clipData.getLength());
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        this.soundClip = (Clip)AudioSystem.getLine(info);
        this.soundClip.open(stream);
        this.setVolume(this.masterVolume);
    }

    public synchronized void preLoad() {
        try {
            this.clipData = clipCache.getCachedClip(this.url);
            clipCache.releaseClipData(this.clipData);
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void play() {
        if (this.clipState == ClipState.PLAYING) {
            return;
        }
        this.resumedLoop = false;
        if (this.soundClip == null) {
            processThread.addToQueue(this);
            this.currentState = ClipState.STOPPED;
        } else if (this.currentState == ClipState.STOPPED) {
            if (this.resetToStart) {
                this.resetToStart = false;
                this.soundClip.setFramePosition(0);
            }
            this.soundClip.loop(0);
            this.soundClip.start();
        } else {
            if (this.currentState == ClipState.STOPPING) {
                this.setState(ClipState.PLAYING);
                return;
            }
            if (this.currentState == ClipState.LOOPING) {
                this.soundClip.loop(0);
            }
        }
        this.setState(ClipState.PLAYING);
        if (this.soundClip != null) {
            this.currentState = ClipState.PLAYING;
        }
    }

    @Override
    public synchronized void loop() {
        if (this.clipState == ClipState.LOOPING) {
            return;
        }
        if (this.soundClip == null) {
            processThread.addToQueue(this);
            this.currentState = ClipState.STOPPED;
        } else if (this.currentState == ClipState.STOPPED) {
            if (this.resetToStart) {
                this.resetToStart = false;
                this.soundClip.setFramePosition(0);
            }
            this.soundClip.setLoopPoints(0, -1);
            this.soundClip.loop(-1);
        } else {
            if (this.currentState == ClipState.STOPPING) {
                this.setState(ClipState.LOOPING);
                return;
            }
            if (this.currentState == ClipState.PLAYING) {
                this.soundClip.setLoopPoints(0, -1);
                this.soundClip.loop(-1);
                this.resumedLoop = true;
            }
        }
        this.setState(ClipState.LOOPING);
        if (this.soundClip != null) {
            this.currentState = ClipState.LOOPING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processState() {
        Clip soundClip;
        ClipState toState;
        SoundClip soundClip2 = this;
        synchronized (soundClip2) {
            toState = this.clipState;
            soundClip = this.soundClip;
            if (this.clipState == ClipState.PLAYING) {
                if (this.currentState != ClipState.PLAYING) {
                    if (soundClip == null && !this.open()) {
                        return;
                    }
                    soundClip = this.soundClip;
                    soundClip.start();
                    this.currentState = ClipState.PLAYING;
                }
                return;
            }
            if (this.clipState == ClipState.LOOPING) {
                if (this.currentState != ClipState.LOOPING) {
                    if (soundClip == null && !this.open()) {
                        return;
                    }
                    soundClip = this.soundClip;
                    soundClip.setFramePosition(0);
                    soundClip.setLoopPoints(0, -1);
                    soundClip.loop(-1);
                    this.resumedLoop = false;
                    this.currentState = ClipState.LOOPING;
                }
                return;
            }
            if (this.clipState == ClipState.CLOSED) {
                return;
            }
            if (this.isPaused() || this.clipState == ClipState.STOPPED) {
                if (this.currentState == ClipState.PLAYING || this.currentState == ClipState.LOOPING) {
                    this.currentState = ClipState.STOPPING;
                    this.resumedLoop = false;
                } else {
                    return;
                }
            }
        }
        if (toState == ClipState.STOPPED || toState == ClipState.PAUSED_LOOPING || toState == ClipState.PAUSED_PLAYING) {
            soundClip.stop();
            soundClip2 = this;
            synchronized (soundClip2) {
                if (this.resetToStart) {
                    this.resetToStart = false;
                    soundClip.setFramePosition(0);
                }
                this.currentState = ClipState.STOPPED;
                if (this.clipState == ClipState.PLAYING) {
                    soundClip.loop(0);
                    soundClip.start();
                    this.currentState = ClipState.PLAYING;
                } else if (this.clipState == ClipState.LOOPING) {
                    soundClip.setLoopPoints(0, -1);
                    soundClip.loop(-1);
                    this.currentState = ClipState.LOOPING;
                }
            }
        }
    }

    @Override
    public synchronized void setVolume(int level) {
        this.masterVolume = level;
        if (this.soundClip != null && this.soundClip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volume = (FloatControl)this.soundClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue(SoundUtils.convertMinMax(level, volume.getMinimum(), volume.getMaximum()));
        }
    }

    @Override
    public synchronized int getVolume() {
        return this.masterVolume;
    }

    @Override
    public synchronized void stop() {
        if (this.isStopped()) {
            return;
        }
        this.setState(ClipState.STOPPED);
        if (this.soundClip != null) {
            if (this.currentState == ClipState.STOPPED) {
                closerThread.addClip(this.soundClip);
                this.soundClip = null;
            } else {
                this.resetToStart = true;
                processThread.addToQueue(this);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.clipState != ClipState.CLOSED) {
            if (this.soundClip != null) {
                this.setVolume(0);
                clipCache.releaseClipData(this.clipData);
                closerThread.addClip(this.soundClip);
                this.soundClip = null;
            }
            this.setState(ClipState.CLOSED);
        }
    }

    @Override
    public synchronized void pause() {
        this.resumedLoop = false;
        if (this.soundClip == null) {
            return;
        }
        if (this.clipState == ClipState.PLAYING) {
            this.setState(ClipState.PAUSED_PLAYING);
            processThread.addToQueue(this);
        }
        if (this.clipState == ClipState.LOOPING) {
            this.setState(ClipState.PAUSED_LOOPING);
            processThread.addToQueue(this);
        }
    }

    private void setState(ClipState newState) {
        if (this.clipState != newState) {
            this.clipState = newState;
            switch (this.clipState) {
                case PLAYING: {
                    this.playbackListener.playbackStarted(this);
                    break;
                }
                case STOPPED: {
                    this.playbackListener.playbackStopped(this);
                    break;
                }
                case PAUSED_LOOPING: {
                    this.playbackListener.playbackPaused(this);
                    break;
                }
                case PAUSED_PLAYING: {
                    this.playbackListener.playbackPaused(this);
                    break;
                }
                case LOOPING: {
                    this.playbackListener.playbackStarted(this);
                    break;
                }
                case CLOSED: {
                    this.playbackListener.soundClosed(this);
                }
            }
        }
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.clipState == ClipState.PLAYING || this.clipState == ClipState.LOOPING;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.clipState == ClipState.PAUSED_PLAYING || this.clipState == ClipState.PAUSED_LOOPING;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.clipState == ClipState.STOPPED || this.clipState == ClipState.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            SoundClip soundClip = this;
            synchronized (soundClip) {
                if (this.currentState != ClipState.STOPPING) {
                    this.currentState = ClipState.STOPPED;
                    if (this.resumedLoop && this.clipState == ClipState.LOOPING) {
                        closerThread.addClip(this.soundClip);
                        this.soundClip = null;
                        processThread.addToQueue(this);
                    } else if (!this.isPaused()) {
                        this.setState(ClipState.STOPPED);
                        if (this.clipState == ClipState.STOPPED && this.soundClip != null) {
                            closerThread.addClip(this.soundClip);
                            this.soundClip = null;
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return this.url + " " + super.toString();
    }

    private static enum ClipState {
        STOPPED,
        PLAYING,
        PAUSED_LOOPING,
        PAUSED_PLAYING,
        CLOSED,
        LOOPING,
        STOPPING;

    }
}

