/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlaybackListener;
import java.util.HashSet;
import java.util.Set;

public class SoundCollection
implements SimulationListener,
SoundPlaybackListener {
    private Set<Sound> playingSounds = new HashSet<Sound>();
    private Set<Sound> pausedSounds = new HashSet<Sound>();
    private Set<Sound> stoppedSounds = new HashSet<Sound>();
    private volatile boolean ignoreEvents = false;

    @Override
    public void simulationChanged(SimulationEvent e) {
        if (e.getType() == 3) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        SoundCollection soundCollection = this;
        synchronized (soundCollection) {
            this.ignoreEvents = true;
        }
        for (Sound sound : this.playingSounds) {
            sound.close();
        }
        for (Sound sound : this.pausedSounds) {
            sound.close();
        }
        for (Sound sound : this.stoppedSounds) {
            sound.close();
        }
        this.playingSounds.clear();
        this.pausedSounds.clear();
        this.stoppedSounds.clear();
        SoundCollection soundCollection2 = this;
        synchronized (soundCollection2) {
            this.ignoreEvents = false;
        }
    }

    @Override
    public synchronized void playbackStarted(Sound sound) {
        if (!this.ignoreEvents) {
            this.playingSounds.add(sound);
            this.pausedSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }

    @Override
    public synchronized void playbackStopped(Sound sound) {
        if (!this.ignoreEvents) {
            this.playingSounds.remove(sound);
            this.pausedSounds.remove(sound);
            this.stoppedSounds.add(sound);
        }
    }

    @Override
    public synchronized void playbackPaused(Sound sound) {
        if (!this.ignoreEvents) {
            this.pausedSounds.add(sound);
            this.playingSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }

    @Override
    public synchronized void soundClosed(Sound sound) {
        if (!this.ignoreEvents) {
            this.pausedSounds.remove(sound);
            this.playingSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }
}

