/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.Config;
import bluej.utility.Debug;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalAppLauncher {
    private static String imageEditor = Config.getPropString((String)"greenfoot.editor.image", null);

    public static void openFile(File file) {
        try {
            if (!Desktop.isDesktopSupported()) {
                throw new RuntimeException("Cannot open editor for the file, because the Desktop class is not supported on this platform.");
            }
            Desktop desktop = Desktop.getDesktop();
            desktop.open(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void editImage(File file) {
        boolean success = false;
        if (imageEditor != null && !(success = ExternalAppLauncher.launchProgram(new File(imageEditor), file.toString()))) {
            System.err.println("Could not launch the external program: " + imageEditor);
        }
        if (!success) {
            ExternalAppLauncher.editFile(file);
        }
    }

    private static void editFile(File file) {
        block5: {
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.EDIT)) {
                        desktop.edit(file);
                    } else {
                        Runtime.getRuntime().exec(new String[]{"gimp", file.getAbsolutePath()}, null, null);
                    }
                    break block5;
                }
                throw new RuntimeException("Cannot open editor for the file, because the Desktop class is not supported on this platform.");
            }
            catch (Exception ex) {
                Debug.reportError((String)"Error editing image", (Throwable)ex);
            }
        }
    }

    public static boolean launchProgram(File program, String file) {
        if (Config.isMacOS() && program.isDirectory()) {
            String[] cmd = new String[]{"open", "-a", program.toString(), file};
            try {
                ExternalAppLauncher.execWithOutput(cmd);
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (program.canExecute()) {
            String[] cmd = new String[]{program.toString(), file};
            try {
                ExternalAppLauncher.execWithOutput(cmd);
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private static void execWithOutput(String[] cmd) throws IOException {
        Process p = Runtime.getRuntime().exec(cmd);
        StreamRedirector errRedirector = new StreamRedirector(p.getErrorStream(), System.err);
        errRedirector.start();
        StreamRedirector outRedirector = new StreamRedirector(p.getInputStream(), System.out);
        outRedirector.start();
    }

    private static class StreamRedirector
    extends Thread {
        private OutputStream target;
        private InputStream source;

        public StreamRedirector(InputStream source, OutputStream target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void run() {
            int len = 0;
            while (len != -1) {
                byte[] bytes = new byte[50];
                try {
                    len = this.source.read(bytes);
                    if (len == -1) continue;
                    this.target.write(bytes, 0, len);
                    this.target.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

