/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ClassPathEntry;
import javax.swing.table.AbstractTableModel;

public class ClassPathTableModel
extends AbstractTableModel {
    static final String statusLabel = Config.getString("classmgr.statuscolumn");
    static final String locationLabel = Config.getString("classmgr.locationcolumn");
    private ClassPath origcp;
    private ClassPath cp;

    public ClassPathTableModel(ClassPath origcp) {
        this.origcp = origcp;
        this.cp = new ClassPath(origcp);
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return statusLabel;
        }
        if (col == 1) {
            return locationLabel;
        }
        throw new IllegalArgumentException("bad column number in ClassPathTableModel::getColumnName()");
    }

    @Override
    public int getRowCount() {
        return this.cp.getEntries().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ClassPathEntry entry = this.cp.getEntries().get(row);
        if (col == 0) {
            return entry.getStatusString();
        }
        if (col == 1) {
            return entry.getCanonicalPathNoException();
        }
        if (col == 2) {
            return entry.getDescription();
        }
        throw new IllegalArgumentException("bad column number in ClassPathTableModel::getValueAt()");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            ClassPathEntry entry = this.cp.getEntries().get(row);
            entry.setDescription((String)value);
            this.fireTableCellUpdated(row, col);
        }
    }

    public void addEntry(ClassPathEntry cpe) {
        int s = this.cp.getEntries().size();
        this.cp.getEntries().add(cpe);
        this.fireTableRowsInserted(s, s);
    }

    public void deleteEntry(int index) {
        if (index < this.cp.getEntries().size() && index >= 0) {
            this.cp.getEntries().remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void commitEntries() {
        this.origcp.removeAll();
        this.origcp.addClassPath(this.cp);
    }

    public void revertEntries() {
        this.cp = new ClassPath(this.origcp);
        this.fireTableDataChanged();
    }
}

