/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsCommand;
import bluej.groupwork.cvsnb.CvsRepository;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CvsCommitAllCommand
extends CvsCommand {
    private Set<File> newFiles;
    private Set<File> binaryNewFiles;
    private Set<File> deletedFiles;
    private Set<File> files;
    private String commitComment;

    public CvsCommitAllCommand(CvsRepository repository, Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        super(repository);
        this.newFiles = newFiles;
        this.binaryNewFiles = binaryNewFiles;
        this.deletedFiles = deletedFiles;
        this.files = files;
        this.commitComment = commitComment;
    }

    @Override
    protected BasicServerResponse doCommand() throws CommandAbortedException, CommandException, AuthenticationException {
        File parent;
        BlueJCvsClient client = this.getClient();
        File projectPath = this.repository.getProjectPath();
        LinkedHashSet dirs = new LinkedHashSet();
        LinkedList<File> stack = new LinkedList<File>();
        for (File file : this.newFiles) {
            parent = file.getParentFile();
            while (!this.repository.isDirectoryUnderCVS(parent) && !dirs.contains(parent)) {
                stack.addLast(parent);
                if (parent.equals(projectPath)) break;
                parent = parent.getParentFile();
            }
            while (!stack.isEmpty()) {
                dirs.add(stack.removeLast());
            }
        }
        for (File file : this.binaryNewFiles) {
            parent = file.getParentFile();
            while (!this.repository.isDirectoryUnderCVS(parent) && !dirs.contains(parent)) {
                stack.addLast(parent);
                if (parent.equals(projectPath)) break;
                parent = parent.getParentFile();
            }
            while (!stack.isEmpty()) {
                dirs.add(stack.removeLast());
            }
        }
        dirs.addAll(this.newFiles);
        BasicServerResponse basicServerResponse = this.repository.removeFromRepository(client, this.deletedFiles);
        if (basicServerResponse.isError()) {
            return basicServerResponse;
        }
        client = this.getClient();
        basicServerResponse = this.repository.addToRepository(client, CvsCommitAllCommand.listToFileArray(dirs), false);
        if (basicServerResponse.isError()) {
            return basicServerResponse;
        }
        client = this.getClient();
        basicServerResponse = this.repository.addToRepository(client, CvsCommitAllCommand.listToFileArray(this.binaryNewFiles), true);
        if (basicServerResponse.isError()) {
            return basicServerResponse;
        }
        client = this.getClient();
        basicServerResponse = this.repository.commitToRepository(client, this.files, this.commitComment);
        return basicServerResponse;
    }

    private static File[] listToFileArray(Collection<? extends File> fileList) {
        return fileList.toArray(new File[fileList.size()]);
    }
}

