/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;

public class ResourceDescriptor {
    public static String getResource(Project project, Object value, boolean annotate) {
        String status = value.toString();
        if (value instanceof TeamStatusInfo) {
            TeamStatusInfo info = (TeamStatusInfo)value;
            boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
            if (isPkgFile) {
                status = Config.getString("team.commit.layout") + " " + project.getPackageForFile(info.getFile());
            }
            if (annotate) {
                if (info.getStatus() == 2) {
                    status = status + " (" + Config.getString("team.status.delete") + ")";
                } else if (info.getStatus() == 6) {
                    status = status + " (" + Config.getString("team.status.add") + ")";
                } else if (info.getStatus() == 1) {
                    status = status + " (" + Config.getString("team.status.new") + ")";
                } else if (info.getStatus() == 7 || info.getStatus() == 13) {
                    status = status + " (" + Config.getString("team.status.removed") + ")";
                } else if (info.getStatus() == 5 && !isPkgFile) {
                    status = status + " (" + Config.getString("team.status.needsmerge") + ")";
                }
            }
        }
        return status;
    }
}

