/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.parser.nodes.RBTreeNode;
import java.util.Iterator;

public class NodeTree<T extends RBTreeNode<T>> {
    private int pnodeOffset;
    private int pnodeSize;
    private NodeTree<T> parent;
    private NodeTree<T> left;
    private T pnode;
    private NodeTree<T> right;
    private boolean black;

    public NodeTree() {
        this.black = true;
    }

    public Iterator<NodeAndPosition<T>> iterator(int offset) {
        return new NodeTreeIterator(offset, this);
    }

    public NodeAndPosition<T> findNode(int pos) {
        return this.findNode(pos, 0);
    }

    public NodeAndPosition<T> findNode(int pos, int startpos) {
        if (this.pnode == null) {
            return null;
        }
        if (startpos + this.pnodeOffset >= pos) {
            NodeAndPosition<T> r = null;
            if (this.left != null) {
                r = this.left.findNode(pos, startpos);
            }
            if (r == null && startpos + this.pnodeOffset == pos) {
                r = new NodeAndPosition<T>(this.pnode, startpos + this.pnodeOffset, this.pnodeSize);
            }
            return r;
        }
        if (startpos + this.pnodeSize + this.pnodeOffset >= pos) {
            return new NodeAndPosition<T>(this.pnode, startpos + this.pnodeOffset, this.pnodeSize);
        }
        if (this.right != null) {
            return this.right.findNode(pos, startpos + this.pnodeOffset + this.pnodeSize);
        }
        return null;
    }

    public NodeAndPosition<T> findNodeAtOrBefore(int pos) {
        return this.findNodeAtOrBefore(pos, 0);
    }

    public NodeAndPosition<T> findNodeAtOrBefore(int pos, int startpos) {
        if (this.pnode == null) {
            return null;
        }
        if (startpos + this.pnodeOffset > pos) {
            if (this.left != null) {
                return this.left.findNodeAtOrBefore(pos, startpos);
            }
            return null;
        }
        if (startpos + this.pnodeSize + this.pnodeOffset > pos) {
            return new NodeAndPosition<T>(this.pnode, startpos + this.pnodeOffset, this.pnodeSize);
        }
        NodeAndPosition<T> rval = null;
        if (this.right != null) {
            rval = this.right.findNodeAtOrBefore(pos, startpos + this.pnodeOffset + this.pnodeSize);
        }
        if (rval == null) {
            rval = new NodeAndPosition<T>(this.pnode, startpos + this.pnodeOffset, this.pnodeSize);
        }
        return rval;
    }

    public NodeAndPosition<T> findNodeAtOrAfter(int pos) {
        return this.findNodeAtOrAfter(pos, 0);
    }

    public NodeAndPosition<T> findNodeAtOrAfter(int pos, int startpos) {
        NodeAndPosition<T> rval;
        if (this.pnode == null) {
            return null;
        }
        if (startpos + this.pnodeOffset >= pos && this.left != null && (rval = this.left.findNodeAtOrAfter(pos, startpos)) != null) {
            return rval;
        }
        if (startpos + this.pnodeSize + this.pnodeOffset >= pos) {
            return new NodeAndPosition<T>(this.pnode, startpos + this.pnodeOffset, this.pnodeSize);
        }
        rval = null;
        if (this.right != null) {
            rval = this.right.findNodeAtOrAfter(pos, startpos + this.pnodeOffset + this.pnodeSize);
        }
        return rval;
    }

    public void resize(int newSize) {
        int delta = newSize - this.pnodeSize;
        this.pnodeSize = newSize;
        NodeTree<T> nt = this;
        while (nt.parent != null) {
            if (nt.parent.left == nt) {
                nt.parent.pnodeOffset += delta;
            }
            nt = nt.parent;
        }
    }

    public void setSize(int newSize) {
        int delta = newSize - this.pnodeSize;
        this.pnodeSize = newSize;
        NodeTree<T> nt = this.right;
        while (nt != null) {
            nt.pnodeOffset -= delta;
            nt = nt.left;
        }
    }

    public void slideNode(int offset) {
        this.pnodeOffset += offset;
        NodeTree<T> nt = this;
        while (nt.parent != null) {
            if (nt.parent.left == nt) {
                nt.parent.pnodeOffset += offset;
            }
            nt = nt.parent;
        }
    }

    public void slideStart(int offset) {
        this.pnodeOffset += offset;
        this.pnodeSize -= offset;
    }

    public int getNodeSize() {
        return this.pnodeSize;
    }

    public void insertNode(T newNode, int pos, int size) {
        if (this.pnode == null) {
            this.pnode = newNode;
            ((RBTreeNode)this.pnode).setContainingNodeTree(this);
            this.pnodeOffset = pos;
            this.pnodeSize = size;
            size = pos + size;
        } else if (pos < this.pnodeOffset) {
            assert (pos + size <= this.pnodeOffset);
            if (this.left == null) {
                this.left = new NodeTree<T>(this, newNode, pos, size);
                NodeTree.fixupNewNode(this.left);
            } else {
                this.left.insertNode(newNode, pos, size);
            }
        } else {
            assert (this.pnodeOffset + this.pnodeSize <= pos);
            pos -= this.pnodeOffset + this.pnodeSize;
            if (this.right == null) {
                this.right = new NodeTree<T>(this, newNode, pos, size);
                NodeTree.fixupNewNode(this.right);
            } else {
                this.right.insertNode(newNode, pos, size);
            }
        }
    }

    public void remove() {
        if (this.left == null || this.right == null) {
            this.one_child_remove();
        } else {
            NodeTree<T> sub = this.left;
            int nmoffset = 0;
            while (sub.right != null) {
                nmoffset += sub.pnodeOffset + sub.pnodeSize;
                sub = sub.right;
            }
            NodeTree.swapNodeData(this, sub);
            this.pnodeOffset += nmoffset;
            int rchange = sub.pnodeOffset + sub.pnodeSize - (this.pnodeOffset + this.pnodeSize);
            super.adjustLeftOffsets(rchange);
            super.one_child_remove();
        }
    }

    public int getPosition() {
        int pos = this.pnodeOffset;
        NodeTree<T> parent = this.parent;
        NodeTree<T> current = this;
        while (parent != null) {
            if (current == parent.right) {
                pos += parent.pnodeOffset + parent.pnodeSize;
            }
            current = parent;
            parent = current.parent;
        }
        return pos;
    }

    private void adjustLeftOffsets(int amount) {
        NodeTree<T> nt = this;
        while (nt != null) {
            nt.pnodeOffset += amount;
            nt = nt.left;
        }
    }

    private static <T extends RBTreeNode<T>> void replace_node(NodeTree<T> dest, NodeTree<T> with) {
        if (dest.parent != null) {
            if (dest.parent.left == dest) {
                dest.parent.left = with;
            } else {
                dest.parent.right = with;
            }
        }
        if (with != null) {
            with.parent = dest.parent;
        }
    }

    private void one_child_remove() {
        if (this.left == null && this.right == null) {
            this.pnode = null;
            if (this.parent != null) {
                if (this.black) {
                    this.delete_case_1();
                }
                if (this.parent.left == this) {
                    this.parent.left = null;
                } else {
                    this.parent.right = null;
                }
            }
        } else if (this.parent == null) {
            if (this.left == null) {
                int offset = this.pnodeOffset + this.pnodeSize;
                NodeTree.swapNodeData(this, this.right);
                this.pnodeOffset += offset;
                this.right = null;
            } else {
                NodeTree.swapNodeData(this, this.left);
                this.left = null;
            }
            this.black = true;
        } else if (this.left == null) {
            int offset = this.pnodeOffset + this.pnodeSize;
            NodeTree.replace_node(this, this.right);
            super.adjustLeftOffsets(offset);
            this.right.black = true;
        } else {
            NodeTree.replace_node(this, this.left);
            this.left.black = true;
        }
    }

    private NodeTree<T> getSibling() {
        if (this.parent != null) {
            if (this.parent.left == this) {
                return this.parent.right;
            }
            return this.parent.left;
        }
        return null;
    }

    private void delete_case_1() {
        if (this.parent != null) {
            NodeTree<T> sibling = this.getSibling();
            if (!sibling.black) {
                this.parent.black = false;
                sibling.black = true;
                if (this == this.parent.left) {
                    NodeTree.rotateLeft(this.parent);
                } else {
                    NodeTree.rotateRight(this.parent);
                }
            }
            this.delete_case_3();
        }
    }

    private void delete_case_3() {
        NodeTree<T> sibling = this.getSibling();
        if (this.parent.black && sibling.black && NodeTree.isBlack(sibling.left) && NodeTree.isBlack(sibling.right)) {
            sibling.black = false;
            super.delete_case_1();
        } else if (!this.parent.black && sibling.black && NodeTree.isBlack(sibling.left) && NodeTree.isBlack(sibling.right)) {
            sibling.black = false;
            this.parent.black = true;
        } else {
            if (NodeTree.isBlack(sibling)) {
                if (this == this.parent.left && NodeTree.isBlack(sibling.right) && !NodeTree.isBlack(sibling.left)) {
                    sibling.black = false;
                    sibling.left.black = true;
                    NodeTree.rotateRight(sibling);
                } else if (this == this.parent.right && NodeTree.isBlack(sibling.left) && !NodeTree.isBlack(sibling.right)) {
                    sibling.black = false;
                    sibling.right.black = true;
                    NodeTree.rotateLeft(sibling);
                }
            }
            sibling.black = this.parent.black;
            this.parent.black = true;
            if (this == this.parent.left) {
                sibling.right.black = true;
                NodeTree.rotateLeft(this.parent);
            } else {
                sibling.left.black = true;
                NodeTree.rotateRight(this.parent);
            }
        }
    }

    public void clear() {
        this.left = null;
        this.pnode = null;
        this.right = null;
    }

    private static <T extends RBTreeNode<T>> void fixupNewNode(NodeTree<T> n) {
        if (n.parent == null) {
            n.black = true;
            return;
        }
        if (super.isBlack()) {
            return;
        }
        NodeTree<T> grandparent = super.getGrandparent();
        NodeTree<T> uncle = super.getUncle();
        if (!NodeTree.isBlack(uncle)) {
            uncle.black = true;
            n.parent.black = true;
            grandparent.black = false;
            NodeTree.fixupNewNode(grandparent);
            return;
        }
        NodeTree<T> parent = n.parent;
        if (n == parent.right && parent == grandparent.left) {
            NodeTree.rotateLeft(parent);
        } else if (n == parent.left && parent == grandparent.right) {
            NodeTree.rotateRight(n.parent);
        }
        parent.black = true;
        grandparent.black = false;
        if (n == parent.left && parent == grandparent.left) {
            NodeTree.rotateRight(grandparent);
        } else {
            NodeTree.rotateLeft(grandparent);
        }
    }

    private static <T extends RBTreeNode<T>> void swapNodeData(NodeTree<T> n, NodeTree<T> m) {
        T pn = n.pnode;
        int offset = n.pnodeOffset;
        int size = n.pnodeSize;
        n.pnode = m.pnode;
        n.pnodeOffset = m.pnodeOffset;
        n.pnodeSize = m.pnodeSize;
        m.pnode = pn;
        m.pnodeOffset = offset;
        m.pnodeSize = size;
        if (n.pnode != null) {
            ((RBTreeNode)n.pnode).setContainingNodeTree(n);
        }
        if (m.pnode != null) {
            ((RBTreeNode)m.pnode).setContainingNodeTree(m);
        }
    }

    private static <T extends RBTreeNode<T>> void rotateLeft(NodeTree<T> n) {
        NodeTree.swapNodeData(n, n.right);
        boolean nblack = n.black;
        n.black = n.right.black;
        n.right.black = nblack;
        n.pnodeOffset += n.right.pnodeOffset + n.right.pnodeSize;
        if (n.left == null) {
            n.left = n.right;
            n.right = n.left.right;
            if (n.right != null) {
                n.right.parent = n;
            }
            n.left.right = null;
            return;
        }
        NodeTree<T> oldLeft = n.left;
        n.left = n.right;
        n.right = n.left.right;
        if (n.right != null) {
            n.right.parent = n;
        }
        n.left.right = n.left.left;
        n.left.left = oldLeft;
        if (oldLeft != null) {
            oldLeft.parent = n.left;
        }
    }

    private static <T extends RBTreeNode<T>> void rotateRight(NodeTree<T> n) {
        NodeTree.swapNodeData(n, n.left);
        boolean nblack = n.black;
        n.black = n.left.black;
        n.left.black = nblack;
        if (n.right == null) {
            n.right = n.left;
            n.left = n.right.left;
            if (n.left != null) {
                n.left.parent = n;
            }
            n.right.left = null;
            n.right.pnodeOffset -= n.pnodeOffset + n.pnodeSize;
            return;
        }
        NodeTree<T> oldRight = n.right;
        n.right = n.left;
        n.left = n.right.left;
        if (n.left != null) {
            n.left.parent = n;
        }
        n.right.left = n.right.right;
        n.right.right = oldRight;
        if (oldRight != null) {
            oldRight.parent = n.right;
        }
        n.right.pnodeOffset -= n.pnodeOffset + n.pnodeSize;
    }

    private NodeTree<T> getGrandparent() {
        if (this.parent != null) {
            return this.parent.parent;
        }
        return null;
    }

    private NodeTree<T> getUncle() {
        return super.getSibling();
    }

    private NodeTree(NodeTree<T> parent, T node, int offset, int size) {
        this.parent = parent;
        this.pnode = node;
        ((RBTreeNode)this.pnode).setContainingNodeTree(this);
        this.pnodeSize = size;
        this.pnodeOffset = offset;
        this.black = false;
    }

    private boolean isBlack() {
        return this.black;
    }

    private static boolean isBlack(NodeTree<?> n) {
        return n == null || n.black;
    }

    private static class NodeTreeIterator<T extends RBTreeNode<T>>
    implements Iterator<NodeAndPosition<T>> {
        int pos = 0;
        int offset = 0;
        NodeTree<T> current = null;

        public NodeTreeIterator(int offset, NodeTree<T> tree) {
            this.offset = offset;
            if (((NodeTree)tree).pnode != null) {
                this.current = tree;
                if (((NodeTree)tree).left == null) {
                    this.pos = 1;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public NodeAndPosition<T> next() {
            while (true) {
                if (this.pos == 0) {
                    this.current = ((NodeTree)this.current).left;
                    if (((NodeTree)this.current).left != null) continue;
                    this.pos = 1;
                    continue;
                }
                NodeTree top = this.current;
                if (this.pos == 1) {
                    this.pos = 2;
                    NodeAndPosition<RBTreeNode> rval = new NodeAndPosition<RBTreeNode>(top.pnode, top.pnodeOffset + this.offset, top.pnodeSize);
                    if (top.right == null) {
                        this.downStackRight();
                    }
                    return rval;
                }
                if (top.right == null) {
                    throw new NullPointerException();
                }
                this.offset += top.pnodeOffset + top.pnodeSize;
                this.current = top = top.right;
                this.pos = top.left != null ? 0 : 1;
            }
        }

        private void downStackRight() {
            NodeTree<T> top = this.current;
            this.current = ((NodeTree)this.current).parent;
            while (this.current != null && ((NodeTree)this.current).right == top) {
                top = this.current;
                this.current = ((NodeTree)this.current).parent;
                this.offset -= ((NodeTree)top).pnodeOffset + ((NodeTree)top).pnodeSize;
            }
            this.pos = 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NodeAndPosition<T extends RBTreeNode<T>> {
        private T parsedNode;
        private int position;
        private int size;

        public NodeAndPosition(T pn, int position, int size) {
            this.parsedNode = pn;
            this.position = position;
            this.size = size;
        }

        public T getNode() {
            return this.parsedNode;
        }

        public int getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public int getEnd() {
            return this.position + this.size;
        }

        public NodeAndPosition<T> nextSibling() {
            NodeTree nt = ((RBTreeNode)this.parsedNode).getContainingNodeTree();
            if (nt.right != null) {
                int offs = this.position + nt.pnodeSize;
                nt = nt.right;
                while (nt.left != null) {
                    nt = nt.left;
                }
                return new NodeAndPosition<RBTreeNode>(nt.pnode, offs + nt.pnodeOffset, nt.pnodeSize);
            }
            int offs = this.position - nt.pnodeOffset;
            while (nt.parent != null) {
                if (nt.parent.left == nt) {
                    nt = nt.parent;
                    return new NodeAndPosition<RBTreeNode>(nt.pnode, offs + nt.pnodeOffset, nt.pnodeSize);
                }
                nt = nt.parent;
                offs -= nt.pnodeOffset + nt.pnodeSize;
            }
            return null;
        }

        public NodeAndPosition<T> prevSibling() {
            NodeTree nt = ((RBTreeNode)this.parsedNode).getContainingNodeTree();
            if (nt.left != null) {
                int offs = this.position - nt.pnodeOffset;
                nt = nt.left;
                while (nt.right != null) {
                    offs += nt.pnodeOffset + nt.pnodeSize;
                    nt = nt.right;
                }
                return new NodeAndPosition<RBTreeNode>(nt.pnode, offs + nt.pnodeOffset, nt.pnodeSize);
            }
            while (nt.parent != null) {
                int offs = this.position - nt.pnodeOffset;
                if (nt.parent.right == nt) {
                    nt = nt.parent;
                    return new NodeAndPosition<RBTreeNode>(nt.pnode, offs - nt.pnodeSize, nt.pnodeSize);
                }
                nt = nt.parent;
            }
            return null;
        }

        public void slide(int amount) {
            ((RBTreeNode)this.getNode()).slide(amount);
            this.position += amount;
        }

        public void slideStart(int amount) {
            ((RBTreeNode)this.getNode()).slideStart(amount);
            this.position += amount;
            this.size -= amount;
        }

        public void resize(int newSize) {
            ((RBTreeNode)this.getNode()).resize(newSize);
            this.size = newSize;
        }

        public void setSize(int newSize) {
            ((RBTreeNode)this.getNode()).setSize(newSize);
            this.size = newSize;
        }

        public void setNapSize(int newSize) {
            this.size = newSize;
        }
    }
}

