/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.util.Iterator;
import java.util.List;

public class MultiIterator<T>
implements Iterator<T> {
    List<Iterator<? extends T>> iterations;
    int current;

    public MultiIterator(List<Iterator<? extends T>> iterations) {
        this.iterations = iterations;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        while (this.current < this.iterations.size()) {
            if (this.iterations.get(this.current).hasNext()) {
                return true;
            }
            ++this.current;
        }
        return false;
    }

    @Override
    public T next() {
        while (this.current < this.iterations.size()) {
            Iterator<T> it = this.iterations.get(this.current);
            if (it.hasNext()) {
                return it.next();
            }
            ++this.current;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

