/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class PersistentMarkDocument
extends AbstractDocument {
    protected Element root = this.createDefaultRoot();
    public static final String tabSizeAttribute = "tabSize";

    public PersistentMarkDocument() {
        super(new GapContent());
    }

    @Override
    public Element getDefaultRootElement() {
        return this.root;
    }

    @Override
    public Element getParagraphElement(int pos) {
        int index = this.root.getElementIndex(pos);
        return this.root.getElement(index);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement map = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element[] lines = new Element[]{new LeafElement(map, null, 0, 1)};
        map.replace(0, 0, lines);
        return map;
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        Segment s = new Segment();
        try {
            this.getText(offset, length, s);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        int index = lineMap.getElementIndex(offset);
        LeafElement firstAffected = (LeafElement)lineMap.getElement(index);
        int lindex = lineMap.getElementIndex(offset + length);
        LeafElement nextLine = (LeafElement)lineMap.getElement(lindex);
        if (offset > 0 && offset + length == nextLine.getStartOffset()) {
            Position origEndPos = firstAffected.end;
            firstAffected.setEndOffset(offset);
            chng.addEdit(new SetEndPos(firstAffected, origEndPos, firstAffected.end));
            nextLine.setStartOffset(offset);
            Position origStartPos = nextLine.start;
            chng.addEdit(new SetStartPos(nextLine, origStartPos, nextLine.start));
            firstAffected = nextLine;
            nextLine = (LeafElement)lineMap.getElement(lindex + 1);
        }
        ArrayList<LeafElement> added = new ArrayList<LeafElement>();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            int origEnd = firstAffected.getEndOffset();
            Position origEndPos = firstAffected.end;
            firstAffected.setEndOffset(i + offset + 1);
            chng.addEdit(new SetEndPos(firstAffected, origEndPos, firstAffected.end));
            LeafElement newFirst = new LeafElement(this.root, attr, i + offset + 1, origEnd);
            added.add(newFirst);
            firstAffected = newFirst;
        }
        if (!added.isEmpty()) {
            Element[] removed = new Element[]{};
            Element[] addedArr = new Element[added.size()];
            added.toArray(addedArr);
            lineMap.replace(lindex + 1, 0, addedArr);
            AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, lindex + 1, removed, addedArr);
            chng.addEdit(ee);
        }
        super.insertUpdate(chng, attr);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        AbstractDocument.BranchElement lineMap = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int offset = chng.getOffset();
        int length = chng.getLength();
        int index = lineMap.getElementIndex(offset);
        LeafElement first = (LeafElement)lineMap.getElement(index);
        if (offset != 0 && first.getStartOffset() == offset) {
            LeafElement prev = (LeafElement)lineMap.getElement(index - 1);
            try {
                Position newEnd = this.createPosition(offset + length);
                Position newStart = this.createPosition(offset + length);
                chng.addEdit(new SetEndPos(prev, prev.end, newEnd));
                chng.addEdit(new SetStartPos(first, first.start, newStart));
            }
            catch (BadLocationException ble) {
                throw new RuntimeException(ble);
            }
        }
        if (first.getEndOffset() > offset + length) {
            return;
        }
        ArrayList<LeafElement> removed = new ArrayList<LeafElement>();
        int lastIndex = index + 1;
        LeafElement last = (LeafElement)lineMap.getElement(lastIndex);
        removed.add(last);
        while (last.getEndOffset() <= offset + length) {
            last = (LeafElement)lineMap.getElement(++lastIndex);
            removed.add(last);
        }
        Position origEnd = first.end;
        first.end = last.end;
        chng.addEdit(new SetEndPos(first, origEnd, first.end));
        lineMap.replace(index + 1, removed.size(), new Element[0]);
        Element[] removedArr = new Element[removed.size()];
        removed.toArray(removedArr);
        AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit(lineMap, index + 1, removedArr, new Element[0]);
        chng.addEdit(ee);
        super.removeUpdate(chng);
    }

    public class LeafElement
    extends AbstractDocument.AbstractElement {
        Position start;
        Position end;

        public LeafElement(Element parent, AttributeSet attrs, int startOffs, int endOffs) {
            super(PersistentMarkDocument.this, parent, attrs);
            try {
                this.start = PersistentMarkDocument.this.createPosition(startOffs);
                this.end = PersistentMarkDocument.this.createPosition(endOffs);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException(ble);
            }
        }

        @Override
        public int getStartOffset() {
            return this.start.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void setStartOffset(int offset) {
            try {
                this.start = PersistentMarkDocument.this.createPosition(offset);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException();
            }
        }

        public void setEndOffset(int offset) {
            try {
                this.end = PersistentMarkDocument.this.createPosition(offset);
            }
            catch (BadLocationException ble) {
                throw new RuntimeException();
            }
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            return null;
        }

        @Override
        public int getElementIndex(int offset) {
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return new Vector().elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }

    private class SetEndPos
    extends AbstractUndoableEdit {
        private LeafElement element;
        private Position oldEnd;
        private Position newEnd;

        public SetEndPos(LeafElement el, Position oldEnd, Position newEnd) {
            this.element = el;
            this.oldEnd = oldEnd;
            this.newEnd = newEnd;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.element.end = this.oldEnd;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.element.end = this.newEnd;
        }
    }

    private class SetStartPos
    extends AbstractUndoableEdit {
        private LeafElement element;
        private Position oldStart;
        private Position newStart;

        public SetStartPos(LeafElement el, Position oldStart, Position newStart) {
            this.element = el;
            this.oldStart = oldStart;
            this.newStart = newStart;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.element.start = this.oldStart;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.element.start = this.newStart;
        }
    }
}

