/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr;

import bluej.Config;
import bluej.debugger.DebuggerTestResult;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class MyCellRenderer
extends JLabel
implements ListCellRenderer {
    static final Icon errorIcon = Config.getFixedImageAsIcon("error.gif");
    static final Icon failureIcon = Config.getFixedImageAsIcon("failure.gif");
    static final Icon okIcon = Config.getFixedImageAsIcon("ok.gif");

    MyCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof DebuggerTestResult) {
            DebuggerTestResult dtr = (DebuggerTestResult)value;
            this.setText(dtr.getName() + " (" + dtr.getRunTimeMs() + "ms)");
            this.setIcon(dtr.isSuccess() ? okIcon : (dtr.isFailure() ? failureIcon : errorIcon));
        } else {
            this.setText(value.toString());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setOpaque(true);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setOpaque(false);
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        return this;
    }
}

