/*
 * Decompiled with CFR 0.152.
 */
package de.mbenning.weather.wunderground.api.domain;

import de.mbenning.weather.wunderground.api.domain.AbstractDataExport;
import de.mbenning.weather.wunderground.api.domain.DataSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDataExport
extends AbstractDataExport {
    private String[] header = new String[]{"Datum", "Min", "Max"};

    @Override
    public void process(List<DataSet> dataSets) throws IOException {
        if (this.fileOutputPath != null && dataSets != null) {
            FileWriter fw = new FileWriter(new File(this.fileOutputPath + "/" + this.filename));
            for (String h : this.header) {
                fw.write(h + ";");
            }
            fw.write("\n");
            for (DataSet dataSet : dataSets) {
                if (dataSet == null) continue;
                fw.write(this.sdf.format(dataSet.getDateTime()) + ";");
                fw.write(this.df.format(dataSet.getTemperatureLow()) + ";");
                fw.write(this.df.format(dataSet.getTemperatureHigh()) + ";");
                fw.write("\n");
            }
            fw.flush();
            fw.close();
        }
    }
}

