/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.JCValidateInterface;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.cell.validate.ValidateSupport;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.FocusManager;
import javax.swing.JTextField;

public class BaseCellEditor
extends JTextField
implements JCCellEditor,
JCValidateInterface,
KeyListener,
MouseListener {
    protected Object data;
    protected int caretPosition;
    protected AWTEvent initialEvent;
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected boolean selectAll = false;
    protected JCKeyModifier[] reservedKeys = null;
    protected ValidateSupport validate_support = new ValidateSupport();

    public BaseCellEditor() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setDoubleBuffered(true);
        if (this.reservedKeys == null) {
            this.reservedKeys = new JCKeyModifier[4];
            this.reservedKeys[0] = new JCKeyModifier(37);
            this.reservedKeys[1] = new JCKeyModifier(39);
            this.reservedKeys[2] = new JCKeyModifier(36);
            this.reservedKeys[3] = new JCKeyModifier(35);
        }
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void addValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.addValidateListener(jCValidateListener);
    }

    public void cancelCellEditing() {
        this.initData();
        this.caretPosition = this.data == null ? 0 : this.data.toString().length();
    }

    protected boolean fireValidated(JCValidateEvent jCValidateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(jCValidateEvent);
        if (bl) {
            this.setVisible(true);
        }
        return bl;
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        return this.getPreferredSize();
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.reservedKeys;
    }

    void initData() {
        this.setText(this.data == null ? "" : this.data.toString());
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        this.initialEvent = aWTEvent;
        this.data = object;
        this.selectAll = jCCellInfo.getSelectAll();
        this.setEditable(jCCellInfo.isEditable());
        if (!this.isEditable()) {
            this.selectAll = false;
        }
        this.caretPosition = aWTEvent instanceof KeyEvent && this.data != null ? this.data.toString().length() : -1;
        this.initData();
        this.selectAllText();
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        if (jCCellInfo.isEditable() && jCCellInfo.getBackground() != null) {
            this.setBackground(jCCellInfo.getBackground().brighter());
        }
        this.setSelectedTextColor(SystemColor.textHighlightText);
        this.setSelectionColor(SystemColor.textHighlight);
        this.setFont(jCCellInfo.getFont());
    }

    public boolean isModified() {
        Object object = this.getCellEditorValue();
        if (this.data == null || this.data.equals("")) {
            return object != null && !object.equals("");
        }
        return this.data.equals(object) ^ true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: {
                this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isVisible()) {
            FocusManager focusManager = FocusManager.getCurrentManager();
            FocusManager.disableSwingFocusManager();
            super.processKeyEvent(keyEvent);
            FocusManager.setCurrentManager(focusManager);
        }
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public void removeValidateListener(JCValidateListener jCValidateListener) {
        this.validate_support.removeValidateListener(jCValidateListener);
    }

    public void selectAllText() {
        if (this.selectAll && this.isDisplayable()) {
            try {
                this.setCaretPosition(0);
                this.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            }
            catch (Exception exception) {}
            this.selectAll();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            return;
        }
        if (this.caretPosition == -1) {
            String string = this.getText();
            if (this.getFont() == null) {
                return;
            }
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n = 5;
            int n2 = 0;
            while (n2 < string.length()) {
                if (this.initialEvent != null && this.initialEvent instanceof MouseEvent && (n += fontMetrics.charWidth(string.charAt(n2))) > ((MouseEvent)this.initialEvent).getX()) break;
                ++n2;
            }
            this.select(n2, n2);
        } else {
            this.caretPosition = Math.min(this.caretPosition, this.getText().length());
            this.select(this.caretPosition, this.caretPosition);
        }
        this.selectAllText();
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        JCValidateEvent jCValidateEvent = new JCValidateEvent(this, this.data, string, true);
        return this.fireValidated(jCValidateEvent);
    }
}

