/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaChartDraw;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDrawUtil;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCDataIndex;
import java.awt.Graphics;
import java.awt.Point;

public class SAreaChartDraw
extends AreaChartDraw {
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    double[][] ywork;
    JCAreaChartFormat areaFormat;
    boolean editInverted = false;

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        super.draw(graphics, n, n2, false);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        int n3 = this.yaxis.toPixel(jCDataIndex.series.getY(jCDataIndex.point), this.drawFront);
        int n4 = this.yaxis.toPixel(this.ywork[jCDataIndex.series.getDrawingOrder()][jCDataIndex.point - this.firstLast.x], this.drawFront);
        int n5 = this.editInverted ? n - this.r.x - n4 : n4 - (n2 - this.r.y);
        int n6 = this.editInverted ? n3 + n5 : n3 - n5;
        return n6;
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        return this.ywork[chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries)];
    }

    public JCDataIndex pick(Point point, int n) {
        return this.pick(point, n, true);
    }

    public void recalc(int n, int n2, int n3) {
        this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.yaxis = this.dataObject.getYAxis();
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        int n4 = this.seriesList.size();
        if (n4 == 0 || this.firstLast == null) {
            return;
        }
        int n5 = this.firstLast.y - this.firstLast.x + 1;
        this.ytotal = new double[n5];
        this.ysum = new double[n5];
        this.ysum_neg = new double[n5];
        this.ywork = new double[n4][n5];
        ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.areaFormat.is100Percent(), this.holeValue, this.yaxis.dataLimits, this.yaxis);
        super.recalc(n, n2, n3);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.editInverted = jCDataIndex.dataView.getXAxis().vertical;
        super.startEdit(jCDataIndex);
    }
}

