/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.beans.ColorEditorPanel;
import com.klg.jclass.chart.beans.AxisGridWrapper;
import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.MultiChart;
import com.klg.jclass.chart.beans.RadioEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisGridEditor
extends RadioEditor
implements ItemListener,
ActionListener,
FocusListener,
PropertyChangeListener {
    protected JCheckBox showing_cb;
    protected JTextField spacing_tf;
    protected JTextField width_tf;
    protected ColorEditorPanel colorEditor;
    AxisGridWrapper wrap = null;

    public AxisGridEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.showing_cb) {
                this.wrap.showing[this.radioSel] = this.showing_cb.isSelected();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.spacing_tf) {
                this.setDoubleIsDefProperty(this.spacing_tf.getText(), this.wrap.spacing, this.wrap.spacing_isdef, this.radioSel);
                this.switchValues(this.radioSel);
            } else if (object == this.width_tf) {
                this.setIntProperty(this.width_tf.getText(), this.wrap.width, this.radioSel, this.wrap.width_def);
                this.switchValues(this.radioSel);
            } else if (object == this.colorEditor) {
                this.wrap.color[this.radioSel] = (Color)this.colorEditor.getValue();
                this.support.firePropertyChange("", null, null);
            }
        }
        catch (Exception exception) {}
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.AxisGridWrapper(" + this.wrap + ")";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 500);
        dimension.height += 200;
        return dimension;
    }

    public Object getValue() {
        return this.wrap;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof JComboBox && itemEvent.getStateChange() == 2) {
            return;
        }
        this.checkProperties(object);
    }

    protected JPanel makePropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key205")));
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key198")));
        jPanel2.setLayout(new FlowLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.colorEditor = new ColorEditorPanel();
        this.setEnumArrays();
        JLabel jLabel = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key206"));
        JLabel jLabel2 = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key190"));
        this.width_tf = new JTextField(5);
        this.showing_cb = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key191"));
        JLabel jLabel3 = new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key208"));
        this.spacing_tf = new JTextField(5);
        jPanel2.add(jLabel);
        jPanel2.add(this.colorEditor);
        jPanel2.add(jLabel2);
        jPanel2.add(this.width_tf);
        jPanel3.add((Component)this.showing_cb, gridBagConstraints);
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        jPanel3.add((Component)this.spacing_tf, gridBagConstraints);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        this.add("Center", jPanel);
        this.showing_cb.addItemListener(this);
        this.spacing_tf.addActionListener(this);
        this.spacing_tf.addFocusListener(this);
        this.width_tf.addActionListener(this);
        this.width_tf.addFocusListener(this);
        this.colorEditor.addPropertyChangeListener(this);
        return jPanel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        this.checkProperties(object);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 5) {
            throw new IllegalArgumentException();
        }
        AxisGridWrapper axisGridWrapper = null;
        try {
            axisGridWrapper = new AxisGridWrapper((String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2), (String)vector.elementAt(3), (String)vector.elementAt(4));
            this.setValue(axisGridWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    protected void setEnumArrays() {
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (AxisGridWrapper)object;
            }
            catch (ClassCastException classCastException) {}
        }
        if (this.wrap == null) {
            this.wrap = new AxisGridWrapper(this.numOfRadios);
        }
        this.switchValues(this.radioSel);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        if (this.showing_cb.isSelected() != this.wrap.showing[n]) {
            this.showing_cb.setSelected(this.wrap.showing[n]);
        }
        if (this.wrap.spacing[n] != Double.MAX_VALUE) {
            this.spacing_tf.setText(String.valueOf(this.wrap.spacing[n]));
        } else {
            this.spacing_tf.setText("");
        }
        this.width_tf.setText(String.valueOf(this.wrap.width[n]));
        this.colorEditor.setValue(this.wrap.color[n]);
    }
}

