/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class List
extends JScrollPane {
    int SINGLE_SELECTION = 0;
    int MULTIPLE_INTERVAL_SELECTION = 2;
    transient ItemListener itemListener;
    transient ActionListener actionListener;
    private JList list;
    private DefaultListModel listModel = new DefaultListModel();

    public List() {
        this.list = new JList(this.listModel);
        this.setViewportView(this.list);
        this.setMultipleMode(false);
    }

    public List(int rows) {
        this();
        this.listModel.setSize(rows);
    }

    public List(int rows, boolean bMultipleMode) {
        this(rows);
        this.setMultipleMode(bMultipleMode);
    }

    public void add(String item) {
        this.listModel.addElement(item);
    }

    public void add(String item, int index) {
        this.listModel.insertElementAt(item, index);
    }

    public void addItem(String item) {
        this.add(item);
    }

    public void addItem(String item, int index) {
        this.addItem(item, index);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public boolean allowsMultipleSelections() {
        return this.isMultipleMode();
    }

    public void clear() {
        this.removeAll();
    }

    public int countItems() {
        return this.getItemCount();
    }

    public void delItem(int position) {
        this.remove(position);
    }

    public void delItem(int start, int end) {
        for (int i = end; i >= start; --i) {
            this.listModel.remove(i);
        }
    }

    public void deselect(int index) {
        this.list.removeSelectionInterval(index, index);
    }

    public AccessibleContext getAccessibleContext() {
        return this.list.getAccessibleContext();
    }

    public String getItem(int index) {
        return (String)this.listModel.getElementAt(index);
    }

    public int getItemCount() {
        return this.listModel.size();
    }

    public String[] getItems() {
        Object[] listItems = new String[this.listModel.size()];
        this.listModel.copyInto(listItems);
        return listItems;
    }

    public EventListener[] getListeners(Class listenerType) {
        return null;
    }

    public Dimension getMinimumSize() {
        return this.list.getMinimumSize();
    }

    public Dimension getMinimumSize(int rows) {
        return this.list.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.list.getPreferredSize();
    }

    public Dimension getPreferredSize(int rows) {
        return this.list.getPreferredSize();
    }

    public int getRows() {
        return this.list.getVisibleRowCount();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndexes() {
        return this.list.getSelectedIndices();
    }

    public String getSelectedItem() {
        return (String)this.list.getSelectedValue();
    }

    public String[] getSelectedItems() {
        return (String[])this.getSelectedObjects();
    }

    public Object[] getSelectedObjects() {
        return this.list.getSelectedValues();
    }

    public int getVisibleIndex() {
        return this.list.getLastVisibleIndex();
    }

    public boolean isIndexSelected(int index) {
        return this.list.isSelectedIndex(index);
    }

    public boolean isMultipleMode() {
        return this.list.getSelectionMode() != this.SINGLE_SELECTION;
    }

    public boolean isSelected(int index) {
        return this.isIndexSelected(index);
    }

    public void makeVisible(int index) {
        this.list.ensureIndexIsVisible(index);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int rows) {
        return this.getMinimumSize(rows);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize(int rows) {
        return this.getPreferredSize(rows);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void remove(int position) {
        this.list.remove(position);
    }

    public void remove(String item) {
        this.listModel.removeElement(item);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void removeAll() {
        this.list.removeAll();
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void replaceItem(String newValue, int index) {
        this.listModel.setElementAt(newValue, index);
    }

    public void select(int index) {
        this.list.setSelectedIndex(index);
    }

    public void setMultipleMode(boolean bMultipleMode) {
        this.list.setSelectionMode(bMultipleMode ? this.MULTIPLE_INTERVAL_SELECTION : this.SINGLE_SELECTION);
    }

    public void setMultipleSelections(boolean b) {
        this.setMultipleMode(b);
    }
}

