/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Res;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class ScrollPane
extends JScrollPane {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int scrollPolicy = 2;

    public ScrollPane() {
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public ScrollPane(int scrollbarDisplayPolicy) {
        this();
        this.scrollPolicy = scrollbarDisplayPolicy;
        this.setHorizontalScrollBarPolicy(this.convertPolicyAwtToSwing(scrollbarDisplayPolicy, "HORIZONTAL_SCROLLBAR"));
        this.setVerticalScrollBarPolicy(this.convertPolicyAwtToSwing(scrollbarDisplayPolicy, "VERTICAL_SCROLLBAR"));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (index > 0) {
                throw new IllegalArgumentException(Res.getString(39));
            }
            super.addImpl(comp, constraints, index);
        }
    }

    public Adjustable getHAdjustable() {
        return this.getHorizontalScrollBar();
    }

    public int getHScrollbarHeight() {
        int height = 0;
        if (this.getHorizontalScrollBarPolicy() != 31) {
            height = this.getHorizontalScrollBar().getSize().height;
        }
        return height;
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollPolicy;
    }

    public Point getScrollPosition() {
        return this.getViewport().getViewPosition();
    }

    public Adjustable getVAdjustable() {
        return this.getVerticalScrollBar();
    }

    public Dimension getViewportSize() {
        return this.getViewport().getSize();
    }

    public int getVScrollbarWidth() {
        int width = 0;
        if (this.getVerticalScrollBarPolicy() != 21) {
            width = this.getVerticalScrollBar().getSize().width;
        }
        return width;
    }

    public void printComponents(Graphics g) {
    }

    public void setScrollPosition(int x, int y) {
        this.getViewport().setViewPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        this.getViewport().setViewPosition(p);
    }

    private int convertPolicyAwtToSwing(int awtPolicy, String orientation) throws IllegalArgumentException {
        if (awtPolicy > 2 || awtPolicy < 0) {
            throw new IllegalArgumentException();
        }
        int swingPolicy = 0;
        String oIntern = orientation.intern();
        swingPolicy = oIntern == "HORIZONTAL_SCROLLBAR".intern() ? (awtPolicy == 2 ? 31 : (awtPolicy == 1 ? 32 : 30)) : (awtPolicy == 2 ? 21 : (awtPolicy == 1 ? 22 : 20));
        return swingPolicy;
    }

    static {
        SCROLLBARS_AS_NEEDED = 0;
        SCROLLBARS_ALWAYS = 1;
        SCROLLBARS_NEVER = 2;
    }
}

