/*
 * Decompiled with CFR 0.152.
 */
package netscape.javascript;

import ice.pilots.applet.ThePilot;
import ice.scripters.js.TheScripter;
import ice.storm.PilotContext;
import ice.storm.Viewport;
import java.applet.Applet;
import netscape.javascript.JSException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JSObject {
    Scriptable object;

    private Object wrapResult(Object object) {
        if (object instanceof Scriptable) {
            Object real;
            boolean converted = false;
            if (object instanceof NativeJavaObject && (real = ((NativeJavaObject)object).unwrap()) instanceof Applet) {
                object = real;
                converted = true;
            }
            if (!converted) {
                object = new JSObject((Scriptable)object);
            }
        }
        return object;
    }

    private Scriptable getBase(int index) {
        Scriptable cursor;
        for (cursor = this.object; cursor != null && !cursor.has(index, this.object); cursor = cursor.getPrototype()) {
        }
        return cursor;
    }

    private Scriptable getBase(String name) {
        Scriptable cursor;
        for (cursor = this.object; cursor != null && !cursor.has(name, this.object); cursor = cursor.getPrototype()) {
        }
        return cursor;
    }

    protected void finalize() {
    }

    public String toString() {
        return this.object.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(String source) {
        Object object;
        Context context = Context.enter();
        try {
            try {
                Object result = context.evaluateString(this.object, source, "JSObject", 0, null);
                object = this.wrapResult(result);
                Object var6_6 = null;
            }
            catch (JavaScriptException ex) {
                throw new JSException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String methodName, Object[] args) {
        Object object;
        Context context = Context.enter();
        try {
            Object value;
            if (args != null) {
                boolean copied = false;
                int i2 = args.length;
                while (i2-- != 0) {
                    Object arg = args[i2];
                    if (!(arg instanceof JSObject)) continue;
                    if (!copied) {
                        args = (Object[])args.clone();
                        copied = true;
                    }
                    args[i2] = ((JSObject)arg).object;
                }
            }
            if (!((value = this.getMember(methodName)) instanceof Function)) throw new JSException(new NotAFunctionException(String.valueOf(new StringBuffer("'").append(methodName).append("' not found or not a function"))));
            Function f2 = (Function)value;
            try {
                Object result = ScriptRuntime.call(context, f2, this.object, args, f2);
                object = this.wrapResult(result);
                Object var9_11 = null;
            }
            catch (JavaScriptException ex) {
                throw new JSException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public void removeMember(String name) {
        Context context = Context.enter();
        try {
            Scriptable base = this.getBase(name);
            if (base != null) {
                base.delete(name);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public void setSlot(int index, Object value) {
        Context context = Context.enter();
        try {
            Scriptable base;
            if (value instanceof JSObject) {
                value = ((JSObject)value).object;
            }
            if ((base = this.getBase(index)) == null) {
                base = this.object;
            }
            base.put(index, this.object, value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public void setMember(String name, Object value) {
        Context context = Context.enter();
        try {
            Scriptable base;
            if (value instanceof JSObject) {
                value = ((JSObject)value).object;
            }
            if ((base = this.getBase(name)) == null) {
                base = this.object;
            }
            base.put(name, this.object, value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getSlot(int index) {
        Object object;
        block3: {
            Object var5_5;
            Context context = Context.enter();
            try {
                Scriptable cursor = this.object;
                do {
                    Object result;
                    if ((result = cursor.get(index, this.object)) == Scriptable.NOT_FOUND) continue;
                    object = this.wrapResult(result);
                    break block3;
                } while ((cursor = cursor.getPrototype()) != null);
                var5_5 = null;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return var5_5;
        }
        Object var7_8 = null;
        Context.exit();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getMember(String name) {
        Object object;
        block3: {
            Object var5_5;
            Context context = Context.enter();
            try {
                Scriptable cursor = this.object;
                do {
                    Object result;
                    if ((result = cursor.get(name, this.object)) == Scriptable.NOT_FOUND) continue;
                    object = this.wrapResult(result);
                    break block3;
                } while ((cursor = cursor.getPrototype()) != null);
                var5_5 = null;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return var5_5;
        }
        Object var7_8 = null;
        Context.exit();
        return object;
    }

    public JSObject(Scriptable object) {
        this.object = object;
    }

    public static JSObject getWindow(Applet applet) {
        Viewport view;
        TheScripter ecma;
        PilotContext pc;
        ThePilot pilot = ThePilot.getAppletPilot(applet);
        if (pilot != null && (pc = pilot.getPilotContext()) != null && (ecma = (TheScripter)pc.getScripter("ECMAScript")) != null && (view = pilot.getPilotViewport()) != null) {
            Scriptable wrapper = ecma.getViewportWrapper(view);
            return new JSObject(wrapper);
        }
        return null;
    }
}

