/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FlattenedObject {
    private Scriptable a;

    private static Scriptable a(Scriptable scriptable, int n2) {
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
            if (!scriptable2.has(n2, scriptable)) continue;
            return scriptable2;
        }
        return null;
    }

    private static Scriptable a(Scriptable scriptable, String string) {
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
            if (!scriptable2.has(string, scriptable)) continue;
            return scriptable2;
        }
        return null;
    }

    public Object callMethod(Object object, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        if (!this.hasProperty(object)) {
            throw new PropertyException(Context.a("msg.prop.not.found", null));
        }
        Object object2 = this.getProperty(object);
        if (object2 instanceof FlattenedObject) {
            return ((FlattenedObject)object2).call(Context.b(), this.a, objectArray);
        }
        throw new NotAFunctionException();
    }

    public Scriptable construct(Context context, Object[] objectArray) throws NotAFunctionException, JavaScriptException {
        if (!(this.a instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.newObject(context, (Object)this.a, objectArray, null);
    }

    public Object call(Context context, Scriptable scriptable, Object[] objectArray) throws NotAFunctionException, JavaScriptException {
        if (!(this.a instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.call(context, this.a, scriptable, objectArray, (Function)this.a);
    }

    public Object[] getIds() {
        Object object;
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>(11);
        for (Scriptable scriptable = this.a; scriptable != null; scriptable = scriptable.getPrototype()) {
            object = scriptable.getIds();
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                hashtable.put(object[i2], Boolean.TRUE);
            }
        }
        object = hashtable.keys();
        Object[] objectArray = new Object[hashtable.size()];
        int n2 = 0;
        while (object.hasMoreElements()) {
            Object e2 = object.nextElement();
            objectArray[n2++] = e2;
        }
        return objectArray;
    }

    public boolean deleteProperty(Object object) {
        String string = ScriptRuntime.b(object);
        if (string == null) {
            int n2 = ScriptRuntime.a(object);
            Scriptable scriptable = FlattenedObject.a(this.a, n2);
            if (scriptable == null) {
                return true;
            }
            scriptable.delete(n2);
            return !scriptable.has(n2, scriptable);
        }
        Scriptable scriptable = FlattenedObject.a(this.a, string);
        if (scriptable == null) {
            return true;
        }
        scriptable.delete(string);
        return !scriptable.has(string, scriptable);
    }

    public void putProperty(Object object, Object object2) {
        String string = ScriptRuntime.b(object);
        if (object2 instanceof FlattenedObject) {
            object2 = ((FlattenedObject)object2).getObject();
        }
        if (string == null) {
            int n2 = ScriptRuntime.a(object);
            Scriptable scriptable = FlattenedObject.a(this.a, n2);
            if (scriptable == null) {
                scriptable = this.a;
            }
            scriptable.put(n2, this.a, object2);
            return;
        }
        Scriptable scriptable = FlattenedObject.a(this.a, string);
        if (scriptable == null) {
            scriptable = this.a;
        }
        scriptable.put(string, this.a, object2);
    }

    public Object getProperty(Object object) {
        Object object2;
        block2: {
            String string = ScriptRuntime.b(object);
            int n2 = string == null ? ScriptRuntime.a(object) : 0;
            Scriptable scriptable = this.a;
            do {
                Object object3 = object2 = string == null ? scriptable.get(n2, this.a) : scriptable.get(string, this.a);
                if (object2 != Scriptable.NOT_FOUND) break block2;
            } while ((scriptable = scriptable.getPrototype()) != null);
            return Undefined.instance;
        }
        if (object2 instanceof Scriptable) {
            return new FlattenedObject((Scriptable)object2);
        }
        return object2;
    }

    public boolean hasProperty(Object object) {
        String string = ScriptRuntime.toString(object);
        String string2 = ScriptRuntime.b((Object)string);
        if (string2 == null) {
            return FlattenedObject.a(this.a, ScriptRuntime.a((Object)string)) != null;
        }
        return FlattenedObject.a(this.a, string2) != null;
    }

    public Scriptable getObject() {
        return this.a;
    }

    public FlattenedObject(Scriptable scriptable) {
        this.a = scriptable;
    }
}

