/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import com.fourthpass.runtimehelp.a;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FlattenedObject;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.k;
import org.mozilla.javascript.n;

public class ScriptRuntime {
    static Class l;
    static Class i;
    static Class o;
    static Class b;
    static Class j;
    static Class k;
    static Class c;
    static Class r;
    static Class m;
    static Class f;
    static Class e;
    static Class q;
    static Class g;
    static Class n;
    static Class d;
    static Class a;
    static Class h;
    static Class p;
    public static Object[] emptyArgs;
    private static final int v = 10;
    private static final boolean u = true;
    public static double negativeZero;
    public static Double NaNobj;
    public static double NaN;
    public static final Class ClassClass;
    public static final Class FunctionClass;
    public static final Class ObjectClass;
    public static final Class CharacterClass;
    public static final Class DoubleClass;
    public static final Class FloatClass;
    public static final Class LongClass;
    public static final Class IntegerClass;
    public static final Class ShortClass;
    public static final Class ByteClass;
    public static final Class BooleanClass;
    public static final Class NumberClass;
    public static final Class StringClass;
    public static final Class ScriptableClass;
    public static final Class UndefinedClass;

    static {
        UndefinedClass = a == null ? (a = ScriptRuntime.a("org.mozilla.javascript.Undefined")) : a;
        ScriptableClass = b == null ? (b = ScriptRuntime.a("org.mozilla.javascript.Scriptable")) : b;
        StringClass = g == null ? (g = ScriptRuntime.a("java.lang.String")) : g;
        NumberClass = j == null ? (j = ScriptRuntime.a("java.lang.Number")) : j;
        BooleanClass = r == null ? (r = ScriptRuntime.a("java.lang.Boolean")) : r;
        ByteClass = q == null ? (q = ScriptRuntime.a("java.lang.Byte")) : q;
        ShortClass = h == null ? (h = ScriptRuntime.a("java.lang.Short")) : h;
        IntegerClass = l == null ? (l = ScriptRuntime.a("java.lang.Integer")) : l;
        LongClass = k == null ? (k = ScriptRuntime.a("java.lang.Long")) : k;
        FloatClass = m == null ? (m = ScriptRuntime.a("java.lang.Float")) : m;
        DoubleClass = n == null ? (n = ScriptRuntime.a("java.lang.Double")) : n;
        CharacterClass = p == null ? (p = ScriptRuntime.a("java.lang.Character")) : p;
        ObjectClass = i == null ? (i = ScriptRuntime.a("java.lang.Object")) : i;
        FunctionClass = f == null ? (f = ScriptRuntime.a("org.mozilla.javascript.Function")) : f;
        ClassClass = o == null ? (o = ScriptRuntime.a("java.lang.Class")) : o;
        NaN = Double.NaN;
        NaNobj = new Double(Double.NaN);
        negativeZero = -0.0;
        emptyArgs = new Object[0];
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static RuntimeException a(String string, Object object) {
        Object[] objectArray = new Object[]{object.getClass().getName()};
        return Context.reportRuntimeError(ScriptRuntime.getMessage(string, objectArray));
    }

    private static boolean a(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(string, scriptable)) continue;
            return true;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return false;
    }

    public static void setCurrentActivation(Context context, NativeCall nativeCall) {
        context.fb = nativeCall;
    }

    public static NativeCall getCurrentActivation(Context context) {
        return context.fb;
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.c();
    }

    public static String getMessage(String string, Object[] objectArray) {
        return Context.a(string, objectArray);
    }

    static void a(Context context, String string) {
        int n2 = context.getLanguageVersion();
        if (n2 >= 140 || n2 == 0) {
            Object[] objectArray = new Object[]{string};
            String string2 = ScriptRuntime.getMessage("msg.deprec.ctor", objectArray);
            if (n2 == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    public static NativeFunction createFunctionObject(Scriptable scriptable, Class clazz, Context context) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        NativeFunction nativeFunction = null;
        Object[] objectArray = new Object[]{scriptable, context};
        try {
            nativeFunction = (NativeFunction)constructorArray[0].newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WrappedException.wrapException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        nativeFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeFunction.setParentScope(scriptable);
        return nativeFunction;
    }

    public static NativeFunction initFunction(NativeFunction nativeFunction, Scriptable scriptable, String string, Context context) {
        nativeFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeFunction.setParentScope(scriptable);
        if (string != null && string.length() != 0) {
            ScriptRuntime.setName(scriptable, nativeFunction, scriptable, string);
        }
        return nativeFunction;
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        return scriptable.getParentScope();
    }

    public static Scriptable enterWith(Object object, Scriptable scriptable) {
        return new NativeWith(scriptable, ScriptRuntime.toObject(scriptable, object));
    }

    public static Scriptable newScope() {
        return new NativeObject();
    }

    public static void popActivation(Context context) {
        NativeCall nativeCall = context.fb;
        if (nativeCall != null) {
            context.fb = nativeCall.d;
            nativeCall.d = null;
        }
    }

    public static Scriptable initVarObj(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        NativeCall nativeCall = new NativeCall(context, scriptable, nativeFunction, scriptable2, objectArray);
        String[] stringArray = nativeFunction.names;
        if (stringArray != null) {
            for (int i2 = nativeFunction.argCount + 1; i2 < nativeFunction.names.length; ++i2) {
                String string = nativeFunction.names[i2];
                nativeCall.put(string, (Scriptable)nativeCall, (Object)Undefined.instance);
            }
        }
        return nativeCall;
    }

    public static void setAdapterProto(Scriptable scriptable, Object object) {
        Scriptable scriptable2 = scriptable.getPrototype();
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable4 = Context.toObject(object, scriptable3);
        scriptable.setPrototype(scriptable4);
        scriptable4.setPrototype(scriptable2);
    }

    public static Scriptable runScript(Script script) {
        Context context = Context.enter();
        Scriptable scriptable = context.initStandardObjects(new ImporterTopLevel());
        try {
            script.exec(context, scriptable);
        }
        catch (JavaScriptException javaScriptException) {
            throw new Error(javaScriptException.toString());
        }
        Context.exit();
        return scriptable;
    }

    public static Scriptable initScript(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2) {
        String[] stringArray = nativeFunction.names;
        if (stringArray != null) {
            ScriptableObject scriptableObject;
            try {
                scriptableObject = (ScriptableObject)scriptable;
            }
            catch (ClassCastException classCastException) {
                scriptableObject = null;
            }
            for (int i2 = nativeFunction.names.length - 1; i2 > 0; --i2) {
                String string = nativeFunction.names[i2];
                if (ScriptRuntime.a(scriptable, string)) continue;
                if (scriptableObject != null) {
                    scriptableObject.defineProperty(string, Undefined.instance, 4);
                    continue;
                }
                scriptable.put(string, scriptable, (Object)Undefined.instance);
            }
        }
        if (context.getDebugLevel() > 0) {
            new NativeCall(context, scriptable, nativeFunction, scriptable2);
        }
        return scriptable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String string, String[] stringArray) throws JavaScriptException {
        Scriptable scriptable;
        Context context = Context.enter();
        Scriptable scriptable2 = context.initStandardObjects(null);
        try {
            scriptable = context.newObject(scriptable2, "Array");
        }
        catch (PropertyException propertyException) {
            throw WrappedException.wrapException(propertyException);
        }
        catch (NotAFunctionException notAFunctionException) {
            throw WrappedException.wrapException(notAFunctionException);
        }
        catch (JavaScriptException javaScriptException) {
            throw WrappedException.wrapException(javaScriptException);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            scriptable.put(i2, scriptable, (Object)stringArray[i2]);
        }
        scriptable2.put("arguments", scriptable2, (Object)scriptable);
        try {
            try {
                Class clazz = com.fourthpass.runtimehelp.a.a(string);
                Script script = (Script)clazz.newInstance();
                script.exec(context, scriptable2);
                Object var8_14 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Object var8_15 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
            catch (InstantiationException instantiationException) {
                Object var8_16 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
            catch (IllegalAccessException illegalAccessException) {
                Object var8_17 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public static int cmp_LE(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d2 = ScriptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d2 <= d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) <= 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LE(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d2 = ScriptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d2 < d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LTB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LT(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean in(Object object, Object object2) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.instanceof.not.object", null), object);
        }
        FlattenedObject flattenedObject = new FlattenedObject((Scriptable)object2);
        return flattenedObject.hasProperty(object);
    }

    protected static boolean a(Scriptable scriptable, Scriptable scriptable2) {
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            if (!scriptable3.equals(scriptable2)) continue;
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Scriptable scriptable, Object object, Object object2) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.instanceof.not.object", null), scriptable);
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    public static Boolean sneB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean seqB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean shallowEq(Object object, Object object2) {
        Class clazz = ScriptRuntime.c(object);
        if (clazz != ScriptRuntime.c(object2)) {
            return false;
        }
        if (clazz == StringClass || clazz == BooleanClass) {
            return object.equals(object2);
        }
        if (clazz == NumberClass) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (clazz == ScriptableClass) {
            if (object == object2) {
                return true;
            }
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
            return false;
        }
        return clazz == UndefinedClass;
    }

    public static Boolean neB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean eqB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean eq(Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        while (true) {
            Class clazz;
            Class clazz2;
            if ((clazz2 = ScriptRuntime.c(object)) == (clazz = ScriptRuntime.c(object2))) {
                if (clazz2 == UndefinedClass) {
                    return true;
                }
                if (clazz2 == NumberClass) {
                    return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
                }
                if (clazz2 == StringClass || clazz2 == BooleanClass) {
                    return object3.equals(object4);
                }
                if (clazz2 == ScriptableClass) {
                    if (object == object2) {
                        return true;
                    }
                    if (object instanceof Wrapper && object2 instanceof Wrapper) {
                        return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (object == null && object2 == Undefined.instance) {
                return true;
            }
            if (object == Undefined.instance && object2 == null) {
                return true;
            }
            if (clazz2 == NumberClass && clazz == StringClass) {
                return ((Number)object).doubleValue() == ScriptRuntime.toNumber(object2);
            }
            if (clazz2 == StringClass && clazz == NumberClass) {
                return ScriptRuntime.toNumber(object) == ((Number)object2).doubleValue();
            }
            if (clazz2 == BooleanClass) {
                object3 = object = new Double(ScriptRuntime.toNumber(object));
                continue;
            }
            if (clazz == BooleanClass) {
                object4 = object2 = new Double(ScriptRuntime.toNumber(object2));
                continue;
            }
            if ((clazz2 == StringClass || clazz2 == NumberClass) && clazz == ScriptableClass && object2 != null) {
                object4 = object2 = ScriptRuntime.toPrimitive(object2);
                continue;
            }
            if (clazz2 != ScriptableClass || object == null || clazz != StringClass && clazz != NumberClass) break;
            object3 = object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    private static Class c(Object object) {
        if (object == null) {
            return ScriptableClass;
        }
        if (object == Undefined.instance) {
            return UndefinedClass;
        }
        if (object instanceof Scriptable) {
            return ScriptableClass;
        }
        if (object instanceof Number) {
            return NumberClass;
        }
        return object.getClass();
    }

    public static Object toPrimitive(Object object) {
        if (object == null || !(object instanceof Scriptable)) {
            return object;
        }
        Object object2 = ((Scriptable)object).getDefaultValue(null);
        if (object2 != null && object2 instanceof Scriptable) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.bad.default.value", null), object);
        }
        return object2;
    }

    public static Object postDecrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() - 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) - 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postDecrement(Scriptable objectArray, String string) {
        Object object;
        for (Object object2 = objectArray; object2 != null; object2 = object2.getParentScope()) {
            object = object2;
            do {
                Object object3;
                if ((object3 = object.get(string, (Scriptable)object2)) == Scriptable.NOT_FOUND) continue;
                Object object4 = object3;
                if (object4 instanceof Number) {
                    object4 = new Double(((Number)object4).doubleValue() - 1.0);
                    object.put(string, (Scriptable)object2, object4);
                    return object3;
                }
                object4 = new Double(ScriptRuntime.toNumber(object4) - 1.0);
                object.put(string, (Scriptable)object2, object4);
                return new Double(ScriptRuntime.toNumber(object3));
            } while ((object = object.getPrototype()) != null);
        }
        object = new Object[]{string};
        throw NativeGlobal.constructError(Context.b(), "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", (Object[])object), objectArray);
    }

    public static Object postDecrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(object) - 1.0);
        return object;
    }

    public static Object postDecrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d2 = ScriptRuntime.toNumber(object3);
        Double d3 = new Double(d2 - 1.0);
        ScriptRuntime.setElem(object, object2, d3, scriptable);
        return new Double(d2);
    }

    public static Object postIncrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d2 = ScriptRuntime.toNumber(object3);
        Double d3 = new Double(d2 + 1.0);
        ScriptRuntime.setElem(object, object2, d3, scriptable);
        return new Double(d2);
    }

    public static Object postIncrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() + 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) + 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrement(Scriptable objectArray, String string) {
        Object object;
        for (Object object2 = objectArray; object2 != null; object2 = object2.getParentScope()) {
            object = object2;
            do {
                Object object3;
                if ((object3 = object.get(string, (Scriptable)object2)) == Scriptable.NOT_FOUND) continue;
                Object object4 = object3;
                if (object4 instanceof Number) {
                    object4 = new Double(((Number)object4).doubleValue() + 1.0);
                    object.put(string, (Scriptable)object2, object4);
                    return object3;
                }
                object4 = new Double(ScriptRuntime.toNumber(object4) + 1.0);
                object.put(string, (Scriptable)object2, object4);
                return new Double(ScriptRuntime.toNumber(object3));
            } while ((object = object.getPrototype()) != null);
        }
        object = new Object[]{string};
        throw NativeGlobal.constructError(Context.b(), "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", (Object[])object), objectArray);
    }

    public static Object postIncrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(object) + 1.0);
        return object;
    }

    public static Object add(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof String) && !(object2 instanceof String)) {
            if (object instanceof Number && object2 instanceof Number) {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(object) + ScriptRuntime.toNumber(object2));
        }
        return String.valueOf(ScriptRuntime.toString(object)).concat(String.valueOf(ScriptRuntime.toString(object2)));
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(scriptable2, string, scriptable));
    }

    public static String typeof(Object object) {
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object == null) {
            return "object";
        }
        if (object instanceof Scriptable) {
            return object instanceof Function ? "function" : "object";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.a("msg.invalid.type", object);
    }

    public static Scriptable newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        return (Scriptable)ScriptRuntime.a(context, scriptable, object, null, null, objectArray, false, null, -1);
    }

    public static Scriptable newObject(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        try {
            Function function = (Function)object;
            if (function != null) {
                Scriptable scriptable2 = function.construct(context, scriptable, objectArray);
                return scriptable2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Object[] objectArray2 = new Object[]{ScriptRuntime.toString(object)};
        throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.isnt.function", objectArray2), scriptable);
    }

    public static Object callSpecial(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, String string, int n2) throws JavaScriptException {
        return ScriptRuntime.a(context, scriptable2, object, object2, scriptable, objectArray, true, string, n2);
    }

    private static Object a(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray, boolean bl, String string, int n2) throws JavaScriptException {
        if (object instanceof FunctionObject) {
            FunctionObject functionObject = (FunctionObject)object;
            Method method = functionObject.c;
            Class<?> clazz = method.getDeclaringClass();
            String string2 = method.getName();
            if (string2.equals("eval") && clazz == (e == null ? (e = ScriptRuntime.a("org.mozilla.javascript.NativeGlobal")) : e)) {
                return NativeGlobal.evalSpecial(context, scriptable, object3, objectArray, string, n2);
            }
            if (string2.equals("With") && clazz == (c == null ? (c = ScriptRuntime.a("org.mozilla.javascript.NativeWith")) : c)) {
                return NativeWith.newWithSpecial(context, objectArray, functionObject, !bl);
            }
            if (string2.equals("jsFunction_exec") && clazz == (d == null ? (d = ScriptRuntime.a("org.mozilla.javascript.NativeScript")) : d)) {
                return ((NativeScript)object2).exec(context, ScriptableObject.getTopLevelScope(scriptable));
            }
            if (string2.equals("exec") && context.c() != null && context.c().isRegExp(object2)) {
                return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
            }
        } else if (object instanceof NativeJavaMethod) {
            return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
        }
        if (bl) {
            return ScriptRuntime.call(context, object, object3, objectArray, scriptable);
        }
        return ScriptRuntime.newObject(context, object, objectArray, scriptable);
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        Scriptable scriptable2;
        Function function;
        try {
            function = (Function)object;
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray2 = new Object[]{ScriptRuntime.toString(object)};
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.isnt.function", objectArray2), scriptable);
        }
        try {
            scriptable2 = (Scriptable)object2;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object2);
        }
        return function.call(context, function.getParentScope(), scriptable2, objectArray);
    }

    public static Object nextEnum(Enumeration enumeration) {
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return enumeration.nextElement();
    }

    public static Enumeration initEnum(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObject(scriptable, object);
        return new k(scriptable2);
    }

    public static Object setName(Scriptable scriptable, Object object, Scriptable scriptable2, String string) {
        if (scriptable == null) {
            Scriptable scriptable3 = scriptable2;
            while ((scriptable3 = (scriptable = scriptable3).getParentScope()) != null) {
            }
            scriptable.put(string, scriptable, object);
            Object[] objectArray = new String[]{string};
            String string2 = ScriptRuntime.getMessage("msg.assn.create", objectArray);
            Context.reportWarning(string2);
            return object;
        }
        return ScriptRuntime.setProp(scriptable, string, object, scriptable2);
    }

    public static Scriptable getThis(Scriptable scriptable) {
        while (scriptable instanceof NativeWith) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        return scriptable;
    }

    public static Scriptable getBase(Scriptable objectArray, String string) {
        Object[] objectArray2;
        for (Object object = objectArray; object != null; object = object.getParentScope()) {
            objectArray2 = object;
            do {
                if (objectArray2.get(string, (Scriptable)object) == Scriptable.NOT_FOUND) continue;
                return object;
            } while ((objectArray2 = objectArray2.getPrototype()) != null);
        }
        objectArray2 = new Object[]{string};
        throw NativeGlobal.constructError(Context.b(), "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", objectArray2), objectArray);
    }

    public static Scriptable bind(Scriptable scriptable, String string) {
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getParentScope()) {
            Scriptable scriptable3 = scriptable2;
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                return scriptable2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return null;
    }

    public static Object name(Scriptable objectArray, String string) {
        Object object;
        for (Object object2 = objectArray; object2 != null; object2 = object2.getParentScope()) {
            object = object2;
            do {
                Object object3;
                if ((object3 = object.get(string, (Scriptable)object2)) == Scriptable.NOT_FOUND) continue;
                return object3;
            } while ((object = object.getPrototype()) != null);
        }
        object = new Object[]{string.toString()};
        throw NativeGlobal.constructError(Context.b(), "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", object), objectArray);
    }

    public static Object delete(Object object, Object object2) {
        if (!(object instanceof Scriptable)) {
            return Boolean.TRUE;
        }
        FlattenedObject flattenedObject = new FlattenedObject((Scriptable)object);
        return flattenedObject.deleteProperty(object2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object setElem(Scriptable scriptable, int n2, Object object) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(n2, scriptable)) continue;
            scriptable2.put(n2, scriptable, object);
            return object;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        scriptable.put(n2, scriptable, object);
        return object;
    }

    public static Object setElem(Object object, Object object2, Object object3, Scriptable scriptable) {
        Scriptable scriptable2;
        String string;
        int n2;
        if (object2 instanceof Number) {
            double d2 = ((Number)object2).doubleValue();
            n2 = (int)d2;
            string = (double)n2 == d2 ? null : ScriptRuntime.toString(object2);
        } else {
            string = ScriptRuntime.toString(object2);
            long l2 = ScriptRuntime.b(string);
            if (l2 >= (long)0) {
                n2 = (int)l2;
                string = null;
            } else {
                n2 = 0;
            }
        }
        Scriptable scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (string != null) {
            if (string.equals("__proto__")) {
                return ScriptRuntime.setProto(object, object3, scriptable);
            }
            if (string.equals("__parent__")) {
                return ScriptRuntime.setParent(object, object3, scriptable);
            }
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                scriptable3.put(string, scriptable2, object3);
                return object3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(string, scriptable2, object3);
            return object3;
        }
        do {
            if (!scriptable3.has(n2, scriptable2)) continue;
            scriptable3.put(n2, scriptable2, object3);
            return object3;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        scriptable2.put(n2, scriptable2, object3);
        return object3;
    }

    public static Object getElem(Scriptable scriptable, int n2) {
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
            Object object = scriptable2.get(n2, scriptable);
            if (object == Scriptable.NOT_FOUND) continue;
            return object;
        }
        return Undefined.instance;
    }

    public static Object getElem(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        String string;
        int n2;
        if (object2 instanceof Number) {
            double d2 = ((Number)object2).doubleValue();
            n2 = (int)d2;
            string = (double)n2 == d2 ? null : ScriptRuntime.toString(object2);
        } else {
            string = ScriptRuntime.toString(object2);
            long l2 = ScriptRuntime.b(string);
            if (l2 >= (long)0) {
                n2 = (int)l2;
                string = null;
            } else {
                n2 = 0;
            }
        }
        if (string != null) {
            if (string.equals("__proto__")) {
                return scriptable3.getPrototype();
            }
            if (string.equals("__parent__")) {
                return scriptable3.getParentScope();
            }
            for (scriptable2 = scriptable3 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object); scriptable2 != null; scriptable2 = scriptable2.getPrototype()) {
                Object object3 = scriptable2.get(string, scriptable3);
                if (object3 == Scriptable.NOT_FOUND) continue;
                return object3;
            }
            return Undefined.instance;
        }
        while (scriptable2 != null) {
            Object object4 = scriptable2.get(n2, scriptable3);
            if (object4 != Scriptable.NOT_FOUND) {
                return object4;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return Undefined.instance;
    }

    static int a(Object object) {
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            int n2 = (int)d2;
            if ((double)n2 == d2) {
                return n2;
            }
            return 0;
        }
        String string = ScriptRuntime.toString(object);
        long l2 = ScriptRuntime.b(string);
        if (l2 >= (long)0) {
            return (int)l2;
        }
        return 0;
    }

    static String b(Object object) {
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            int n2 = (int)d2;
            if ((double)n2 == d2) {
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        String string = ScriptRuntime.toString(object);
        long l2 = ScriptRuntime.b(string);
        if (l2 >= (long)0) {
            return null;
        }
        return string;
    }

    private static long b(String string) {
        char c2;
        int n2 = string.length();
        if (n2 > 0 && n2 <= 10 && '0' <= (c2 = string.charAt(0)) && c2 <= '9') {
            int n3;
            int n4 = c2 - 48;
            int n5 = 0;
            if (n4 != 0) {
                for (n3 = 1; n3 < n2 && '0' <= (c2 = string.charAt(n3)) && c2 <= '9'; ++n3) {
                    n5 = n4;
                    n4 = 10 * n4 + (c2 - 48);
                }
            }
            if (n3 == n2 && (n5 < 0xCCCCCCC || n5 == 0xCCCCCCC && c2 < '\u0007')) {
                return 0xFFFFFFFFL & (long)n4;
            }
        }
        return -1L;
    }

    public static Object setProp(Object object, String string, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            if (!scriptable3.has(string, scriptable2)) continue;
            scriptable3.put(string, scriptable2, object2);
            return object2;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        scriptable2.put(string, scriptable2, object2);
        return object2;
    }

    public static Object setParent(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        try {
            scriptable3 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable3 = ScriptRuntime.toObject(scriptable, object);
        }
        for (Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2); scriptable4 != null; scriptable4 = scriptable4.getParentScope()) {
            if (scriptable4 != scriptable3) continue;
            Object[] objectArray = new Object[]{"__parent__"};
            throw Context.reportRuntimeError(ScriptRuntime.getMessage("msg.cyclic.value", objectArray));
        }
        if (scriptable3 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        scriptable3.setParentScope(scriptable2);
        return scriptable2;
    }

    public static Object setProto(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        try {
            scriptable3 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable3 = ScriptRuntime.toObject(scriptable, object);
        }
        for (Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2); scriptable4 != null; scriptable4 = scriptable4.getPrototype()) {
            if (scriptable4 != scriptable3) continue;
            Object[] objectArray = new Object[]{"__proto__"};
            throw Context.reportRuntimeError(ScriptRuntime.getMessage("msg.cyclic.value", objectArray));
        }
        if (scriptable3 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        scriptable3.setPrototype(scriptable2);
        return scriptable2;
    }

    public static Scriptable getParent(Object object, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        return scriptable2.getParentScope();
    }

    public static Scriptable getParent(Object object) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            Scriptable scriptable2 = null;
            return scriptable2;
        }
        if (scriptable == null) {
            return null;
        }
        return ScriptRuntime.getThis(scriptable.getParentScope());
    }

    public static Scriptable getProto(Object object, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        return scriptable2.getPrototype();
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        do {
            if ((object = scriptable2.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            return object;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return object;
    }

    public static Object getProp(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null || scriptable2 == Undefined.instance) {
            String string2 = scriptable2 == null ? "msg.null.to.object" : "msg.undefined";
            throw NativeGlobal.constructError(Context.b(), "ConversionError", ScriptRuntime.getMessage(string2, null), scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            return object2;
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object unwrapJavaScriptException(JavaScriptException javaScriptException) {
        return javaScriptException.a;
    }

    public static char toUint16(Object object) {
        long l2 = 65536L;
        double d2 = ScriptRuntime.toNumber(object);
        if (d2 != d2 || d2 == 0.0 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d2 = (d2 = Math.IEEEremainder(d2, l2)) >= 0.0 ? d2 : d2 + (double)l2;
        return (char)Math.floor(d2);
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static long toUint32(double d2) {
        double d3 = 4.294967296E9;
        if (d2 != d2 || d2 == 0.0 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d2 = d2 > 0.0 ? Math.floor(d2) : Math.ceil(d2);
        d2 = Math.IEEEremainder(d2, d3);
        d2 = d2 >= 0.0 ? d2 : d2 + d3;
        return (long)Math.floor(d2);
    }

    public static int toInt32(double d2) {
        double d3 = 4.294967296E9;
        double d4 = 2.147483648E9;
        if (d2 != d2 || d2 == 0.0 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d5 = d2 = (d2 = Math.IEEEremainder(d2, d3)) >= 0.0 ? d2 : d2 + d3;
        if (d2 >= d4) {
            return (int)(d2 - d3);
        }
        return (int)d2;
    }

    public static int toInt32(Object object) {
        double d2 = 4.294967296E9;
        double d3 = 2.147483648E9;
        if (object instanceof Byte) {
            return ((Number)object).intValue();
        }
        double d4 = ScriptRuntime.toNumber(object);
        if (d4 != d4 || d4 == 0.0 || d4 == Double.POSITIVE_INFINITY || d4 == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d5 = d4 = (d4 = Math.IEEEremainder(d4, d2)) >= 0.0 ? d4 : d4 + d2;
        if (d4 >= d3) {
            return (int)(d4 - d2);
        }
        return (int)d4;
    }

    public static double toInteger(double d2) {
        if (d2 != d2) {
            return 0.0;
        }
        if (d2 == 0.0 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return d2;
        }
        if (d2 > 0.0) {
            return Math.floor(d2);
        }
        return Math.ceil(d2);
    }

    public static double toInteger(Object object) {
        double d2 = ScriptRuntime.toNumber(object);
        if (d2 != d2) {
            return 0.0;
        }
        if (d2 == 0.0 || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return d2;
        }
        if (d2 > 0.0) {
            return Math.floor(d2);
        }
        return Math.ceil(d2);
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Exception exception = null;
        try {
            Scriptable scriptable2 = context.newObject(scriptable, string, objectArray);
            return scriptable2;
        }
        catch (NotAFunctionException notAFunctionException) {
            exception = notAFunctionException;
        }
        catch (PropertyException propertyException) {
            exception = propertyException;
        }
        catch (JavaScriptException javaScriptException) {
            exception = javaScriptException;
        }
        throw Context.reportRuntimeError(exception.getMessage());
    }

    public static Scriptable toObject(Scriptable scriptable, Object object, Class clazz) {
        String string;
        if (object == null) {
            throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.null.to.object", null), scriptable);
        }
        if (object instanceof Scriptable) {
            if (object == Undefined.instance) {
                throw NativeGlobal.constructError(Context.b(), "TypeError", ScriptRuntime.getMessage("msg.undef.to.object", null), scriptable);
            }
            return (Scriptable)object;
        }
        String string2 = object instanceof String ? "String" : (object instanceof Number ? "Number" : (string = object instanceof Boolean ? "Boolean" : null));
        if (string == null) {
            Object object2 = NativeJavaObject.wrap(scriptable, object, clazz);
            if (object2 instanceof Scriptable) {
                return (Scriptable)object2;
            }
            throw ScriptRuntime.a("msg.invalid.type", object);
        }
        Object[] objectArray = new Object[]{object};
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable2 = ScriptRuntime.newObject(Context.b(), scriptable, string, objectArray);
        return scriptable2;
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        return ScriptRuntime.toObject(scriptable, object, null);
    }

    public static String numberToString(double d2, int n2) {
        int n3;
        boolean bl;
        int n4;
        if (d2 != d2) {
            return "NaN";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d2 == 0.0) {
            return "0";
        }
        if (n2 < 2 || n2 > 36) {
            Object[] objectArray = new Object[]{Integer.toString(n2)};
            throw Context.reportRuntimeError(ScriptRuntime.getMessage("msg.bad.radix", objectArray));
        }
        if (n2 != 10) {
            if (d2 < 0.0) {
                return "-".concat(String.valueOf(Long.toString((long)(-d2) & 0xFFFFFFFFL, n2)));
            }
            return Long.toString((long)d2 & 0xFFFFFFFFL, n2);
        }
        String string = Double.toString(d2);
        char[] cArray = string.toCharArray();
        int n5 = -1;
        int n6 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        block5: for (n4 = 0; n4 < cArray.length; ++n4) {
            switch (cArray[n4]) {
                case '-': {
                    if (n6 == -1) {
                        bl2 = true;
                        continue block5;
                    }
                    bl3 = true;
                    continue block5;
                }
                case '.': {
                    n5 = n4;
                    continue block5;
                }
                case 'E': {
                    n6 = n4;
                    continue block5;
                }
            }
        }
        if (n6 == -1) {
            if (n5 == cArray.length - 2 && cArray[cArray.length - 1] == '0') {
                return new String(cArray, 0, cArray.length - 2);
            }
            return string;
        }
        n4 = Integer.parseInt(new String(cArray, n6 + 1, cArray.length - n6 - 1));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl4 = bl = n5 + 2 == n6 && cArray[n5 + 1] == '0';
        if (n4 < -6 || n4 > 20) {
            int n7;
            int n8 = n7 = bl ? 1 : n6;
            if (bl2) {
                stringBuffer.append('-');
                stringBuffer.append(cArray, 1, n7);
            } else {
                stringBuffer.append(cArray, 0, n7);
            }
            stringBuffer.append('e');
            stringBuffer.append(n4 < 0 ? (char)'-' : '+');
            int n9 = n6 + (n4 < 0 ? 2 : 1);
            stringBuffer.append(cArray, n9, cArray.length - n9);
            return stringBuffer.toString();
        }
        if (bl2) {
            stringBuffer.append('-');
        }
        if (n4 < 0) {
            stringBuffer.append("0.");
            for (n3 = n4 + 1; n3 < 0; ++n3) {
                stringBuffer.append('0');
            }
        }
        stringBuffer.append(cArray[n5 - 1]);
        n3 = 0;
        if (!bl) {
            n3 = n6 - n5 - 1;
            if (n4 > 0 && n4 < n3) {
                stringBuffer.append(cArray, n5 + 1, n4);
                stringBuffer.append('.');
                stringBuffer.append(cArray, n5 + n4 + 1, n3 - n4);
            } else {
                stringBuffer.append(cArray, n5 + 1, n3);
            }
        }
        if (n4 > 0) {
            for (int i2 = n3; i2 < n4; ++i2) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    public static String toString(Object object) {
        block3: {
            do {
                if (object == null) {
                    return "null";
                }
                if (!(object instanceof Scriptable)) break block3;
            } while ((object = ((Scriptable)object).getDefaultValue(StringClass)) == Undefined.instance || !(object instanceof Scriptable));
            throw ScriptRuntime.a("msg.primitive.expected", object);
        }
        if (object instanceof Number) {
            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
        }
        return object.toString();
    }

    public static String escapeString(String string) {
        String string2 = "\bb\ff\nn\rr\tt\u000bv\"\"''";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            String string3;
            char c2 = string.charAt(i2);
            if (c2 >= ' ' && c2 <= '~' && c2 != '\"') {
                stringBuffer.append(c2);
                continue;
            }
            int n2 = string2.indexOf(c2);
            if (n2 >= 0) {
                stringBuffer.append("\\");
                stringBuffer.append(string2.charAt(n2 + 1));
                continue;
            }
            if (c2 < '\u0100') {
                string3 = Integer.toHexString(c2);
                if (string3.length() == 1) {
                    stringBuffer.append("\\x0");
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append("\\x");
                stringBuffer.append(string3);
                continue;
            }
            string3 = Integer.toHexString(c2);
            stringBuffer.append("\\u");
            for (int i3 = string3.length(); i3 < 4; ++i3) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static Object[] padArguments(Object[] objectArray, int n2) {
        int n3;
        if (n2 < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n2];
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            objectArray2[n3] = objectArray[n3];
        }
        while (n3 < n2) {
            objectArray2[n3] = Undefined.instance;
            ++n3;
        }
        return objectArray2;
    }

    public static double toNumber(String string) {
        char c2;
        char c3;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return 0.0;
            }
            c3 = string.charAt(n3);
            if (!Character.isWhitespace(c3)) break;
            ++n3;
        }
        if (c3 == '0' && n3 + 2 < n2 && Character.toLowerCase(string.charAt(n3 + 1)) == 'x') {
            return ScriptRuntime.a(string, n3 + 2, 16);
        }
        if ((c3 == '+' || c3 == '-') && n3 + 3 < n2 && string.charAt(n3 + 1) == '0' && Character.toLowerCase(string.charAt(n3 + 2)) == 'x') {
            double d2 = ScriptRuntime.a(string, n3 + 3, 16);
            return c3 == '-' ? -d2 : d2;
        }
        int n4 = n2 - 1;
        while (Character.isWhitespace(c2 = string.charAt(n4))) {
            --n4;
        }
        if (c2 == 'y') {
            String string2;
            if (c3 == '+' || c3 == '-') {
                ++n3;
            }
            if ((string2 = string.substring(n3, n4 + 1)).equals("Infinity")) {
                return c3 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String string3 = string.substring(n3, n4 + 1);
        for (int i2 = string3.length() - 1; i2 >= 0; --i2) {
            char c4 = string3.charAt(i2);
            if ('0' <= c4 && c4 <= '9' || c4 == '.' || c4 == 'e' || c4 == 'E' || c4 == '+' || c4 == '-') continue;
            return NaN;
        }
        try {
            double d3 = Double.valueOf(string3);
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            double d4 = NaN;
            return d4;
        }
    }

    static double a(String string, int n2, int n3) {
        double d2;
        block18: {
            int n4;
            int n5;
            char c2 = '9';
            char c3 = 'a';
            char c4 = 'A';
            int n6 = string.length();
            if (n3 < 10) {
                c2 = (char)(48 + n3 - 1);
            }
            if (n3 > 10) {
                c3 = (char)(97 + n3 - 10);
                c4 = (char)(65 + n3 - 10);
            }
            d2 = 0.0;
            for (n5 = n2; n5 < n6; ++n5) {
                char c5 = string.charAt(n5);
                if ('0' <= c5 && c5 <= c2) {
                    n4 = c5 - 48;
                } else if ('a' <= c5 && c5 < c3) {
                    n4 = c5 - 97 + 10;
                } else {
                    if ('A' > c5 || c5 >= c4) break;
                    n4 = c5 - 65 + 10;
                }
                d2 = d2 * (double)n3 + (double)n4;
            }
            if (n2 == n5) {
                return NaN;
            }
            if (!(d2 >= 9.007199254740992E15)) break block18;
            if (n3 == 10) {
                try {
                    double d3 = Double.valueOf(string.substring(n2, n5));
                    return d3;
                }
                catch (NumberFormatException numberFormatException) {
                    double d4 = NaN;
                    return d4;
                }
            }
            if (n3 == 2 || n3 == 4 || n3 == 8 || n3 == 16 || n3 == 32) {
                n n7 = new n(n3, string, n2, n5);
                d2 = 0.0;
                while ((n4 = n7.a()) == 0) {
                }
                if (n4 == 1) {
                    int n8;
                    d2 = 1.0;
                    for (n8 = 52; n8 != 0; --n8) {
                        n4 = n7.a();
                        if (n4 < 0) {
                            return d2;
                        }
                        d2 = d2 * (double)2 + (double)n4;
                    }
                    n8 = n7.a();
                    if (n8 >= 0) {
                        int n9;
                        double d5 = 2.0;
                        int n10 = 0;
                        while ((n9 = n7.a()) >= 0) {
                            n10 |= n9;
                            d5 *= (double)2;
                        }
                        d2 += (double)(n8 & (n4 | n10));
                        d2 *= d5;
                    }
                }
            }
        }
        return d2;
    }

    public static double toNumber(Object object) {
        if (object != null && object instanceof Scriptable && (object = ((Scriptable)object).getDefaultValue(NumberClass)) != null && object instanceof Scriptable) {
            throw ScriptRuntime.a("msg.primitive.expected", object);
        }
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.a("msg.invalid.type", object);
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Scriptable) {
            if (Context.b().e()) {
                return object != Undefined.instance;
            }
            if ((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.a("msg.primitive.expected", object);
            }
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            return d2 == d2 && d2 != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    protected ScriptRuntime() {
    }
}

