/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import com.fourthpass.runtimehelp.a;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.c;

class TestScan {
    static Class b;
    static Class a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void a() {
        System.err.println("usage: TestScan    [-compile [level] | -scan | -ir | -nt | -opt [level] ] filename.js");
        System.err.println("\t-compile [level] - compile the given file and return, for profiling");
        System.err.println("\t-scan            - list tokens");
        System.err.println("\t-ir              - print Internal Representation parse tree");
        System.err.println("\t-nt              - print NodeTransformed IR tree");
        System.err.println("\t-opt [level]     - print transformed and optimized IR tree");
        System.err.println();
        System.err.println("(note that nothing may be printed by the above if Context.printTrees is false.)");
    }

    public static void scan(String string, String string2, int n2) throws IOException {
        FileReader fileReader = null;
        string = string.intern();
        try {
            fileReader = new FileReader(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("couldn't open file ".concat(String.valueOf(string2)));
            System.exit(1);
        }
        Context context = new Context();
        try {
            Context.enter();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == "-compile") {
            context.setOptimizationLevel(n2);
            context.compileReader(null, fileReader, string2, 1, null);
            return;
        }
        TokenStream tokenStream = new TokenStream(fileReader, null, string2, 1);
        if (string == "-scan") {
            int n3;
            while ((n3 = tokenStream.getToken()) != 0) {
            }
        } else if (string == "-ir") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            c c2 = new c(iRFactory);
            Node node = (Node)c2.parse(tokenStream);
            System.out.print(node.toStringTree());
        } else if (string == "-nt") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            NodeTransformer nodeTransformer = new NodeTransformer();
            c c3 = new c(iRFactory);
            Node node = (Node)c3.parse(tokenStream);
            nodeTransformer.transform(node, null, tokenStream, null);
            System.out.print(node.toStringTree());
        } else if (string == "-opt") {
            IRFactory iRFactory = new IRFactory(tokenStream, null);
            NodeTransformer nodeTransformer = new NodeTransformer();
            c c4 = new c(iRFactory);
            Node node = (Node)c4.parse(tokenStream);
            nodeTransformer.transform(node, null, tokenStream, null);
            context.setOptimizationLevel(n2);
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.optimizer.Optimizer");
                Object obj = clazz.newInstance();
                Class[] classArray = new Class[]{a == null ? (a = TestScan.a("org.mozilla.javascript.Node")) : a, b == null ? (b = TestScan.a("java.lang.Integer")) : b};
                Method method = com.fourthpass.runtimehelp.a.a(clazz, "optimize", classArray);
                Object[] objectArray = new Object[]{node, new Integer(n2)};
                method.invoke(obj, objectArray);
                System.out.print(node.toStringTree());
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            TestScan.a();
            return;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        String string2 = "nt";
        int n2 = 0;
        if (stringArray.length == 1) {
            string = stringArray[0];
            string2 = "-nt";
        } else if (stringArray.length == 2) {
            string = stringArray[1];
            string2 = stringArray[0];
        } else if (stringArray.length == 3 && stringArray[0].equals("-opt")) {
            n2 = Integer.parseInt(stringArray[1]);
            string = stringArray[2];
            string2 = "-opt";
        } else if (stringArray.length > 1 && stringArray[0].equals("-compile")) {
            string2 = "-compile";
            if (stringArray.length == 3) {
                string = stringArray[2];
                n2 = Integer.parseInt(stringArray[1]);
            } else if (stringArray.length == 2) {
                string = stringArray[1];
            } else {
                TestScan.a();
                System.exit(1);
            }
        } else {
            TestScan.a();
            System.exit(1);
        }
        TestScan.scan(string2, string, n2);
    }

    TestScan() {
    }
}

