/*
 * Decompiled with CFR 0.152.
 */
package com.borland.install;

import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.SimpleRegistryManager;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.util.StringTokenizer;

public class CCRegistryManager {
    private SimpleRegistryManager srm;
    private InstallerProxy ip;
    private UninstallerProxy up;
    private String delimiter;
    private boolean rollbackFlag;
    private static final String CLASS_NAME = "SimpleRegistryManagerPlus";
    private static final String INSTALL_MESSAGE = "Win32 Registry Entry";
    private static final String UNINSTALL_MESSAGE = "Win 32 Registry Entry";
    public static boolean debug = false;
    private static final int MAX_REG_COMPONENTS = 4;
    private static final int KEYPATH = 0;
    private static final int VALUENAME = 1;
    private static final int VALUETYPE = 2;
    private static final int VALUE = 3;
    private static final String INSTALLED_CONST = "$INSTALLED$";
    private static final String ROLLBACK_CONST = "$ROLLBACK$";
    private static final String DELETE_CONST = "$DELETE$";
    private static final String KEY_ONLY_CONST = "$KEY_ONLY$";
    private static final String DEFAULT_CONST = "$DEFAULT$";
    private static final String INTEGER_TYPE_CONST = "INTEGER";
    private static final String BYTE_TYPE_CONST = "BYTE";
    private static final String STRING_TYPE_CONST = "STRING";
    private static final String DEFAULT_DELIMITER = ",";
    static Class class$com$zerog$ia$api$pub$SimpleRegistryManager;

    private static void debugMsg(String msg) {
        if (debug) {
            System.err.println("SimpleRegistryManagerPlus(D): ".concat(String.valueOf(msg)));
        }
    }

    private static void stdMsg(String msg) {
        System.out.println("SimpleRegistryManagerPlus: ".concat(String.valueOf(msg)));
    }

    public CCRegistryManager(InstallerProxy ip) {
        this.setDefaultDelimiter();
        this.up = null;
        this.ip = ip;
        this.enableRollback();
        this.srm = (SimpleRegistryManager)ip.getService(class$com$zerog$ia$api$pub$SimpleRegistryManager == null ? (class$com$zerog$ia$api$pub$SimpleRegistryManager = CCRegistryManager.class$("com.zerog.ia.api.pub.SimpleRegistryManager")) : class$com$zerog$ia$api$pub$SimpleRegistryManager);
    }

    public CCRegistryManager(UninstallerProxy up) {
        this.setDefaultDelimiter();
        this.ip = null;
        this.up = up;
        this.enableRollback();
        this.srm = (SimpleRegistryManager)up.getService(class$com$zerog$ia$api$pub$SimpleRegistryManager == null ? (class$com$zerog$ia$api$pub$SimpleRegistryManager = CCRegistryManager.class$("com.zerog.ia.api.pub.SimpleRegistryManager")) : class$com$zerog$ia$api$pub$SimpleRegistryManager);
    }

    public CCRegistryManager(InstallerProxy ip, String inDelimiter) {
        this.setDelimiter(this.delimiter);
        this.up = null;
        this.ip = ip;
        this.enableRollback();
        this.srm = (SimpleRegistryManager)ip.getService(class$com$zerog$ia$api$pub$SimpleRegistryManager == null ? (class$com$zerog$ia$api$pub$SimpleRegistryManager = CCRegistryManager.class$("com.zerog.ia.api.pub.SimpleRegistryManager")) : class$com$zerog$ia$api$pub$SimpleRegistryManager);
    }

    public CCRegistryManager(UninstallerProxy up, String delimiter) {
        this.setDelimiter(delimiter);
        this.ip = null;
        this.up = up;
        this.enableRollback();
        this.srm = (SimpleRegistryManager)up.getService(class$com$zerog$ia$api$pub$SimpleRegistryManager == null ? (class$com$zerog$ia$api$pub$SimpleRegistryManager = CCRegistryManager.class$("com.zerog.ia.api.pub.SimpleRegistryManager")) : class$com$zerog$ia$api$pub$SimpleRegistryManager);
    }

    public void enableRollback() {
        this.rollbackFlag = true;
    }

    public void disableRollback() {
        this.rollbackFlag = false;
    }

    public void setDelimiter(String inDelimiter) {
        this.delimiter = inDelimiter;
    }

    public void setDefaultDelimiter() {
        this.delimiter = DEFAULT_DELIMITER;
    }

    public boolean exists(String keyPath) {
        boolean registryExists = false;
        String tempValueName = "ZGKeyTestEntry199x";
        try {
            if (this.srm.setRegistryKeyValue(keyPath, tempValueName, "")) {
                registryExists = true;
                this.srm.deleteRegistryKeyValue(keyPath, tempValueName);
            } else {
                registryExists = false;
            }
        }
        catch (Exception e) {
            registryExists = false;
        }
        return registryExists;
    }

    public String setRegistryEntryDelimitedString(String registryEntry) {
        String[] registryArray = null;
        String returnValue = null;
        registryArray = this.getSRMP_InternalFormatFromDelimitedString(registryEntry);
        if (registryArray != null) {
            returnValue = this.setRegistryEntry(registryArray);
        }
        return returnValue;
    }

    public String setRegistryKeyValue(String keyPath, String valueName, Object value) {
        String returnValue = null;
        String[] registryArray = new String[4];
        registryArray[0] = keyPath;
        registryArray[1] = valueName;
        if (value instanceof String) {
            registryArray[2] = STRING_TYPE_CONST;
            registryArray[3] = value.toString();
        } else if (value instanceof Integer) {
            registryArray[2] = INTEGER_TYPE_CONST;
            registryArray[3] = value.toString();
        } else if (value instanceof byte[]) {
            String byteArrayValue = "";
            for (int i = 0; i < ((byte[])value).length; ++i) {
                byteArrayValue = String.valueOf(byteArrayValue).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(byteArrayValue)).append(Byte.toString(((byte[])value)[i])).append(" "))));
            }
            registryArray[2] = BYTE_TYPE_CONST;
            registryArray[3] = byteArrayValue;
        }
        returnValue = this.setRegistryEntry(registryArray);
        return returnValue;
    }

    public String createRegistryKey(String keyPath) {
        return this.setRegistryEntryDelimitedString(keyPath);
    }

    public Object getRegistryKeyValue(String keyPath, String valueName) {
        Object returnValue = null;
        if (this.exists(keyPath)) {
            try {
                if (valueName.equalsIgnoreCase(DEFAULT_CONST) || valueName.equals("@")) {
                    valueName = "";
                }
                returnValue = this.srm.getRegistryKeyValue(keyPath, valueName);
            }
            catch (Exception e) {
                CCRegistryManager.debugMsg("Exception: likely non-existent valueName or 'No Value Set.'");
            }
        } else {
            CCRegistryManager.debugMsg("Key does not exist.");
        }
        return returnValue;
    }

    public boolean equalsValue(String keyPath, String valueName, Object value) {
        boolean equality = false;
        if (valueName.equalsIgnoreCase(DEFAULT_CONST) || valueName.equals("@")) {
            valueName = "";
        }
        Object currentRegistryValue = this.srm.getRegistryKeyValue(keyPath, valueName);
        if (value instanceof String && currentRegistryValue instanceof String) {
            value = this.replaceDoubleBackSlashes(value.toString());
        }
        if (value instanceof byte[]) {
            if (currentRegistryValue instanceof byte[] && ((byte[])value).length == ((byte[])currentRegistryValue).length) {
                equality = true;
                for (int i = 0; i < ((byte[])value).length; ++i) {
                    if (((byte[])value)[i] == ((byte[])currentRegistryValue)[i]) continue;
                    equality = false;
                    break;
                }
            }
        } else if (value.equals(currentRegistryValue)) {
            equality = true;
        }
        return equality;
    }

    public boolean equalsDelimitedStringValue(String registryEntry) {
        boolean equality = false;
        String[] registryArray = null;
        registryArray = this.getSRMP_InternalFormatFromDelimitedString(registryEntry);
        if (registryArray != null) {
            try {
                if (this.equalsValue(registryArray[0], registryArray[1], this.getValue(registryArray[2], registryArray[3]))) {
                    equality = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return equality;
    }

    public boolean deleteRegistryEntryDelimitedString(String entryData) {
        boolean success = false;
        if (entryData != null && !entryData.equals("")) {
            success = entryData.startsWith(INSTALLED_CONST) ? this.verifiedRegistryEntryRemoval(entryData) : this.straightRegistryEntryRemoval(entryData);
        } else {
            CCRegistryManager.debugMsg("No deletion registry entry data provided.");
        }
        if (!success) {
            CCRegistryManager.debugMsg("Deletion Failure: ".concat(String.valueOf(entryData)));
        }
        return success;
    }

    public boolean deleteRegistryKey(String keyPath) {
        boolean success = false;
        try {
            success = this.srm.deleteRegistryKey(keyPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public boolean deleteRegistryKeyValue(String keyPath, String valueName) {
        boolean success = false;
        try {
            success = this.srm.deleteRegistryKeyValue(keyPath, valueName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private boolean makeEntry(String keyPath, String valueName, String valueType, String value) {
        boolean success = false;
        try {
            success = this.srm.createRegistryKey(keyPath);
            if (success && !valueName.equalsIgnoreCase(KEY_ONLY_CONST)) {
                if (valueName.equalsIgnoreCase(DEFAULT_CONST) || valueName.equals("@")) {
                    valueName = "";
                }
                success = this.srm.setRegistryKeyValue(keyPath, valueName, this.getValue(valueType, value));
            }
        }
        catch (Exception e) {
            CCRegistryManager.stdMsg("Exception trying to make registry entry. Entry Failed.");
            success = false;
        }
        return success;
    }

    private Object getValue(String valueType, String value) throws Exception {
        Object returnValue;
        if (valueType.equalsIgnoreCase(STRING_TYPE_CONST)) {
            returnValue = value;
        } else if (valueType.equalsIgnoreCase(INTEGER_TYPE_CONST)) {
            returnValue = Integer.valueOf(value);
        } else if (valueType.equalsIgnoreCase(BYTE_TYPE_CONST)) {
            StringTokenizer st = new StringTokenizer(value);
            byte[] byteArrayValues = new byte[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                byteArrayValues[i] = Byte.valueOf(st.nextToken());
                ++i;
            }
            returnValue = byteArrayValues;
        } else {
            CCRegistryManager.debugMsg("Error: not a recognized value type.");
            throw new Exception();
        }
        return returnValue;
    }

    private boolean straightRegistryEntryRemoval(String entryData) {
        boolean success = false;
        StringTokenizer st = new StringTokenizer(entryData, this.delimiter);
        int numberOfTokens = st.countTokens();
        String keyPath = st.nextToken().trim();
        try {
            if (numberOfTokens == 1) {
                success = entryData.trim().endsWith(this.delimiter) ? this.srm.deleteRegistryKeyValue(keyPath, "") : this.srm.deleteRegistryKey(keyPath);
            } else {
                String valueName = st.nextToken().trim();
                if (valueName.equalsIgnoreCase(KEY_ONLY_CONST)) {
                    success = this.srm.deleteRegistryKey(keyPath);
                } else {
                    if (valueName.equals("@") || valueName.equalsIgnoreCase(DEFAULT_CONST)) {
                        valueName = "";
                    }
                    success = this.srm.deleteRegistryKeyValue(keyPath, valueName);
                }
            }
        }
        catch (Exception e) {
            CCRegistryManager.debugMsg("deleteRegistryEntry threw Exception. Operation Failed.");
        }
        return success;
    }

    private boolean verifiedRegistryEntryRemoval(String entryData) {
        boolean success = false;
        boolean malformed = false;
        int firstDelimiter = entryData.indexOf(this.delimiter);
        if (firstDelimiter != -1) {
            int rollbackIndex = entryData.indexOf(ROLLBACK_CONST);
            int deleteIndex = entryData.indexOf(DELETE_CONST);
            int tempIndex = Math.max(deleteIndex, rollbackIndex);
            if (tempIndex != -1) {
                int nextDelimiter = entryData.indexOf(this.delimiter, tempIndex + 1);
                if (nextDelimiter != -1) {
                    String original = entryData.substring(firstDelimiter + 1, tempIndex);
                    String actionString = entryData.substring(nextDelimiter + 1);
                    if (this.equalsDelimitedStringValue(original)) {
                        if (!actionString.equals("")) {
                            if (tempIndex == rollbackIndex) {
                                actionString = this.replaceDoubleBackSlashes(actionString);
                                CCRegistryManager.stdMsg("RollBack: ".concat(String.valueOf(actionString)));
                                success = this.setRegistryEntryDelimitedString(actionString) != null;
                            } else {
                                CCRegistryManager.stdMsg("Delete: ".concat(String.valueOf(actionString)));
                                success = this.straightRegistryEntryRemoval(actionString);
                            }
                        }
                    } else {
                        CCRegistryManager.stdMsg("Registry Entries have changed since installation.  Not rolling back or removing.");
                        success = true;
                    }
                } else {
                    CCRegistryManager.debugMsg("a next delimiter was not found after the $ROLLBACK$ or $DELETE$ action strings.");
                    malformed = true;
                }
            } else {
                CCRegistryManager.debugMsg("neither the $ROLLBACK$ or $DELETE$ action strings were encountered.");
                malformed = true;
            }
        } else {
            CCRegistryManager.debugMsg("there were no further delimiters following the $INSTALLED$ identifier string.");
            malformed = true;
        }
        if (malformed) {
            CCRegistryManager.stdMsg("Malformed delete registry entry data.");
        }
        return success;
    }

    private String setRegistryEntry(String[] registryArray) {
        String returnValue = null;
        String rollbackInfo = null;
        boolean trueParentKey = true;
        boolean success = false;
        String topKey = this.getTopKey(registryArray[0]);
        if (!topKey.equals(registryArray[0]) || !this.exists(topKey)) {
            trueParentKey = false;
        }
        if (this.rollbackFlag && trueParentKey && !registryArray[1].equals(KEY_ONLY_CONST)) {
            rollbackInfo = this.getRollbackInfo(registryArray);
        }
        if (success = this.makeEntry(registryArray[0], registryArray[1], registryArray[2], registryArray[3])) {
            returnValue = this.getReturnValueForRollback(registryArray, topKey, rollbackInfo, trueParentKey);
        }
        CCRegistryManager.debugMsg("keyPath = ".concat(String.valueOf(registryArray[0])));
        CCRegistryManager.debugMsg("topKey = ".concat(String.valueOf(topKey)));
        CCRegistryManager.debugMsg("trueParentKey = ".concat(String.valueOf(trueParentKey ? "true" : "false")));
        CCRegistryManager.debugMsg("returnValue = ".concat(String.valueOf(returnValue)));
        return returnValue;
    }

    private String getTopKey(String keyPath) {
        String topKey = keyPath;
        String tempKey = keyPath;
        while (!this.exists(keyPath)) {
            int index = keyPath.lastIndexOf(92);
            if (index != -1) {
                tempKey = topKey;
                topKey = keyPath;
                keyPath = keyPath.substring(0, index);
                continue;
            }
            topKey = tempKey;
            break;
        }
        CCRegistryManager.debugMsg("topKey = ".concat(String.valueOf(topKey)));
        return topKey;
    }

    private String getRollbackInfo(String[] registryArray) {
        Object originalValue = null;
        String originalValueType = null;
        String rollbackInfo = null;
        String tempValueName = registryArray[1];
        if (tempValueName.equalsIgnoreCase(DEFAULT_CONST) || tempValueName.equals("@")) {
            tempValueName = "";
        }
        try {
            originalValue = this.srm.getRegistryKeyValue(registryArray[0], tempValueName);
            if (originalValue != null) {
                if (originalValue instanceof Integer) {
                    originalValueType = INTEGER_TYPE_CONST;
                } else if (originalValue instanceof byte[]) {
                    byte[] byteArrayOriginalValue = (byte[])originalValue;
                    originalValue = "";
                    originalValueType = BYTE_TYPE_CONST;
                    for (int i = 0; i < byteArrayOriginalValue.length; ++i) {
                        originalValue = String.valueOf(new StringBuffer(String.valueOf((String)originalValue)).append(Byte.toString(byteArrayOriginalValue[i])).append(" "));
                    }
                } else {
                    originalValueType = STRING_TYPE_CONST;
                }
                rollbackInfo = String.valueOf(new StringBuffer(String.valueOf(originalValueType)).append(this.delimiter).append(originalValue));
            } else {
                rollbackInfo = null;
            }
        }
        catch (Exception e) {
            CCRegistryManager.debugMsg(String.valueOf(new StringBuffer("Exception getting rollback for: ").append(registryArray[0]).append(" - ").append(registryArray[1])));
            rollbackInfo = null;
        }
        return rollbackInfo;
    }

    private String getReturnValueForRollback(String[] registryArray, String topKey, String rollbackInfo, boolean trueParentKey) {
        String returnValue = this.rollbackFlag ? String.valueOf(new StringBuffer(INSTALLED_CONST).append(this.delimiter).append(registryArray[0]).append(this.delimiter).append(registryArray[1]).append(this.delimiter).append(registryArray[2]).append(this.delimiter).append(registryArray[3])) : "";
        if (trueParentKey) {
            if (registryArray[1].equals(KEY_ONLY_CONST)) {
                returnValue = "";
            } else if (rollbackInfo == null) {
                if (this.rollbackFlag) {
                    returnValue = String.valueOf(returnValue).concat(String.valueOf(DELETE_CONST.concat(String.valueOf(this.delimiter))));
                }
                returnValue = String.valueOf(returnValue).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(topKey)).append(this.delimiter).append(registryArray[1]))));
            } else {
                returnValue = String.valueOf(returnValue).concat(String.valueOf(String.valueOf(new StringBuffer(ROLLBACK_CONST).append(this.delimiter).append(registryArray[0]).append(this.delimiter).append(registryArray[1]).append(this.delimiter).append(rollbackInfo))));
            }
        } else if (registryArray[1].equals(KEY_ONLY_CONST)) {
            returnValue = topKey;
        } else {
            if (this.rollbackFlag) {
                returnValue = String.valueOf(returnValue).concat(String.valueOf(DELETE_CONST.concat(String.valueOf(this.delimiter))));
            }
            returnValue = String.valueOf(returnValue).concat(String.valueOf(topKey));
        }
        return returnValue;
    }

    private String[] getSRMP_InternalFormatFromDelimitedString(String registryEntry) {
        String[] registryArray = null;
        if (registryEntry != null && !registryEntry.equals("")) {
            StringTokenizer st = new StringTokenizer(registryEntry, this.delimiter);
            int numberOfTokens = st.countTokens();
            registryArray = new String[4];
            for (int i = 0; i < Math.min(numberOfTokens, 4); ++i) {
                registryArray[i] = st.nextToken().trim();
            }
            switch (numberOfTokens) {
                case 1: {
                    if (registryArray[0].toUpperCase().startsWith("HKEY")) {
                        registryArray[1] = KEY_ONLY_CONST;
                        registryArray[2] = "";
                        registryArray[3] = "";
                        break;
                    }
                    registryArray = null;
                    break;
                }
                case 2: {
                    if (registryArray[1].equalsIgnoreCase(KEY_ONLY_CONST) || registryArray[1].equals("")) {
                        registryArray[1] = KEY_ONLY_CONST;
                        registryArray[2] = "";
                        registryArray[3] = "";
                        break;
                    }
                    registryArray = null;
                    break;
                }
                case 3: {
                    registryArray[3] = registryArray[2];
                    registryArray[2] = STRING_TYPE_CONST;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    CCRegistryManager.stdMsg("Malformed Registry entry: ".concat(String.valueOf(registryEntry)));
                    registryArray = null;
                }
            }
        }
        return registryArray;
    }

    private String replaceDoubleBackSlashes(String value) {
        StringBuffer valueStringBuffer = new StringBuffer("");
        for (int i = 0; i < value.length(); ++i) {
            int j = i + 1;
            if (value.charAt(i) != '\\') {
                valueStringBuffer.append(value.charAt(i));
                continue;
            }
            if (i != value.length()) {
                if (value.charAt(j) == '\\') {
                    valueStringBuffer.append(value.charAt(i));
                    ++i;
                    continue;
                }
                valueStringBuffer.append(value.charAt(i));
                continue;
            }
            valueStringBuffer.append(value.charAt(i));
        }
        CCRegistryManager.debugMsg("value            : ".concat(String.valueOf(value)));
        CCRegistryManager.debugMsg("valueStringBuffer: ".concat(String.valueOf(valueStringBuffer)));
        return valueStringBuffer.toString();
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

