/*
 * Decompiled with CFR 0.152.
 */
package com.borland.install;

import com.borland.install.OSTextConverter;
import com.borland.install.Res;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

class DOS2UnixConverter
implements OSTextConverter {
    private static final String tmpFileName = "d2utempfile.txt";

    DOS2UnixConverter() {
    }

    public void convert(File textFile) {
        String parentDir = textFile.getParent();
        File tmpFile = new File(String.valueOf(new StringBuffer(String.valueOf(parentDir != null ? parentDir : ".")).append(File.separator).append(tmpFileName)));
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(textFile));
            BufferedWriter outFile = new BufferedWriter(new FileWriter(tmpFile));
            while (inFile.ready()) {
                int ch = inFile.read();
                if ((char)ch == '\r') continue;
                outFile.write(ch);
            }
            inFile.close();
            outFile.close();
            if (textFile.delete()) {
                tmpFile.renameTo(textFile);
            } else {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            System.out.println("DOS2UnixConverter:".concat(String.valueOf(e)));
        }
    }

    public String getListFileName() {
        return "dos2unix.list";
    }

    public void showMessageDialog(Frame parent, String title, String message) {
        final Dialog dlg = new Dialog(parent, title, true);
        dlg.setLayout(new BorderLayout());
        Label lblMessage = new Label(message);
        Button btnOk = new Button(Res.getString(68));
        dlg.add((Component)lblMessage, "Center");
        dlg.add((Component)btnOk, "South");
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dlg.dispose();
            }
        });
        dlg.show();
    }
}

