/*
 * Decompiled with CFR 0.152.
 */
package com.borland.install.iacc;

import com.borland.install.Util;
import com.borland.install.iacc.Res;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class MakeJDSJDKConfig
extends CustomCodeAction {
    public void install(InstallerProxy ip) throws InstallException {
        String sep = File.separator;
        boolean isWindows = File.separatorChar == '\\' && File.pathSeparatorChar == ';';
        String jvmExecutable = "java".concat(String.valueOf(isWindows ? ".exe" : ""));
        String jbuilderHome = ip.substitute("$JBUILDER_HOME$");
        if (jbuilderHome == null) {
            System.err.println("Error: (makeJDKConfig) JBUILDER_HOME is null !");
            return;
        }
        String jdkDir = ip.substitute("$JDK_DIR$");
        if (jdkDir == null) {
            System.err.println("Error: (makeJDKConfig) JDK_DIR is null !");
            return;
        }
        File jdkConfig = new File(String.valueOf(new StringBuffer(String.valueOf(jbuilderHome)).append(sep).append("bin").append(sep).append("jdk.config")));
        if (jdkConfig.exists()) {
            System.out.println("MakeJDSJDKConfig: jdk.config exists!");
            return;
        }
        try {
            PrintWriter cfgFile = new PrintWriter(new FileWriter(jdkConfig));
            cfgFile.println("# Set the path for the JDK");
            cfgFile.println(String.valueOf(new StringBuffer("javapath ").append(jdkDir).append(sep).append("bin").append(sep).append(jvmExecutable)));
            cfgFile.println("# Add the tools.jar");
            cfgFile.println(String.valueOf(new StringBuffer("addpath ").append(jdkDir).append(sep).append("lib").append(sep).append("tools.jar")));
            cfgFile.println("vmparam -Xverify:none");
            cfgFile.println("# +-----------------------------------------------------+");
            cfgFile.println("# |                                                     |");
            cfgFile.println("# |    Uncomment the following line if you are having   |");
            cfgFile.println("# |  problems with international text support in JDBC.  |");
            cfgFile.println("# |        (Only available in Enterprise edition)       |");
            cfgFile.println("# |                                                     |");
            cfgFile.println("# +-----------------------------------------------------+");
            cfgFile.println("#addbootpath ../lib/intl/DBCSpatch.jar:../lib/intl/AwtMotifpatch.jar");
            Util utils = new Util();
            if (utils.getOSType().equals("windows")) {
                cfgFile.println("vmparam -Djava.compiler=symcjit");
            } else if (utils.getOSName().equals("linux")) {
                cfgFile.println("vmparam -Djava.compiler=javacomp");
            }
            cfgFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return Res.getString(25);
    }

    public String getUninstallStatusMessage() {
        return Res.getString(26);
    }
}

