/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.JCScrollEvent;
import com.klg.jclass.table.JCTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class AdjustmentHandler
implements AdjustmentListener,
Serializable {
    protected JCTable table;
    protected boolean isTracking = false;
    protected JLabel trackLabel = new JLabel();
    private int vertLastRow = -1;
    private int vertLastValue = -1;
    private int vertLastRealValue = -1;
    private int horLastColumn = -1;
    private int horLastValue = -1;
    private int horLastRealValue = -1;

    public AdjustmentHandler(JCTable jCTable) {
        this.table = jCTable;
        this.trackLabel.setOpaque(true);
        this.trackLabel.setVisible(false);
    }

    protected void adjustOrigin() {
        Point point = this.table.getCellAreaHandler().getCellOrigin();
        JScrollBar jScrollBar = this.table.getHorizSB();
        if (jScrollBar != null && jScrollBar.isVisible() && jScrollBar.getValue() != -point.x) {
            point.x = -jScrollBar.getValue();
        }
        jScrollBar = null;
        JScrollBar jScrollBar2 = this.table.getVertSB();
        if (jScrollBar2 != null & jScrollBar2.isVisible() && jScrollBar2.getValue() != -point.y) {
            point.y = -jScrollBar2.getValue();
        }
        jScrollBar2 = null;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.table.isRepaintEnabled()) {
            this.table.setRecalcRequired(true);
            return;
        }
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        int n = adjustmentEvent.getValue();
        JCScrollEvent jCScrollEvent = null;
        int n2 = this.table.getJumpScroll();
        if (adjustmentEvent.getAdjustable().getOrientation() == 1) {
            Serializable serializable;
            int n3;
            Object object;
            Object object2;
            int n4 = cellAreaHandler.getCellOrigin().y;
            int n5 = -cellAreaHandler.getCellOrigin().y;
            if (n == n5 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if ((n2 == 2 || n2 == 3) && n != this.vertLastValue) {
                object2 = this;
                synchronized (object2) {
                    int n6;
                    object = adjustmentEvent.getAdjustable();
                    n3 = this.table.getCellAreaHandler().getCellArea().getStandardOffsetY();
                    int n7 = this.table.getCellLayout().getRow(0, n + n3);
                    if (n7 == this.vertLastRow) {
                        n7 += n > this.vertLastValue ? 1 : -1;
                    }
                    if (object instanceof JScrollBar && ((JScrollBar)object).getValueIsAdjusting() && (n > this.vertLastRealValue && n7 < this.vertLastRow || n < this.vertLastRealValue && n7 > this.vertLastRow)) {
                        n7 = this.vertLastRow;
                    }
                    this.vertLastRealValue = n;
                    n = this.table.getCellLayout().getRowPosition(n7) - n3;
                    if (n > (n6 = object.getMaximum() - object.getVisibleAmount())) {
                        n = n6;
                    }
                    this.vertLastRow = n7;
                    this.vertLastValue = n;
                    if (n != this.vertLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n != n5) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n) {
                    adjustmentEvent.getAdjustable().setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.y = -n;
            if (bl) {
                object2 = adjustmentEvent.getAdjustable();
                object2.setValue(n);
            }
            if (((JScrollBar)(object2 = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getVertSBTrack() != 0) {
                    if (this.isTracking) {
                        int n8 = this.table.getVisibleCells().start_row;
                        object = "";
                        if (this.table.getVertSBTrack() == 1) {
                            object = Integer.toString(n8 + 1);
                        } else {
                            n3 = this.table.getVertSBTrackColumn();
                            Object object3 = this.table.getDataView().getObject(n8, n3);
                            object = object3 == null || object3.toString() == null ? "" : object3.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText((String)object);
                    } else {
                        CellArea cellArea = this.getRightCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.trackLabel.requestFocus();
                        int n9 = 50;
                        n3 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n9 = dimension.width;
                            n3 = dimension.height;
                        }
                        this.trackLabel.setBounds(cellArea.getWidth() - n9, (cellArea.getHeight() - n3) / 2, n9, n3);
                        this.trackLabel.setHorizontalAlignment(4);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                serializable = null;
                serializable = new JCScrollEvent(this, 2, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent((JCScrollEvent)serializable);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(1, n4 + n);
            }
            if (!this.table.mouseHandler.isResizing() && (serializable = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(0, serializable.y, this.table.getSize().width, serializable.height);
            }
        } else {
            Serializable serializable;
            int n10;
            Object object;
            Object object4;
            int n11 = cellAreaHandler.getCellOrigin().x;
            int n12 = -cellAreaHandler.getCellOrigin().x;
            if (n == n12 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if (n2 == 1 || n2 == 3 && n != this.horLastValue) {
                object4 = this;
                synchronized (object4) {
                    int n13;
                    object = adjustmentEvent.getAdjustable();
                    n10 = this.table.getCellAreaHandler().getCellArea().getStandardOffsetX();
                    int n14 = this.table.getCellLayout().getColumn(n + n10, 0);
                    if (n14 == this.horLastColumn) {
                        n14 += n > this.horLastValue ? 1 : -1;
                    }
                    if (object instanceof JScrollBar && ((JScrollBar)object).getValueIsAdjusting() && (n > this.horLastRealValue && n14 < this.horLastColumn || n < this.horLastRealValue && n14 > this.horLastColumn)) {
                        n14 = this.horLastColumn;
                    }
                    this.horLastRealValue = n;
                    n = this.table.getCellLayout().getColumnPosition(n14) - n10;
                    if (n > (n13 = object.getMaximum() - object.getVisibleAmount())) {
                        n = n13;
                    }
                    this.horLastColumn = n14;
                    this.horLastValue = n;
                    if (n != this.horLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n != n12) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n) {
                    adjustmentEvent.getAdjustable().setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.x = -n;
            if (bl) {
                object4 = adjustmentEvent.getAdjustable();
                object4.setValue(n);
            }
            if (((JScrollBar)(object4 = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getHorizSBTrack() != 0) {
                    if (this.isTracking) {
                        int n15 = this.table.getVisibleCells().start_column;
                        object = "";
                        if (this.table.getHorizSBTrack() == 1) {
                            object = Integer.toString(n15 + 1);
                        } else {
                            n10 = this.table.getHorizSBTrackRow();
                            n10 = n10 >= -1 ? n10 : -1;
                            Object object5 = this.table.getDataView().getObject(n10, n15);
                            object = object5 == null || object5.toString() == null ? "" : object5.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText((String)object);
                    } else {
                        CellArea cellArea = this.getBottomCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.trackLabel.requestFocus();
                        int n16 = 50;
                        n10 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n16 = dimension.width;
                            n10 = dimension.height;
                        }
                        this.trackLabel.setBounds((cellArea.getWidth() - n16) / 2, cellArea.getHeight() - n10, n16, n10);
                        this.trackLabel.setHorizontalAlignment(0);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                serializable = null;
                serializable = new JCScrollEvent(this, 2, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
                this.table.fireJCScrollEvent((JCScrollEvent)serializable);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(0, n11 + n);
            }
            if (!this.table.mouseHandler.isResizing() && (serializable = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(serializable.x, 0, serializable.width, this.table.getSize().height);
            }
        }
        if (this.table.scrollListeners != null && jCScrollEvent != null) {
            jCScrollEvent = new JCScrollEvent(this, 2, adjustmentEvent.getAdjustable(), adjustmentEvent.getAdjustable().getOrientation(), n, adjustmentEvent);
            this.table.fireJCScrollEvent(jCScrollEvent);
        }
    }

    public void dispose() {
        this.table = null;
        this.trackLabel = null;
    }

    protected CellArea getBottomCellArea() {
        if (this.table.isColumnLabelDisplay() && this.table.getRowLabelPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(2);
        }
        if (this.table.getFrozenRows() > 0 && this.table.getFrozenRowPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(1);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    protected CellArea getRightCellArea() {
        if (this.table.isRowLabelDisplay() && this.table.getRowLabelPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(6);
        }
        if (this.table.getFrozenColumns() > 0 && this.table.getFrozenColumnPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(3);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    public boolean isTracking() {
        return this.isTracking;
    }
}

