/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.ComponentModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCScrollEvent;
import com.klg.jclass.table.JCScrollListener;
import com.klg.jclass.table.JCSeries;
import com.klg.jclass.table.JCTable;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.FocusManager;
import javax.swing.JComponent;

public class ComponentHandler
extends JCSeries
implements ComponentModel,
Serializable,
JCScrollListener,
FocusListener,
KeyListener {
    protected JCTable table;
    protected boolean adjustBoundsRequired = true;
    protected boolean needsSetParent = true;
    protected FocusManager fm;

    public ComponentHandler() {
    }

    public ComponentHandler(JCTable jCTable) {
        this.setTable(jCTable);
    }

    public void addComponentsToParent() {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            CellArea cellArea = this.table.cellAreaHandler.find(seriesValue.row, seriesValue.column);
            cellArea.add((Component)seriesValue.value);
            ++n;
        }
    }

    public void afterScroll(JCScrollEvent jCScrollEvent) {
        JCCellRange jCCellRange = this.table.getVisibleCells();
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            Component component = (Component)seriesValue.value;
            if (this.table.isTracking()) {
                return;
            }
            if (seriesValue.row >= jCCellRange.start_row && seriesValue.row <= jCCellRange.end_row && seriesValue.column >= jCCellRange.start_column && seriesValue.column <= jCCellRange.end_column) {
                component.setVisible(true);
            } else {
                component.setVisible(false);
            }
            ++n;
        }
    }

    public JCCellPosition findPosition(Component component) {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            if (component == (Component)seriesValue.value) {
                return new JCCellPosition(seriesValue.row, seriesValue.column);
            }
            ++n;
        }
        return null;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.fm = FocusManager.getCurrentManager();
        FocusManager.disableSwingFocusManager();
        Component component = focusEvent.getComponent();
        JCCellPosition jCCellPosition = this.table.getPosition(component);
        this.table.editTraverseHandler.commit(true);
        if (jCCellPosition == null || jCCellPosition.row == -1 || jCCellPosition.column == -1 || !this.table.isTraversable(jCCellPosition.row, jCCellPosition.column)) {
            this.table.requestFocus();
            return;
        }
        int n = this.table.current_row;
        int n2 = this.table.current_column;
        this.table.current_row = jCCellPosition.row;
        this.table.current_column = jCCellPosition.column;
        this.table.cellAreaHandler.cellAreaRenderer.repaintRange(n, n2, n, n2);
        this.table.cellAreaHandler.cellAreaRenderer.repaintRange(this.table.current_row, this.table.current_column, this.table.current_row, this.table.current_column);
    }

    public void focusLost(FocusEvent focusEvent) {
        FocusManager.setCurrentManager(this.fm);
    }

    public JCTable getTable() {
        return this.table;
    }

    public boolean isParentSetRequired() {
        return this.needsSetParent;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = -999;
        switch (keyEvent.getKeyCode()) {
            case 9: {
                if (keyEvent.isShiftDown()) {
                    n = 3;
                    break;
                }
                n = 4;
                break;
            }
            case 40: {
                n = 1;
                break;
            }
            case 38: {
                n = 2;
                break;
            }
            case 37: {
                n = 3;
                break;
            }
            case 39: {
                n = 4;
                break;
            }
        }
        if (n != -999) {
            keyEvent.consume();
            FocusManager.setCurrentManager(this.fm);
            this.traverseNext(this.table.getPosition(keyEvent.getComponent()), n);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeCellComponents() {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            CellArea cellArea = this.table.cellAreaHandler.find(seriesValue.row, seriesValue.column);
            if (cellArea != null && cellArea.getType() == 0) {
                Component[] componentArray = cellArea.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    cellArea.remove(componentArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        this.needsSetParent = false;
    }

    public void scroll(JCScrollEvent jCScrollEvent) {
    }

    public void setDefault(Object object) {
        Component component = (Component)object;
        component.removeKeyListener(this);
        component.addKeyListener(this);
        component.removeFocusListener(this);
        component.addFocusListener(this);
        if (component instanceof JComponent) {
            ((JComponent)component).setNextFocusableComponent(this.table);
        }
        super.setDefault(object);
    }

    public void setParentSetRequired(boolean bl) {
        this.needsSetParent = bl;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
        this.table.addScrollListener(this);
    }

    public boolean setValue(int n, int n2, Object object) {
        Component component = (Component)object;
        Component component2 = this.table.getComponent(n, n2);
        CellArea cellArea = this.table.cellAreaHandler.find(n, n2);
        boolean bl = true;
        if (component2 != null) {
            component2.removeKeyListener(this);
            component2.removeFocusListener(this);
            super.remove(n, n2);
            if (cellArea != null) {
                cellArea.remove(component2);
            }
        }
        if (component != null) {
            JCCellPosition jCCellPosition = null;
            jCCellPosition = this.findPosition(component);
            if (jCCellPosition != null) {
                super.remove(jCCellPosition.row, jCCellPosition.column);
            }
            component.removeKeyListener(this);
            component.removeFocusListener(this);
            component.addFocusListener(this);
            component.addKeyListener(this);
            if (component instanceof JComponent) {
                ((JComponent)component).setNextFocusableComponent(this.table);
            }
            if (cellArea != null) {
                cellArea.add(component);
            } else {
                this.needsSetParent = true;
            }
            bl = super.setValue(n, n2, object);
        }
        this.table.cellAreaHandler.getCellAreaRenderer().repaintRange(n, n2, n, n2);
        return bl;
    }

    public void traverseNext(JCCellPosition jCCellPosition, int n) {
        JCCellPosition jCCellPosition2 = null;
        jCCellPosition2 = this.table.keyHandler.findTraversableCell(n, jCCellPosition.row, jCCellPosition.column);
        if (jCCellPosition2 != null) {
            this.table.editTraverseHandler.traverse(jCCellPosition2.row, jCCellPosition2.column, false, null, n, false);
        }
    }
}

