/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCSortEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableException;
import com.klg.jclass.table.ObjectComparator;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataComparator;
import java.util.Arrays;
import java.util.Comparator;

public class Sort {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;

    public static boolean sortByColumn(JCTable jCTable, int n, int n2, int n3, int n4, Comparator comparator) {
        int[] nArray = new int[]{n};
        int[] nArray2 = new int[]{n2};
        return Sort.sortByColumn(jCTable, nArray, nArray2, n3, n4, comparator);
    }

    public static boolean sortByColumn(JCTable jCTable, int n, int n2, Comparator comparator) {
        return Sort.sortByColumn(jCTable, n, n2, jCTable.getFrozenRows(), jCTable.getNumRows() - 1, comparator);
    }

    public static boolean sortByColumn(JCTable jCTable, int[] nArray, int[] nArray2, int n, int n2, Comparator comparator) {
        if (comparator == null) {
            comparator = new TableDataComparator();
        }
        if (nArray.length == 1) {
            jCTable.sort_column = nArray[0];
            jCTable.sort_direction = nArray2[0];
        } else {
            jCTable.sort_column = -999;
            jCTable.sort_direction = -999;
        }
        if (!(jCTable.getDataView() instanceof SortableDataViewModel)) {
            throw new JCTableException(String.valueOf(String.valueOf(jCTable.getDataView())) + " does not support the SortableDataViewModel interface");
        }
        int n3 = jCTable.getNumRows();
        if (n < 0) {
            n = 0;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        SortableDataViewModel sortableDataViewModel = (SortableDataViewModel)jCTable.getDataView();
        ObjectComparator objectComparator = new ObjectComparator(jCTable.getDataView().getDataSource(), nArray, nArray2, comparator);
        Integer[] integerArray = new Integer[n3];
        int n4 = 0;
        while (n4 < n3) {
            integerArray[n4] = new Integer(sortableDataViewModel.getDataRow(n4));
            ++n4;
        }
        Object object = integerArray;
        synchronized (object) {
            Arrays.sort(integerArray, n, n2 + 1, objectComparator);
            int[] nArray3 = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                nArray3[n5] = integerArray[n5];
                ++n5;
            }
            sortableDataViewModel.setRowMap(nArray3);
        }
        if (jCTable.sortListeners != null) {
            object = new JCSortEvent(jCTable, nArray, sortableDataViewModel.getRowMap());
            jCTable.fireJCSortEvent((JCSortEvent)object);
        }
        return true;
    }

    public static boolean sortByColumn(JCTable jCTable, int[] nArray, int[] nArray2, Comparator comparator) {
        return Sort.sortByColumn(jCTable, nArray, nArray2, jCTable.getFrozenRows(), jCTable.getNumRows() - 1, comparator);
    }
}

