/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.FrozenCellLayoutWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrozenCellLayoutEditor
extends TablePropertyEditor
implements ActionListener,
ItemListener {
    protected JTextField textRow;
    protected JTextField textColumn;
    protected JComboBox columnPlacement;
    protected JComboBox rowPlacement;
    protected static final String LEFT = "Left";
    protected static final String RIGHT = "Right";
    protected static final String TOP = "Top";
    protected static final String BOTTOM = "Bottom";
    protected static EnumString[] EnumColPosition = new EnumString[]{new EnumString(2, "Left"), new EnumString(4, "Right")};
    protected static EnumString[] EnumRowPosition = new EnumString[]{new EnumString(1, "Top"), new EnumString(3, "Bottom")};

    public FrozenCellLayoutEditor() {
        super(0);
    }

    public FrozenCellLayoutEditor(int n) {
        super(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getFrozenCellLayout().getJavaInitializationString();
    }

    public Object getValue() {
        return this.tableView.getFrozenCellLayout();
    }

    protected void init() {
        super.init(false);
        this.tableView.setSelectionPolicy(0);
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.columnPlacement)) {
            this.tableView.setFrozenColumnPlacement(TablePropertyEditor.toIntValue(EnumColPosition, (String)this.columnPlacement.getSelectedItem()));
        }
        if (this.selectionPolicy == 4 || !object.equals(this.rowPlacement)) {
            return;
        }
        String string = (String)this.rowPlacement.getSelectedItem();
        this.tableView.setFrozenRowPlacement(TablePropertyEditor.toIntValue(EnumRowPosition, (String)this.rowPlacement.getSelectedItem()));
        this.support.firePropertyChange("frozenCellLayout", null, this.getValue());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.textRow = new JTextField("0", 2);
        this.textColumn = new JTextField("0", 2);
        FrozenCellLayoutEditor frozenCellLayoutEditor = this;
        frozenCellLayoutEditor.getClass();
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(frozenCellLayoutEditor, "Frozen Cells");
        groupPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        if (this.selectionPolicy != 4) {
            groupPanel.add((Component)new JLabel("Rows"), gridBagConstraints);
            groupPanel.add((Component)this.textRow, gridBagConstraints);
            this.textRow.addActionListener(this);
            this.textRow.addFocusListener(this);
            ++gridBagConstraints.gridy;
        }
        groupPanel.add((Component)new JLabel("Columns"), gridBagConstraints);
        groupPanel.add((Component)this.textColumn, gridBagConstraints);
        FrozenCellLayoutEditor frozenCellLayoutEditor2 = this;
        frozenCellLayoutEditor2.getClass();
        TablePropertyEditor.GroupPanel groupPanel2 = new TablePropertyEditor.GroupPanel(frozenCellLayoutEditor2, "Frozen Cells Placement");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        if (this.selectionPolicy != 4) {
            this.rowPlacement = new JComboBox();
            this.rowPlacement.addItem(TOP);
            this.rowPlacement.addItem(BOTTOM);
            this.rowPlacement.setEnabled(false);
            groupPanel2.add((Component)new JLabel("Row"), gridBagConstraints);
            groupPanel2.add((Component)this.rowPlacement, gridBagConstraints);
            this.rowPlacement.addItemListener(this);
            ++gridBagConstraints.gridy;
        }
        this.columnPlacement = new JComboBox();
        this.columnPlacement.addItem(LEFT);
        this.columnPlacement.addItem(RIGHT);
        this.columnPlacement.setEnabled(false);
        groupPanel2.add((Component)new JLabel("Column"), gridBagConstraints);
        groupPanel2.add((Component)this.columnPlacement, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        jPanel.add((Component)groupPanel2, gridBagConstraints);
        this.textColumn.addActionListener(this);
        this.textColumn.addFocusListener(this);
        this.columnPlacement.addItemListener(this);
        return jPanel;
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setFrozenCellLayout((FrozenCellLayoutWrapper)object);
        super.setValue(object);
        this.updateFrozenCellLayout();
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.textRow)) {
            int n = TablePropertyEditor.getInt(this.textRow.getText());
            this.tableView.setFrozenRows(n);
            if (this.selectionPolicy != 4) {
                this.rowPlacement.setEnabled(n > 0);
            }
        } else if (object.equals(this.textColumn)) {
            int n = TablePropertyEditor.getInt(this.textColumn.getText());
            this.tableView.setFrozenColumns(n);
            this.columnPlacement.setEnabled(n > 0);
        } else {
            return;
        }
        this.support.firePropertyChange("frozenCellLayout", null, this.getValue());
    }

    protected void updateFrozenCellLayout() {
        int n = this.tableView.getFrozenRows();
        int n2 = this.tableView.getFrozenColumns();
        this.textRow.setText(String.valueOf(n));
        this.textColumn.setText(String.valueOf(n2));
        this.columnPlacement.setEnabled(n2 > 0);
        TablePropertyEditor.setSelectedItem(this.columnPlacement, TablePropertyEditor.toString(EnumColPosition, this.tableView.getFrozenColumnPlacement()));
        if (this.selectionPolicy != 4) {
            this.rowPlacement.setEnabled(n > 0);
            TablePropertyEditor.setSelectedItem(this.rowPlacement, TablePropertyEditor.toString(EnumRowPosition, this.tableView.getFrozenRowPlacement()));
        }
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateFrozenCellLayout();
        this.support.firePropertyChange("frozenCellLayout", null, this.getValue());
    }
}

