/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.table.CellBorderModel;
import com.klg.jclass.table.CellRangeValue;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCCellBorder;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCVersion;
import com.klg.jclass.table.PositionCellSize;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.beans.CellSizeWrapper;
import com.klg.jclass.table.beans.DataWrapper;
import com.klg.jclass.table.beans.FrozenCellLayoutWrapper;
import com.klg.jclass.table.beans.JCLiveCellStyle;
import com.klg.jclass.table.beans.LabelLayoutWrapper;
import com.klg.jclass.table.beans.SBLayoutWrapper;
import com.klg.jclass.table.beans.SpannedCellsWrapper;
import com.klg.jclass.table.beans.StyleWrapper;
import com.klg.jclass.table.data.JCBeanFileDataSource;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCTableModelDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class LiveTable
extends JCTable {
    protected JCCellRenderer cellRenderer = null;
    protected static int numColumns = 5;
    protected static int numRows = 10;

    public LiveTable() {
        this(true);
    }

    public LiveTable(boolean bl) {
        this.makeDataSource(bl);
        this.setPopupMenuEnabled(true);
    }

    protected String[] createArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    protected String[][] createArray2D(Vector vector) {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = vector.elementAt(n2);
            if (object instanceof Vector) {
                n = Math.max(((Vector)object).size(), n);
            }
            ++n2;
        }
        object = new String[vector.size()][n];
        int n3 = 0;
        while (n3 < vector.size()) {
            Object e = vector.elementAt(n3);
            if (e instanceof Vector) {
                object[n3] = new String[((Vector)e).size()];
                int n4 = 0;
                while (n4 < ((Vector)e).size()) {
                    Object e2 = ((Vector)e).elementAt(n4);
                    if (e2 instanceof String) {
                        object[n3][n4] = (String)e2;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return object;
    }

    public CellStyleModel createCellStyle() {
        return new JCLiveCellStyle(this, this.cellRenderer);
    }

    protected Vector createVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        return vector;
    }

    protected Vector createVector(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            Vector<String> vector2 = new Vector<String>();
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                vector2.addElement(stringArray[n][n2]);
                ++n2;
            }
            vector.addElement(vector2);
            ++n;
        }
        return vector;
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public CellSizeWrapper getCellSize() {
        return new CellSizeWrapper(this.makePositionsArray(this.getRowHeightValues()), this.makePositionsArray(this.getColumnWidthValues()));
    }

    public DataWrapper getData() {
        TableDataModel tableDataModel = this.getDataSource();
        return tableDataModel instanceof JCBeanFileDataSource ? new DataWrapper(((JCBeanFileDataSource)tableDataModel).getName()) : new DataWrapper(tableDataModel.getNumRows(), tableDataModel.getNumColumns(), this.createArray(((JCVectorDataSource)tableDataModel).getRowLabels()), this.createArray(((JCVectorDataSource)tableDataModel).getColumnLabels()), this.createArray2D(((JCVectorDataSource)tableDataModel).getCells()));
    }

    public int getFrameBorderType() {
        CellBorderModel cellBorderModel = this.getFrameBorder();
        return cellBorderModel instanceof JCCellBorder ? ((JCCellBorder)cellBorderModel).getBorderType() : 0;
    }

    public FrozenCellLayoutWrapper getFrozenCellLayout() {
        return new FrozenCellLayoutWrapper(this.frozen_rows, this.frozen_columns, this.frozen_row_placement, this.frozen_column_placement);
    }

    public LabelLayoutWrapper getLabelLayout() {
        return new LabelLayoutWrapper(this.row_label_display, this.column_label_display, this.row_label_offset, this.column_label_offset, this.row_label_placement, this.column_label_placement);
    }

    public static int getNumEditorColumns() {
        return numColumns;
    }

    public static int getNumEditorRows() {
        return numRows;
    }

    public SBLayoutWrapper getSBLayout() {
        return new SBLayoutWrapper(this.hsb_display, this.vsb_display, this.hsb_attach, this.vsb_attach, this.hsb_offset, this.vsb_offset, this.hsb_position, this.vsb_position, this.hsb_track, this.vsb_track, this.hsb_track_row, this.vsb_track_column);
    }

    protected JCCellRange getSelectedRange() {
        Collection collection = this.getSelectedCells();
        if (collection == null) {
            return null;
        }
        JCCellRange jCCellRange = new JCCellRange(0, 0, 0, 0);
        Iterator iterator = collection.iterator();
        return iterator.hasNext() ? (JCCellRange)iterator.next() : null;
    }

    public SpannedCellsWrapper getSpannedCells() {
        Collection collection = this.getSpannedRanges();
        JCCellRange[] jCCellRangeArray = null;
        if (collection == null) {
            jCCellRangeArray = new JCCellRange[]{};
        } else {
            jCCellRangeArray = new JCCellRange[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof JCCellRange)) {
                    throw new IllegalArgumentException("Range item is not a JCCellRange instance");
                }
                jCCellRangeArray[n] = (JCCellRange)e;
                ++n;
            }
        }
        return new SpannedCellsWrapper(jCCellRangeArray);
    }

    public StyleWrapper getStyles() {
        List list = this.getCellStyleValues();
        CellRangeValue[] cellRangeValueArray = new CellRangeValue[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            cellRangeValueArray[n] = (CellRangeValue)iterator.next();
            ++n;
        }
        return new StyleWrapper(cellRangeValueArray);
    }

    public TableModel getSwingDataModel() {
        TableDataModel tableDataModel = this.getDataSource();
        return tableDataModel instanceof JCTableModelDataSource ? ((JCTableModelDataSource)tableDataModel).getTableModel() : null;
    }

    protected void makeDataSource(boolean bl) {
        JCVectorDataSource jCVectorDataSource = bl ? new JCEditableVectorDataSource() : new JCVectorDataSource();
        jCVectorDataSource.setNumRows(numRows);
        jCVectorDataSource.setNumColumns(numColumns);
        this.setVisibleRows(numRows);
        this.setVisibleColumns(numColumns);
        int n = 0;
        while (n < jCVectorDataSource.getNumColumns()) {
            jCVectorDataSource.setColumnLabel(n, "Col: " + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < jCVectorDataSource.getNumRows()) {
            jCVectorDataSource.setRowLabel(n2, "Row: " + n2);
            int n3 = 0;
            while (n3 < jCVectorDataSource.getNumColumns()) {
                jCVectorDataSource.setCell(n2, n3, "Cell");
                ++n3;
            }
            ++n2;
        }
        this.setDataSource(jCVectorDataSource);
        LiveTable.setNumEditorRows(numRows);
        LiveTable.setNumEditorColumns(numColumns);
    }

    protected PositionCellSize[] makePositionsArray(List list) {
        PositionCellSize[] positionCellSizeArray = new PositionCellSize[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PositionCellSize)) {
                throw new IllegalArgumentException("Range item is not a PositionCellSize instance");
            }
            positionCellSizeArray[n] = (PositionCellSize)e;
            ++n;
        }
        return positionCellSizeArray;
    }

    public void setAbout(String string) {
    }

    public void setCellRenderer(JCCellRenderer jCCellRenderer) {
        this.cellRenderer = jCCellRenderer;
    }

    public void setCellSize(CellSizeWrapper cellSizeWrapper) {
        if (cellSizeWrapper == null) {
            return;
        }
        int n = 0;
        while (n < cellSizeWrapper.rowPositions.length) {
            this.setRowCellSize(cellSizeWrapper.rowPositions[n].position, cellSizeWrapper.rowPositions[n].cell_size);
            ++n;
        }
        int n2 = 0;
        while (n2 < cellSizeWrapper.columnPositions.length) {
            this.setColumnCellSize(cellSizeWrapper.columnPositions[n2].position, cellSizeWrapper.columnPositions[n2].cell_size);
            ++n2;
        }
    }

    public void setData(DataWrapper dataWrapper) {
        if (dataWrapper == null) {
            return;
        }
        if (dataWrapper.isFile) {
            this.setDataSource(new JCBeanFileDataSource(dataWrapper.fileName));
        } else {
            this.setDataSource(new JCEditableVectorDataSource(dataWrapper.rows, dataWrapper.columns, this.createVector(dataWrapper.rowLabels), this.createVector(dataWrapper.columnLabels), this.createVector(dataWrapper.cellValues)));
        }
    }

    public void setFrameBorderType(int n) {
        this.setFrameBorder(new JCCellBorder(n));
        this.requestChange(4);
    }

    public void setFrozenCellLayout(FrozenCellLayoutWrapper frozenCellLayoutWrapper) {
        if (frozenCellLayoutWrapper == null) {
            return;
        }
        this.frozen_rows = frozenCellLayoutWrapper.rows;
        this.frozen_row_placement = frozenCellLayoutWrapper.rowPlacement;
        this.frozen_columns = frozenCellLayoutWrapper.columns;
        this.frozen_column_placement = frozenCellLayoutWrapper.columnPlacement;
        this.requestChange(8);
    }

    public void setLabelLayout(LabelLayoutWrapper labelLayoutWrapper) {
        if (labelLayoutWrapper == null) {
            return;
        }
        this.row_label_display = labelLayoutWrapper.rowDisplay;
        this.row_label_offset = labelLayoutWrapper.rowOffset;
        this.row_label_placement = labelLayoutWrapper.rowPlacement;
        this.column_label_display = labelLayoutWrapper.columnDisplay;
        this.column_label_offset = labelLayoutWrapper.columnOffset;
        this.column_label_placement = labelLayoutWrapper.columnPlacement;
        this.requestChange(2);
    }

    public static void setNumEditorColumns(int n) {
        numColumns = n;
    }

    public static void setNumEditorRows(int n) {
        numRows = n;
    }

    public void setSBLayout(SBLayoutWrapper sBLayoutWrapper) {
        if (sBLayoutWrapper == null) {
            return;
        }
        this.hsb_display = sBLayoutWrapper.hsbDisplay;
        this.hsb_attach = sBLayoutWrapper.hsbAttach;
        this.hsb_offset = sBLayoutWrapper.hsbOffset;
        this.hsb_position = sBLayoutWrapper.hsbPosition;
        this.hsb_track = sBLayoutWrapper.hsbTrack;
        this.hsb_track_row = sBLayoutWrapper.hsbTrackRow;
        this.vsb_display = sBLayoutWrapper.vsblDisplay;
        this.vsb_attach = sBLayoutWrapper.vsbAttach;
        this.vsb_offset = sBLayoutWrapper.vsbOffset;
        this.vsb_position = sBLayoutWrapper.vsbPosition;
        this.vsb_track = sBLayoutWrapper.vsbTrack;
        this.vsb_track_column = sBLayoutWrapper.vsbTrackColumn;
        this.requestChange(8);
    }

    public void setSpannedCells(SpannedCellsWrapper spannedCellsWrapper) {
        if (spannedCellsWrapper == null) {
            return;
        }
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        int n = 0;
        while (n < spannedCellsWrapper.spannedCells.length) {
            vector.addElement(spannedCellsWrapper.spannedCells[n]);
            ++n;
        }
        this.setSpannedRanges(vector);
    }

    public void setStyles(StyleWrapper styleWrapper) {
        if (styleWrapper == null) {
            return;
        }
        int n = 0;
        while (n < styleWrapper.styles.length) {
            CellRangeValue cellRangeValue = styleWrapper.styles[n];
            CellStyleModel cellStyleModel = (CellStyleModel)cellRangeValue.value;
            if (cellStyleModel instanceof JCLiveCellStyle) {
                ((JCLiveCellStyle)cellStyleModel).setTable(this);
            }
            this.setCellStyle(new JCCellRange(cellRangeValue.start_row, cellRangeValue.start_column, cellRangeValue.end_row, cellRangeValue.end_column), cellStyleModel);
            ++n;
        }
        this.requestChange(2);
    }

    public void setSwingDataModel(TableModel tableModel) {
        JCTableModelDataSource jCTableModelDataSource = new JCTableModelDataSource(tableModel);
        if (jCTableModelDataSource.isEnabled()) {
            this.setDataSource(jCTableModelDataSource);
        }
    }
}

