/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.data.JCFileFormatParser;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.JCFormatParserUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class JCStandardFormatParser
implements JCFileFormatParser {
    protected StreamTokenizer tokenizer;
    public static final int PARSE_ERR_DATA_STYLE = 1;
    public static final int PARSE_ERR_VALUE = 2;
    public static final int PARSE_ERR_COLUMN_LABEL = 3;
    public static final int PARSE_ERR_ROW_LABEL = 4;
    protected boolean isDebug = false;
    protected boolean isLabels = false;

    protected static void displayErrorMessage(StreamTokenizer streamTokenizer, int n) {
        String string = new String("");
        switch (n) {
            case 1: {
                string = String.valueOf(string) + "Expect data type TABLE and not ";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Expect data value and not ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Expect a column label and not ";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "Expect a row label and not ";
                break;
            }
            default: {
                return;
            }
        }
        JCFormatParserUtil.displayErrorMessage(streamTokenizer, string);
    }

    protected static double getNextDouble(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            JCStandardFormatParser.displayErrorMessage(streamTokenizer, 2);
            throw new IOException("Error in data file format - " + streamTokenizer);
        }
        double d = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -3 && streamTokenizer.sval != null && (streamTokenizer.sval.charAt(0) == 'e' || streamTokenizer.sval.charAt(0) == 'E')) {
            if (streamTokenizer.sval.length() == 1) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -2) {
                    d *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else {
                String string = streamTokenizer.sval;
                int n = Integer.valueOf(streamTokenizer.sval.substring(1));
                d *= Math.pow(10.0, n);
            }
        } else {
            streamTokenizer.pushBack();
        }
        return d;
    }

    protected void initTokenizer(Reader reader) {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
    }

    public void readAndParse(Reader reader, JCVectorDataSource jCVectorDataSource) throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        this.initTokenizer(reader);
        if (this.tokenizer.nextToken() != -3) {
            bl = true;
        } else if (this.tokenizer.sval.equalsIgnoreCase("debug")) {
            this.isDebug = true;
            if (this.tokenizer.nextToken() != -3) {
                bl = true;
            }
        }
        if (bl || !this.tokenizer.sval.equalsIgnoreCase("table")) {
            JCStandardFormatParser.displayErrorMessage(this.tokenizer, 1);
            throw new IOException("Data must start with TABLE");
        }
        n = (int)JCStandardFormatParser.getNextDouble(this.tokenizer);
        n2 = (int)JCStandardFormatParser.getNextDouble(this.tokenizer);
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equalsIgnoreCase("nolabel")) {
            this.isLabels = false;
        } else {
            this.isLabels = true;
            this.tokenizer.pushBack();
        }
        if (this.isDebug) {
            System.out.println("Reading in TABLE format with " + n + " rows and " + n2 + " columns with " + (this.isLabels ? "labels" : "no labels"));
        }
        this.readArrayData(n, n2, jCVectorDataSource);
        this.tokenizer = null;
    }

    private void readArrayData(int n, int n2, JCVectorDataSource jCVectorDataSource) throws IOException {
        int n3;
        Object object = null;
        Vector<Object> vector = null;
        if (this.isLabels) {
            n3 = 0;
            while (n3 < n2) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                jCVectorDataSource.getColumnLabels().addElement(object);
                if (this.isDebug) {
                    System.out.println("Column Label " + n3 + " is " + object);
                }
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            if (this.isLabels) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                jCVectorDataSource.getRowLabels().addElement(object);
                if (this.isDebug) {
                    System.out.println("Row Label " + n4 + " is " + object);
                }
            }
            vector = new Vector<Object>();
            n3 = 0;
            while (n3 < n2) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                vector.addElement(object);
                if (this.isDebug) {
                    System.out.println("Value at row " + n4 + " col " + n3 + " is " + object);
                }
                ++n3;
            }
            jCVectorDataSource.getCells().addElement(vector);
            ++n4;
        }
        jCVectorDataSource.setNumRows(n);
        jCVectorDataSource.setNumColumns(n2);
    }
}

