/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Divide
extends Operation {
    public Divide(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Divide(Expression expression, Number number) {
        super(expression, number);
    }

    public Divide(Number number, Expression expression) {
        super(number, expression);
    }

    public Divide(Number number, Number number2) {
        super(number, number2);
    }

    private Number divideSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() / number2.doubleValue());
        }
        return new Integer(number.intValue() / number2.intValue());
    }

    private MathValue doDivision(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.divideSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathScalar) {
            MathVector mathVector = (MathVector)mathValue;
            MathScalar mathScalar = (MathScalar)mathValue2;
            Number[] numberArray = new Number[mathVector.size];
            int n = 0;
            while (n < mathVector.size) {
                numberArray[n] = this.divideSimple(mathVector.realValues[n], mathScalar.realValue);
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathScalar) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathScalar mathScalar = (MathScalar)mathValue2;
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n2 = 0;
                while (n2 < mathMatrix.columns) {
                    numberArray[n][n2] = this.divideSimple(mathMatrix.realValues[n][n2], mathScalar.realValue);
                    ++n2;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot divide by a vector or a matrix");
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Division is not defined on zero operands");
        }
        if (this.leftOperand == null) {
            return this.getResult(new MathScalar(new Integer(1)), this.rightOperand);
        }
        if (this.rightOperand == null) {
            return this.getResult(new MathScalar(new Integer(1)), this.leftOperand);
        }
        return this.getResult(this.leftOperand, this.rightOperand);
    }

    private Result getResult(Expression expression, Expression expression2) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression2 instanceof Operation || expression2 instanceof ExpressionReference) {
            expression2 = expression2.evaluate();
        }
        if (expression instanceof MathValue && expression2 instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            MathValue mathValue2 = (MathValue)expression2;
            return this.doDivision(mathValue, mathValue2);
        }
        if (expression instanceof ExpressionList && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            ExpressionList expressionList2 = (ExpressionList)expression2;
            if (expressionList.size() != expressionList2.size()) {
                throw new OperandMismatchException("Cannot divide lists of different sizes");
            }
            Iterator iterator = expressionList.iterator();
            Iterator iterator2 = expressionList2.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression3 = (Expression)iterator.next();
                Expression expression4 = (Expression)iterator2.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression3, expression4));
            }
            return mathExpressionList;
        }
        if (expression instanceof MathValue && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression2;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression5 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression, expression5));
            }
            return mathExpressionList;
        }
        if (expression instanceof ExpressionList && expression2 instanceof MathValue) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression6, expression2));
            }
            return mathExpressionList;
        }
        throw new OperandMismatchException("Cannot divide given data types");
    }
}

