/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.RealComparator;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Median
extends Operation {
    public Median(Expression expression) {
        super(expression);
    }

    public Median(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    private void addElements(ExpressionList expressionList, Expression expression) {
        if (expression instanceof MathValue) {
            if (expression instanceof MathVector || expression instanceof MathMatrix) {
                throw new IllegalArgumentException("Median:  No ordering defined for vectors or matrices");
            }
            expressionList.add(expression);
        } else if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expressionList.add(expression.evaluate());
        } else if (expression instanceof ExpressionList) {
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                this.addElements(expressionList, expression2);
            }
        } else {
            throw new IllegalArgumentException("Median:  Unrecognised math type in ExpressionList");
        }
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Median is not defined on zero operands");
        }
        MathExpressionList mathExpressionList = new MathExpressionList();
        if (this.leftOperand != null) {
            this.addElements(mathExpressionList, this.leftOperand);
        }
        if (this.rightOperand != null) {
            this.addElements(mathExpressionList, this.rightOperand);
        }
        int n = ((ExpressionList)mathExpressionList).size();
        int n2 = (n + 1) / 2;
        MathValue mathValue = this.findLocation(mathExpressionList, n2);
        return mathValue;
    }

    private MathValue findLocation(ExpressionList expressionList, int n) {
        MathValue mathValue = (MathValue)expressionList.get(n);
        RealComparator realComparator = new RealComparator();
        MathExpressionList mathExpressionList = new MathExpressionList();
        MathExpressionList mathExpressionList2 = new MathExpressionList();
        MathExpressionList mathExpressionList3 = new MathExpressionList();
        Iterator iterator = expressionList.iterator();
        while (iterator.hasNext()) {
            MathValue mathValue2 = (MathValue)iterator.next();
            if (realComparator.compare(mathValue2, mathValue) < 0) {
                ((ExpressionList)mathExpressionList).add(mathValue2);
                continue;
            }
            if (realComparator.compare(mathValue2, mathValue) > 0) {
                ((ExpressionList)mathExpressionList2).add(mathValue2);
                continue;
            }
            ((ExpressionList)mathExpressionList3).add(mathValue2);
        }
        if (((ExpressionList)mathExpressionList).size() >= n + 1) {
            return this.findLocation(mathExpressionList, n);
        }
        if (((ExpressionList)mathExpressionList3).size() >= (n -= ((ExpressionList)mathExpressionList).size()) + 1) {
            return mathValue;
        }
        if (((ExpressionList)mathExpressionList2).size() >= (n -= ((ExpressionList)mathExpressionList3).size()) + 1) {
            return this.findLocation(mathExpressionList2, n);
        }
        throw new IllegalArgumentException("Median:  invalid MathValues in list");
    }
}

